<?php

	include_once '../../vendor/autoload.php';
	require_once '../../util/DealStages.php';

	use HubSpot\Factory;

	$dotenv = Dotenv\Dotenv::createImmutable('../../');
	$dotenv->load();

	$apiKey = $_ENV['API_KEY'];

	$key = $_GET['apiKey'];

	if ($key && $key == $apiKey) {		

		$tokens = Factory::create()->auth()->oAuth()->tokensApi()->create(
	                'refresh_token',                
			null,
			$_ENV['CALLBACK_PATH'],
	                $_ENV['HUBSPOT_CLIENT_ID'],
	                $_ENV['HUBSPOT_CLIENT_SECRET'], 
	                $_ENV['REFRESH_TOKEN']
	            );
		$hubspot = Factory::createWithAccessToken($tokens['access_token']);

		// echo var_dump($tokens);
		
		$data = json_decode(file_get_contents('php://input'), true);

		// Search for contact

		$filter = new \HubSpot\Client\Crm\Contacts\Model\Filter();
		$filter
		    ->setOperator('EQ')
		    ->setPropertyName('email')
		    ->setValue($data['email']);

        $filter2 = new \HubSpot\Client\Crm\Contacts\Model\Filter();
        $filter2
            ->setOperator('EQ')
            ->setPropertyName('hs_additional_emails')
            ->setValue($data['email']);


		$filterGroup = new \HubSpot\Client\Crm\Contacts\Model\FilterGroup();
		$filterGroup->setFilters([$filter]);

        $filterGroup2 = new \HubSpot\Client\Crm\Contacts\Model\FilterGroup();
        $filterGroup2->setFilters([$filter2]);


		$searchRequest = new \HubSpot\Client\Crm\Contacts\Model\PublicObjectSearchRequest();
		$searchRequest->setFilterGroups([$filterGroup, $filterGroup2]);

		// Get specific properties
		$searchRequest->setProperties(['firstname', 'lastname', 'date_of_birth', 'email', 'hs_additional_emails']);
		$contactsPage = $hubspot->crm()->contacts()->searchApi()->doSearch($searchRequest);		

		// Prepare object
        $contactInput = new \HubSpot\Client\Crm\Contacts\Model\SimplePublicObjectInput();
        $contactInput->setProperties([
			'id_wegrant' => $data['id_wegrant'],
			'hs_object_id' => $data['hs_object_id'],
			'firstname' => $data['firstname'],
            'email' => $data['email'],						
			'phone' => $data['phone'],
			'hubspot_owner_id' => $data['hubspot_owner_id'],
			'nif_nie' => $data['nif_nie'],
			'company' => $data['company'],
			'jobtitle' => $data['jobtitle'],
			'acepta_boletin_newsletter' => $data['acepta_boletin_newsletter'],
			'hs_marketable_status' => $data['hs_marketable_status'],
			//'token_usuario' => $data['token_usuario'],
			'sector_empresa' => $data['sector_empresa'],
			'temas_entornos' => $data['temas_entornos'],
			'cif' => $data['cif']						
			'nombre_empresa' => $data['nombre_empresa'],			
			'provincias__api_' => $data['provincias__api_'],
			'tipo_de_empresa' => $data['tipo_de_empresa'],
			'zip' => $data['zip'],
			'sector_de_actividad__cnae_' => $data['sector_de_actividad__cnae_'],
			// Marketing contact
		]);

/*

  "id_wegrant": "111",
  "firstname": "Jose Manuel",
  "email": "jmsanz@tufinanziacion.com",
  "": "602210950",
  "": "",
  "": "12345678J",
  "": "company",
  "": "jobtitle",
  "": "false",
  "": "",
  "": "1",
  "": "03112",
  "": "1",
  "": "1",
  "provincias__api_": "43",
  "": "123",
  "": "12345678Z"

*/


		$contactId = -1;
		$dealId = -1;
		// Update		
		if ($contactsPage['total'] == 1) {			
			echo "Update";
			$contactId = $contactsPage['results'][0]['id'];
			try {
				$hubspot->crm()->contacts()->basicApi()->update($contactId, $contactInput);
			} catch (Exception $e) {
				echo 'Exception: ', $e->getMessage(), "\n";
			}
		} else { // Create
			echo "Create";
			$contactInput->setProperties([
				'email' => $data['email_usuario']
			]);
			$contact = $hubspot->crm()->contacts()->basicApi()->create($contactInput);
			$contactId = $contact['id'];			
		}

		// if ($contactId != -1) {
		// 	try {
		// 		$apiResponse = $hubspot->crm()->associations()->v4()->basicApi()->getPage('Contacts', intval($contactId), 'Deals', 500);							
		// 		if (count($apiResponse['results']) > 0 ) {
		// 			$dealId = $apiResponse['results'][0]['to_object_id'];					
		// 		}
		// 	} catch (ApiException $e) {
		// 		echo "Exception when calling basic_api->get_page: ", $e->getMessage();
		// 	}
		// 	// Prepare the deal
			
		// 	$dealInput = new \HubSpot\Client\Crm\Deals\Model\SimplePublicObjectInput();
		// 	$dealInput->setProperties([
		// 		"dealname" => $data["nombre_empresa"] . " - nuevo Negocio",
		// 		"id_solicitud" => $data["id_solicitud"],
		// 		"temas_entornos" => $data["entorno"],
		// 		"estados_solicitud" => $data["id_estado"],
		// 		"company" => $data["nombre_empresa"],
		// 		"tipo_de_empresa" => $data["tipo_empresa"],
		// 		"cif" => $data["cif"],
		// 		"zip" => $data["codigo_postal"],
		// 		"provincia" => $data["provincia"],
		// 		"name" => $data["persona_contacto"],
		// 		"phone" => $data["telefono"],
		// 		"email" => $data["email"],
		// 		"origen_solicitud" => $data["origen"],
		// 		"nombre_ayuda" => $data["nombre_ayuda"],
		// 		"tipo_de_ayuda" => $data["tipo_ayuda"],
		// 		"presupuesto_total" => str_replace(",",".",$data["presupuesto_total"]),
		// 		"amount" => str_replace(",",".",$data["presupuesto_total"]),
		// 		"importe_maximo_ayuda" => str_replace(",",".",$data["importe_max_ayuda"]),
		// 		"pipeline" => "default",
		// 		"dealstage" => DealStages::getDealStage($data["id_estado"]) 
		// 	]);

		// 	// Search Deal

		// 	if ($dealId != -1) {
		// 		try {
		// 			$hubspot->crm()->deals()->basicApi()->update($dealId, $dealInput);					
		// 		} catch (Exception $e) {
		// 			echo 'Exception: ', $e->getMessage(), "\n";
		// 		}
		// 	} else {
		// 		try {
		// 			$deal = $hubspot->crm()->deals()->basicApi()->create($dealInput);					
		// 			$dealId = $deal['id'];					
		// 			try {
		// 				$apiResponse = $hubspot->crm()->associations()->v4()->basicApi()->createDefault('Contacts', $contactId, 'Deals', $dealId);						
		// 			} catch (ApiException $e) {
		// 				echo "Exception when calling basic_api->create_default: ", $e->getMessage();
		// 			}
		// 		} catch (Exception $e) {
		// 			echo 'Exception: ',$e->getResponseBody(), "\n";
		// 		}
		// 	}
			

		// }
		

	} else {
		echo "Enhoy the Silence";
	}
?>
