<?php

	include_once '../vendor/autoload.php';
	require_once '../util/SessionManager.php';
	require_once '../util/DealStages.php';

	use HubSpot\Factory;

	$dotenv = Dotenv\Dotenv::createImmutable('../');
	$dotenv->load();

	$apiKey = $_GET['apiKey'];


	$url = $_ENV['ENDPOINT_URL'];
	$usuario = $_ENV['ENDPOINT_USUARIO'];
	$password = $_ENV['ENDPOINT_PASSWORD'];

	if ($apiKey && $apiKey == 'eu1-a7fd-fc14-492e-8b2a-7d5b64fddb4') {

	$session = SessionManager::loadJson();

	$refresh_token = $session != null ? $session['refresh_token'] : $_ENV['REFRESH_TOKEN'];

	$tokens = Factory::create()->auth()->oAuth()->tokensApi()->create(
                'refresh_token',                
		null,
		$_ENV['CALLBACK_PATH'],
                $_ENV['HUBSPOT_CLIENT_ID'],
                $_ENV['HUBSPOT_CLIENT_SECRET'], 
                $refresh_token
            );

	SessionManager::saveJson($tokens);

	try {
		$data = json_decode(file_get_contents('php://input'), true);
		file_put_contents('data.json',json_encode($data));
	} catch (Exception $ex) {
		$data = null;
	}
	if ($data != null) {
		$lenght = count($data);
		for ($i = 0 ; $i < $lenght; $i++) {
			$item = $data[$i];
			$id = $item['objectId'];
			$event = $item['subscriptionType'];
			$property = $item['propertyName'];
			$value = $item['propertyValue'];
			// Check event type
			if ($event == 'deal.propertyChange' && $property == 'dealstage') {
				try {					
					$hubspot = Factory::createWithAccessToken($tokens['access_token']);
					$object = $hubspot->crm()->deals()->basicApi()->getById($id,['estados_solicitud','id_solicitud']);
					$id_estado = -1;
					$id_solicitud = -1;
					$id_estado_nuevo = -1;
					if ($object) {
						$id_estado = intval($object->getProperties()['estados_solicitud']);
						$id_solicitud = intval($object->getProperties()['id_solicitud']);
						$id_estado_nuevo = DealStages::fromDealStage($value);
						if ($id_estado != $id_estado_nuevo) {
							// Actualizar estado
							if ($id != -1) {
								try {
									$dealInput = new \HubSpot\Client\Crm\Deals\Model\SimplePublicObjectInput();
									$dealInput->setProperties([
										"estados_solicitud" => $id_estado_nuevo
									]);
									$hubspot->crm()->deals()->basicApi()->update($id, $dealInput);					
								} catch (Exception $e) {
									echo 'Exception: ', $e->getMessage(), "\n";
								}
							}
						}
					}					
					// if ($object && $object					
					if ($id_estado_nuevo !=-1 && $id_solicitud != -1) {
						// Enviar info a su API
						
						// URL del recurso al que deseas enviar la solicitud POST


						// Datos que deseas enviar en el cuerpo de la solicitud POST
						$data = [
							'action' => 'actualizar_estado',					 
							'user' => $usuario,					 
							'pass' => $_ENV['ENDPOINT_API_PASSWORD'],
							'data' => base64_encode(json_encode([					 
							  'id_solicitud' => $id_solicitud, //int					 
							  'id_estado' => $id_estado_nuevo,//int					 
							]))					 
						];

						$datosCodificados = json_encode($data);

						// Credenciales de autenticación
						//$username = 'leadin';
						//$password = 'TriestE342';

						// Inicializar cURL
						$ch = curl_init($url);

						// Configurar opciones de cURL
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
						curl_setopt($ch, CURLOPT_POST, true);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $datosCodificados);

						// Configurar la autenticación Digest
						curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST);
						curl_setopt($ch, CURLOPT_USERPWD, "$usuario:$password");

						// Ejecutar la solicitud cURL y almacenar la respuesta en $response
						$response = curl_exec($ch);

						// Verificar si hubo errores en la solicitud
						if (curl_errno($ch)) {
							echo 'Error en la solicitud cURL: ' . curl_error($ch);
						}

						// Cerrar la sesión cURL
						curl_close($ch);

						// Imprimir la respuesta del servidor
						echo $response;

					}
				} catch (\Throwable $th) {
					echo $th->getMessage();
					echo "Not found";
				}

				
			}
		}
	}

	} else {
		echo "Enjoy the silence";
	}
?>
