<?php

class SessionManager
{
    private const SESSION_FILE = '../.session';

    public static function saveJson($data)
    {
        $jsonData = json_encode($data);

        file_put_contents(self::SESSION_FILE, $jsonData);
    }

    public static function loadJson()
    {
        if (!file_exists(self::SESSION_FILE)) {
            return null;
        }

        $jsonData = file_get_contents(self::SESSION_FILE);
        $data = json_decode($jsonData, true);

        return $data;
    }
}
