<?php
/**
 * FieldTypeDefinition
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Automation\Actions
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Custom Workflow Actions
 *
 * Create custom workflow actions
 *
 * The version of the OpenAPI document: v4
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Automation\Actions\Model;

use \ArrayAccess;
use \HubSpot\Client\Automation\Actions\ObjectSerializer;

/**
 * FieldTypeDefinition Class Doc Comment
 *
 * @category Class
 * @description The data type expected by an input field.
 * @package  HubSpot\Client\Automation\Actions
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FieldTypeDefinition implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FieldTypeDefinition';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'type' => 'string',
        'field_type' => 'string',
        'options' => '\HubSpot\Client\Automation\Actions\Model\Option[]',
        'options_url' => 'string',
        'referenced_object_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'type' => null,
        'field_type' => null,
        'options' => null,
        'options_url' => null,
        'referenced_object_type' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'type' => 'type',
        'field_type' => 'fieldType',
        'options' => 'options',
        'options_url' => 'optionsUrl',
        'referenced_object_type' => 'referencedObjectType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'type' => 'setType',
        'field_type' => 'setFieldType',
        'options' => 'setOptions',
        'options_url' => 'setOptionsUrl',
        'referenced_object_type' => 'setReferencedObjectType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'type' => 'getType',
        'field_type' => 'getFieldType',
        'options' => 'getOptions',
        'options_url' => 'getOptionsUrl',
        'referenced_object_type' => 'getReferencedObjectType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE_STRING = 'string';
    public const TYPE_NUMBER = 'number';
    public const TYPE_BOOL = 'bool';
    public const TYPE_DATETIME = 'datetime';
    public const TYPE_ENUMERATION = 'enumeration';
    public const TYPE_DATE = 'date';
    public const TYPE_PHONE_NUMBER = 'phone_number';
    public const TYPE_CURRENCY_NUMBER = 'currency_number';
    public const TYPE_JSON = 'json';
    public const TYPE_OBJECT_COORDINATES = 'object_coordinates';
    public const FIELD_TYPE_BOOLEANCHECKBOX = 'booleancheckbox';
    public const FIELD_TYPE_CHECKBOX = 'checkbox';
    public const FIELD_TYPE_DATE = 'date';
    public const FIELD_TYPE_FILE = 'file';
    public const FIELD_TYPE_NUMBER = 'number';
    public const FIELD_TYPE_PHONENUMBER = 'phonenumber';
    public const FIELD_TYPE_RADIO = 'radio';
    public const FIELD_TYPE_SELECT = 'select';
    public const FIELD_TYPE_TEXT = 'text';
    public const FIELD_TYPE_TEXTAREA = 'textarea';
    public const FIELD_TYPE_CALCULATION_EQUATION = 'calculation_equation';
    public const FIELD_TYPE_CALCULATION_ROLLUP = 'calculation_rollup';
    public const FIELD_TYPE_CALCULATION_SCORE = 'calculation_score';
    public const FIELD_TYPE_CALCULATION_READ_TIME = 'calculation_read_time';
    public const FIELD_TYPE_UNKNOWN = 'unknown';
    public const REFERENCED_OBJECT_TYPE_CONTACT = 'CONTACT';
    public const REFERENCED_OBJECT_TYPE_COMPANY = 'COMPANY';
    public const REFERENCED_OBJECT_TYPE_DEAL = 'DEAL';
    public const REFERENCED_OBJECT_TYPE_ENGAGEMENT = 'ENGAGEMENT';
    public const REFERENCED_OBJECT_TYPE_TICKET = 'TICKET';
    public const REFERENCED_OBJECT_TYPE_OWNER = 'OWNER';
    public const REFERENCED_OBJECT_TYPE_PRODUCT = 'PRODUCT';
    public const REFERENCED_OBJECT_TYPE_LINE_ITEM = 'LINE_ITEM';
    public const REFERENCED_OBJECT_TYPE_BET_DELIVERABLE_SERVICE = 'BET_DELIVERABLE_SERVICE';
    public const REFERENCED_OBJECT_TYPE_CONTENT = 'CONTENT';
    public const REFERENCED_OBJECT_TYPE_CONVERSATION = 'CONVERSATION';
    public const REFERENCED_OBJECT_TYPE_BET_ALERT = 'BET_ALERT';
    public const REFERENCED_OBJECT_TYPE_PORTAL = 'PORTAL';
    public const REFERENCED_OBJECT_TYPE_QUOTE = 'QUOTE';
    public const REFERENCED_OBJECT_TYPE_FORM_SUBMISSION_INBOUNDDB = 'FORM_SUBMISSION_INBOUNDDB';
    public const REFERENCED_OBJECT_TYPE_QUOTA = 'QUOTA';
    public const REFERENCED_OBJECT_TYPE_UNSUBSCRIBE = 'UNSUBSCRIBE';
    public const REFERENCED_OBJECT_TYPE_COMMUNICATION = 'COMMUNICATION';
    public const REFERENCED_OBJECT_TYPE_FEEDBACK_SUBMISSION = 'FEEDBACK_SUBMISSION';
    public const REFERENCED_OBJECT_TYPE_ATTRIBUTION = 'ATTRIBUTION';
    public const REFERENCED_OBJECT_TYPE_SALESFORCE_SYNC_ERROR = 'SALESFORCE_SYNC_ERROR';
    public const REFERENCED_OBJECT_TYPE_RESTORABLE_CRM_OBJECT = 'RESTORABLE_CRM_OBJECT';
    public const REFERENCED_OBJECT_TYPE_HUB = 'HUB';
    public const REFERENCED_OBJECT_TYPE_LANDING_PAGE = 'LANDING_PAGE';
    public const REFERENCED_OBJECT_TYPE_PRODUCT_OR_FOLDER = 'PRODUCT_OR_FOLDER';
    public const REFERENCED_OBJECT_TYPE_TASK = 'TASK';
    public const REFERENCED_OBJECT_TYPE_FORM = 'FORM';
    public const REFERENCED_OBJECT_TYPE_MARKETING_EMAIL = 'MARKETING_EMAIL';
    public const REFERENCED_OBJECT_TYPE_AD_ACCOUNT = 'AD_ACCOUNT';
    public const REFERENCED_OBJECT_TYPE_AD_CAMPAIGN = 'AD_CAMPAIGN';
    public const REFERENCED_OBJECT_TYPE_AD_GROUP = 'AD_GROUP';
    public const REFERENCED_OBJECT_TYPE_AD = 'AD';
    public const REFERENCED_OBJECT_TYPE_KEYWORD = 'KEYWORD';
    public const REFERENCED_OBJECT_TYPE_CAMPAIGN = 'CAMPAIGN';
    public const REFERENCED_OBJECT_TYPE_SOCIAL_CHANNEL = 'SOCIAL_CHANNEL';
    public const REFERENCED_OBJECT_TYPE_SOCIAL_POST = 'SOCIAL_POST';
    public const REFERENCED_OBJECT_TYPE_SITE_PAGE = 'SITE_PAGE';
    public const REFERENCED_OBJECT_TYPE_BLOG_POST = 'BLOG_POST';
    public const REFERENCED_OBJECT_TYPE_IMPORT = 'IMPORT';
    public const REFERENCED_OBJECT_TYPE_EXPORT = 'EXPORT';
    public const REFERENCED_OBJECT_TYPE_CTA = 'CTA';
    public const REFERENCED_OBJECT_TYPE_TASK_TEMPLATE = 'TASK_TEMPLATE';
    public const REFERENCED_OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW = 'AUTOMATION_PLATFORM_FLOW';
    public const REFERENCED_OBJECT_TYPE_OBJECT_LIST = 'OBJECT_LIST';
    public const REFERENCED_OBJECT_TYPE_NOTE = 'NOTE';
    public const REFERENCED_OBJECT_TYPE_MEETING_EVENT = 'MEETING_EVENT';
    public const REFERENCED_OBJECT_TYPE_CALL = 'CALL';
    public const REFERENCED_OBJECT_TYPE_EMAIL = 'EMAIL';
    public const REFERENCED_OBJECT_TYPE_PUBLISHING_TASK = 'PUBLISHING_TASK';
    public const REFERENCED_OBJECT_TYPE_CONVERSATION_SESSION = 'CONVERSATION_SESSION';
    public const REFERENCED_OBJECT_TYPE_CONTACT_CREATE_ATTRIBUTION = 'CONTACT_CREATE_ATTRIBUTION';
    public const REFERENCED_OBJECT_TYPE_INVOICE = 'INVOICE';
    public const REFERENCED_OBJECT_TYPE_MARKETING_EVENT = 'MARKETING_EVENT';
    public const REFERENCED_OBJECT_TYPE_CONVERSATION_INBOX = 'CONVERSATION_INBOX';
    public const REFERENCED_OBJECT_TYPE_CHATFLOW = 'CHATFLOW';
    public const REFERENCED_OBJECT_TYPE_MEDIA_BRIDGE = 'MEDIA_BRIDGE';
    public const REFERENCED_OBJECT_TYPE_SEQUENCE = 'SEQUENCE';
    public const REFERENCED_OBJECT_TYPE_SEQUENCE_STEP = 'SEQUENCE_STEP';
    public const REFERENCED_OBJECT_TYPE_FORECAST = 'FORECAST';
    public const REFERENCED_OBJECT_TYPE_SNIPPET = 'SNIPPET';
    public const REFERENCED_OBJECT_TYPE_TEMPLATE = 'TEMPLATE';
    public const REFERENCED_OBJECT_TYPE_UNKNOWN = 'UNKNOWN';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_STRING,
            self::TYPE_NUMBER,
            self::TYPE_BOOL,
            self::TYPE_DATETIME,
            self::TYPE_ENUMERATION,
            self::TYPE_DATE,
            self::TYPE_PHONE_NUMBER,
            self::TYPE_CURRENCY_NUMBER,
            self::TYPE_JSON,
            self::TYPE_OBJECT_COORDINATES,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFieldTypeAllowableValues()
    {
        return [
            self::FIELD_TYPE_BOOLEANCHECKBOX,
            self::FIELD_TYPE_CHECKBOX,
            self::FIELD_TYPE_DATE,
            self::FIELD_TYPE_FILE,
            self::FIELD_TYPE_NUMBER,
            self::FIELD_TYPE_PHONENUMBER,
            self::FIELD_TYPE_RADIO,
            self::FIELD_TYPE_SELECT,
            self::FIELD_TYPE_TEXT,
            self::FIELD_TYPE_TEXTAREA,
            self::FIELD_TYPE_CALCULATION_EQUATION,
            self::FIELD_TYPE_CALCULATION_ROLLUP,
            self::FIELD_TYPE_CALCULATION_SCORE,
            self::FIELD_TYPE_CALCULATION_READ_TIME,
            self::FIELD_TYPE_UNKNOWN,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getReferencedObjectTypeAllowableValues()
    {
        return [
            self::REFERENCED_OBJECT_TYPE_CONTACT,
            self::REFERENCED_OBJECT_TYPE_COMPANY,
            self::REFERENCED_OBJECT_TYPE_DEAL,
            self::REFERENCED_OBJECT_TYPE_ENGAGEMENT,
            self::REFERENCED_OBJECT_TYPE_TICKET,
            self::REFERENCED_OBJECT_TYPE_OWNER,
            self::REFERENCED_OBJECT_TYPE_PRODUCT,
            self::REFERENCED_OBJECT_TYPE_LINE_ITEM,
            self::REFERENCED_OBJECT_TYPE_BET_DELIVERABLE_SERVICE,
            self::REFERENCED_OBJECT_TYPE_CONTENT,
            self::REFERENCED_OBJECT_TYPE_CONVERSATION,
            self::REFERENCED_OBJECT_TYPE_BET_ALERT,
            self::REFERENCED_OBJECT_TYPE_PORTAL,
            self::REFERENCED_OBJECT_TYPE_QUOTE,
            self::REFERENCED_OBJECT_TYPE_FORM_SUBMISSION_INBOUNDDB,
            self::REFERENCED_OBJECT_TYPE_QUOTA,
            self::REFERENCED_OBJECT_TYPE_UNSUBSCRIBE,
            self::REFERENCED_OBJECT_TYPE_COMMUNICATION,
            self::REFERENCED_OBJECT_TYPE_FEEDBACK_SUBMISSION,
            self::REFERENCED_OBJECT_TYPE_ATTRIBUTION,
            self::REFERENCED_OBJECT_TYPE_SALESFORCE_SYNC_ERROR,
            self::REFERENCED_OBJECT_TYPE_RESTORABLE_CRM_OBJECT,
            self::REFERENCED_OBJECT_TYPE_HUB,
            self::REFERENCED_OBJECT_TYPE_LANDING_PAGE,
            self::REFERENCED_OBJECT_TYPE_PRODUCT_OR_FOLDER,
            self::REFERENCED_OBJECT_TYPE_TASK,
            self::REFERENCED_OBJECT_TYPE_FORM,
            self::REFERENCED_OBJECT_TYPE_MARKETING_EMAIL,
            self::REFERENCED_OBJECT_TYPE_AD_ACCOUNT,
            self::REFERENCED_OBJECT_TYPE_AD_CAMPAIGN,
            self::REFERENCED_OBJECT_TYPE_AD_GROUP,
            self::REFERENCED_OBJECT_TYPE_AD,
            self::REFERENCED_OBJECT_TYPE_KEYWORD,
            self::REFERENCED_OBJECT_TYPE_CAMPAIGN,
            self::REFERENCED_OBJECT_TYPE_SOCIAL_CHANNEL,
            self::REFERENCED_OBJECT_TYPE_SOCIAL_POST,
            self::REFERENCED_OBJECT_TYPE_SITE_PAGE,
            self::REFERENCED_OBJECT_TYPE_BLOG_POST,
            self::REFERENCED_OBJECT_TYPE_IMPORT,
            self::REFERENCED_OBJECT_TYPE_EXPORT,
            self::REFERENCED_OBJECT_TYPE_CTA,
            self::REFERENCED_OBJECT_TYPE_TASK_TEMPLATE,
            self::REFERENCED_OBJECT_TYPE_AUTOMATION_PLATFORM_FLOW,
            self::REFERENCED_OBJECT_TYPE_OBJECT_LIST,
            self::REFERENCED_OBJECT_TYPE_NOTE,
            self::REFERENCED_OBJECT_TYPE_MEETING_EVENT,
            self::REFERENCED_OBJECT_TYPE_CALL,
            self::REFERENCED_OBJECT_TYPE_EMAIL,
            self::REFERENCED_OBJECT_TYPE_PUBLISHING_TASK,
            self::REFERENCED_OBJECT_TYPE_CONVERSATION_SESSION,
            self::REFERENCED_OBJECT_TYPE_CONTACT_CREATE_ATTRIBUTION,
            self::REFERENCED_OBJECT_TYPE_INVOICE,
            self::REFERENCED_OBJECT_TYPE_MARKETING_EVENT,
            self::REFERENCED_OBJECT_TYPE_CONVERSATION_INBOX,
            self::REFERENCED_OBJECT_TYPE_CHATFLOW,
            self::REFERENCED_OBJECT_TYPE_MEDIA_BRIDGE,
            self::REFERENCED_OBJECT_TYPE_SEQUENCE,
            self::REFERENCED_OBJECT_TYPE_SEQUENCE_STEP,
            self::REFERENCED_OBJECT_TYPE_FORECAST,
            self::REFERENCED_OBJECT_TYPE_SNIPPET,
            self::REFERENCED_OBJECT_TYPE_TEMPLATE,
            self::REFERENCED_OBJECT_TYPE_UNKNOWN,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = $data['name'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['field_type'] = $data['field_type'] ?? null;
        $this->container['options'] = $data['options'] ?? null;
        $this->container['options_url'] = $data['options_url'] ?? null;
        $this->container['referenced_object_type'] = $data['referenced_object_type'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getFieldTypeAllowableValues();
        if (!is_null($this->container['field_type']) && !in_array($this->container['field_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'field_type', must be one of '%s'",
                $this->container['field_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['options'] === null) {
            $invalidProperties[] = "'options' can't be null";
        }
        $allowedValues = $this->getReferencedObjectTypeAllowableValues();
        if (!is_null($this->container['referenced_object_type']) && !in_array($this->container['referenced_object_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'referenced_object_type', must be one of '%s'",
                $this->container['referenced_object_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The input field name.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type The data type of the field.
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets field_type
     *
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->container['field_type'];
    }

    /**
     * Sets field_type
     *
     * @param string|null $field_type Controls how the field appears in HubSpot.
     *
     * @return self
     */
    public function setFieldType($field_type)
    {
        $allowedValues = $this->getFieldTypeAllowableValues();
        if (!is_null($field_type) && !in_array($field_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'field_type', must be one of '%s'",
                    $field_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['field_type'] = $field_type;

        return $this;
    }

    /**
     * Gets options
     *
     * @return \HubSpot\Client\Automation\Actions\Model\Option[]
     */
    public function getOptions()
    {
        return $this->container['options'];
    }

    /**
     * Sets options
     *
     * @param \HubSpot\Client\Automation\Actions\Model\Option[] $options A list of valid options for the field value.
     *
     * @return self
     */
    public function setOptions($options)
    {
        $this->container['options'] = $options;

        return $this;
    }

    /**
     * Gets options_url
     *
     * @return string|null
     */
    public function getOptionsUrl()
    {
        return $this->container['options_url'];
    }

    /**
     * Sets options_url
     *
     * @param string|null $options_url A URL that will accept HTTPS requests when the valid options for the field are fetched.
     *
     * @return self
     */
    public function setOptionsUrl($options_url)
    {
        $this->container['options_url'] = $options_url;

        return $this;
    }

    /**
     * Gets referenced_object_type
     *
     * @return string|null
     */
    public function getReferencedObjectType()
    {
        return $this->container['referenced_object_type'];
    }

    /**
     * Sets referenced_object_type
     *
     * @param string|null $referenced_object_type This can be set to `OWNER` if the field should contain a HubSpot owner value.
     *
     * @return self
     */
    public function setReferencedObjectType($referenced_object_type)
    {
        $allowedValues = $this->getReferencedObjectTypeAllowableValues();
        if (!is_null($referenced_object_type) && !in_array($referenced_object_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'referenced_object_type', must be one of '%s'",
                    $referenced_object_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['referenced_object_type'] = $referenced_object_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


