<?php
/**
 * BackgroundImage
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Blogs\BlogPosts
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Blog Post endpoints
 *
 * Use these endpoints for interacting with Blog Posts, Blog Authors, and Blog Tags
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\Blogs\BlogPosts\Model;

use \ArrayAccess;
use \HubSpot\Client\Cms\Blogs\BlogPosts\ObjectSerializer;

/**
 * BackgroundImage Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Blogs\BlogPosts
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class BackgroundImage implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BackgroundImage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'image_url' => 'string',
        'background_size' => 'string',
        'background_position' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'image_url' => null,
        'background_size' => null,
        'background_position' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'image_url' => 'imageUrl',
        'background_size' => 'backgroundSize',
        'background_position' => 'backgroundPosition'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'image_url' => 'setImageUrl',
        'background_size' => 'setBackgroundSize',
        'background_position' => 'setBackgroundPosition'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'image_url' => 'getImageUrl',
        'background_size' => 'getBackgroundSize',
        'background_position' => 'getBackgroundPosition'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const BACKGROUND_POSITION_TOP_LEFT = 'TOP_LEFT';
    public const BACKGROUND_POSITION_TOP_CENTER = 'TOP_CENTER';
    public const BACKGROUND_POSITION_TOP_RIGHT = 'TOP_RIGHT';
    public const BACKGROUND_POSITION_MIDDLE_LEFT = 'MIDDLE_LEFT';
    public const BACKGROUND_POSITION_MIDDLE_CENTER = 'MIDDLE_CENTER';
    public const BACKGROUND_POSITION_MIDDLE_RIGHT = 'MIDDLE_RIGHT';
    public const BACKGROUND_POSITION_BOTTOM_LEFT = 'BOTTOM_LEFT';
    public const BACKGROUND_POSITION_BOTTOM_CENTER = 'BOTTOM_CENTER';
    public const BACKGROUND_POSITION_BOTTOM_RIGHT = 'BOTTOM_RIGHT';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getBackgroundPositionAllowableValues()
    {
        return [
            self::BACKGROUND_POSITION_TOP_LEFT,
            self::BACKGROUND_POSITION_TOP_CENTER,
            self::BACKGROUND_POSITION_TOP_RIGHT,
            self::BACKGROUND_POSITION_MIDDLE_LEFT,
            self::BACKGROUND_POSITION_MIDDLE_CENTER,
            self::BACKGROUND_POSITION_MIDDLE_RIGHT,
            self::BACKGROUND_POSITION_BOTTOM_LEFT,
            self::BACKGROUND_POSITION_BOTTOM_CENTER,
            self::BACKGROUND_POSITION_BOTTOM_RIGHT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['image_url'] = $data['image_url'] ?? null;
        $this->container['background_size'] = $data['background_size'] ?? null;
        $this->container['background_position'] = $data['background_position'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['image_url'] === null) {
            $invalidProperties[] = "'image_url' can't be null";
        }
        if ($this->container['background_size'] === null) {
            $invalidProperties[] = "'background_size' can't be null";
        }
        if ($this->container['background_position'] === null) {
            $invalidProperties[] = "'background_position' can't be null";
        }
        $allowedValues = $this->getBackgroundPositionAllowableValues();
        if (!is_null($this->container['background_position']) && !in_array($this->container['background_position'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'background_position', must be one of '%s'",
                $this->container['background_position'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets image_url
     *
     * @return string
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string $image_url image_url
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        $this->container['image_url'] = $image_url;

        return $this;
    }

    /**
     * Gets background_size
     *
     * @return string
     */
    public function getBackgroundSize()
    {
        return $this->container['background_size'];
    }

    /**
     * Sets background_size
     *
     * @param string $background_size background_size
     *
     * @return self
     */
    public function setBackgroundSize($background_size)
    {
        $this->container['background_size'] = $background_size;

        return $this;
    }

    /**
     * Gets background_position
     *
     * @return string
     */
    public function getBackgroundPosition()
    {
        return $this->container['background_position'];
    }

    /**
     * Sets background_position
     *
     * @param string $background_position background_position
     *
     * @return self
     */
    public function setBackgroundPosition($background_position)
    {
        $allowedValues = $this->getBackgroundPositionAllowableValues();
        if (!in_array($background_position, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'background_position', must be one of '%s'",
                    $background_position,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['background_position'] = $background_position;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


