<?php
/**
 * BlogPost
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Blogs\BlogPosts
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Blog Post endpoints
 *
 * Use these endpoints for interacting with Blog Posts, Blog Authors, and Blog Tags
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\Blogs\BlogPosts\Model;

use \ArrayAccess;
use \HubSpot\Client\Cms\Blogs\BlogPosts\ObjectSerializer;

/**
 * BlogPost Class Doc Comment
 *
 * @category Class
 * @description Model definition for a Blog Post.
 * @package  HubSpot\Client\Cms\Blogs\BlogPosts
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class BlogPost implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BlogPost';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'slug' => 'string',
        'content_group_id' => 'string',
        'campaign' => 'string',
        'category_id' => 'int',
        'state' => 'string',
        'name' => 'string',
        'mab_experiment_id' => 'string',
        'archived' => 'bool',
        'author_name' => 'string',
        'ab_test_id' => 'string',
        'created_by_id' => 'string',
        'updated_by_id' => 'string',
        'domain' => 'string',
        'ab_status' => 'string',
        'folder_id' => 'string',
        'widget_containers' => 'array<string,object>',
        'widgets' => 'array<string,object>',
        'language' => 'string',
        'translated_from_id' => 'string',
        'translations' => 'array<string,\HubSpot\Client\Cms\Blogs\BlogPosts\Model\ContentLanguageVariation>',
        'dynamic_page_data_source_type' => 'int',
        'dynamic_page_data_source_id' => 'string',
        'blog_author_id' => 'string',
        'tag_ids' => 'int[]',
        'html_title' => 'string',
        'enable_google_amp_output_override' => 'bool',
        'use_featured_image' => 'bool',
        'post_body' => 'string',
        'post_summary' => 'string',
        'rss_body' => 'string',
        'rss_summary' => 'string',
        'currently_published' => 'bool',
        'page_expiry_enabled' => 'bool',
        'page_expiry_redirect_id' => 'int',
        'page_expiry_redirect_url' => 'string',
        'page_expiry_date' => 'int',
        'include_default_custom_css' => 'bool',
        'enable_layout_stylesheets' => 'bool',
        'enable_domain_stylesheets' => 'bool',
        'publish_immediately' => 'bool',
        'featured_image' => 'string',
        'featured_image_alt_text' => 'string',
        'link_rel_canonical_url' => 'string',
        'content_type_category' => 'string',
        'attached_stylesheets' => 'array<string,object>[]',
        'meta_description' => 'string',
        'head_html' => 'string',
        'footer_html' => 'string',
        'archived_in_dashboard' => 'bool',
        'public_access_rules_enabled' => 'bool',
        'public_access_rules' => 'object[]',
        'layout_sections' => 'array<string,\HubSpot\Client\Cms\Blogs\BlogPosts\Model\LayoutSection>',
        'theme_settings_values' => 'array<string,object>',
        'url' => 'string',
        'password' => 'string',
        'current_state' => 'string',
        'publish_date' => '\DateTime',
        'created' => '\DateTime',
        'updated' => '\DateTime',
        'deleted_at' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'slug' => null,
        'content_group_id' => null,
        'campaign' => null,
        'category_id' => 'int32',
        'state' => null,
        'name' => null,
        'mab_experiment_id' => null,
        'archived' => null,
        'author_name' => null,
        'ab_test_id' => null,
        'created_by_id' => null,
        'updated_by_id' => null,
        'domain' => null,
        'ab_status' => null,
        'folder_id' => null,
        'widget_containers' => null,
        'widgets' => null,
        'language' => null,
        'translated_from_id' => null,
        'translations' => null,
        'dynamic_page_data_source_type' => 'int32',
        'dynamic_page_data_source_id' => null,
        'blog_author_id' => null,
        'tag_ids' => 'int64',
        'html_title' => null,
        'enable_google_amp_output_override' => null,
        'use_featured_image' => null,
        'post_body' => null,
        'post_summary' => null,
        'rss_body' => null,
        'rss_summary' => null,
        'currently_published' => null,
        'page_expiry_enabled' => null,
        'page_expiry_redirect_id' => 'int64',
        'page_expiry_redirect_url' => null,
        'page_expiry_date' => 'int64',
        'include_default_custom_css' => null,
        'enable_layout_stylesheets' => null,
        'enable_domain_stylesheets' => null,
        'publish_immediately' => null,
        'featured_image' => null,
        'featured_image_alt_text' => null,
        'link_rel_canonical_url' => null,
        'content_type_category' => null,
        'attached_stylesheets' => null,
        'meta_description' => null,
        'head_html' => null,
        'footer_html' => null,
        'archived_in_dashboard' => null,
        'public_access_rules_enabled' => null,
        'public_access_rules' => null,
        'layout_sections' => null,
        'theme_settings_values' => null,
        'url' => null,
        'password' => null,
        'current_state' => null,
        'publish_date' => 'date-time',
        'created' => 'date-time',
        'updated' => 'date-time',
        'deleted_at' => 'date-time'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'slug' => 'slug',
        'content_group_id' => 'contentGroupId',
        'campaign' => 'campaign',
        'category_id' => 'categoryId',
        'state' => 'state',
        'name' => 'name',
        'mab_experiment_id' => 'mabExperimentId',
        'archived' => 'archived',
        'author_name' => 'authorName',
        'ab_test_id' => 'abTestId',
        'created_by_id' => 'createdById',
        'updated_by_id' => 'updatedById',
        'domain' => 'domain',
        'ab_status' => 'abStatus',
        'folder_id' => 'folderId',
        'widget_containers' => 'widgetContainers',
        'widgets' => 'widgets',
        'language' => 'language',
        'translated_from_id' => 'translatedFromId',
        'translations' => 'translations',
        'dynamic_page_data_source_type' => 'dynamicPageDataSourceType',
        'dynamic_page_data_source_id' => 'dynamicPageDataSourceId',
        'blog_author_id' => 'blogAuthorId',
        'tag_ids' => 'tagIds',
        'html_title' => 'htmlTitle',
        'enable_google_amp_output_override' => 'enableGoogleAmpOutputOverride',
        'use_featured_image' => 'useFeaturedImage',
        'post_body' => 'postBody',
        'post_summary' => 'postSummary',
        'rss_body' => 'rssBody',
        'rss_summary' => 'rssSummary',
        'currently_published' => 'currentlyPublished',
        'page_expiry_enabled' => 'pageExpiryEnabled',
        'page_expiry_redirect_id' => 'pageExpiryRedirectId',
        'page_expiry_redirect_url' => 'pageExpiryRedirectUrl',
        'page_expiry_date' => 'pageExpiryDate',
        'include_default_custom_css' => 'includeDefaultCustomCss',
        'enable_layout_stylesheets' => 'enableLayoutStylesheets',
        'enable_domain_stylesheets' => 'enableDomainStylesheets',
        'publish_immediately' => 'publishImmediately',
        'featured_image' => 'featuredImage',
        'featured_image_alt_text' => 'featuredImageAltText',
        'link_rel_canonical_url' => 'linkRelCanonicalUrl',
        'content_type_category' => 'contentTypeCategory',
        'attached_stylesheets' => 'attachedStylesheets',
        'meta_description' => 'metaDescription',
        'head_html' => 'headHtml',
        'footer_html' => 'footerHtml',
        'archived_in_dashboard' => 'archivedInDashboard',
        'public_access_rules_enabled' => 'publicAccessRulesEnabled',
        'public_access_rules' => 'publicAccessRules',
        'layout_sections' => 'layoutSections',
        'theme_settings_values' => 'themeSettingsValues',
        'url' => 'url',
        'password' => 'password',
        'current_state' => 'currentState',
        'publish_date' => 'publishDate',
        'created' => 'created',
        'updated' => 'updated',
        'deleted_at' => 'deletedAt'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'slug' => 'setSlug',
        'content_group_id' => 'setContentGroupId',
        'campaign' => 'setCampaign',
        'category_id' => 'setCategoryId',
        'state' => 'setState',
        'name' => 'setName',
        'mab_experiment_id' => 'setMabExperimentId',
        'archived' => 'setArchived',
        'author_name' => 'setAuthorName',
        'ab_test_id' => 'setAbTestId',
        'created_by_id' => 'setCreatedById',
        'updated_by_id' => 'setUpdatedById',
        'domain' => 'setDomain',
        'ab_status' => 'setAbStatus',
        'folder_id' => 'setFolderId',
        'widget_containers' => 'setWidgetContainers',
        'widgets' => 'setWidgets',
        'language' => 'setLanguage',
        'translated_from_id' => 'setTranslatedFromId',
        'translations' => 'setTranslations',
        'dynamic_page_data_source_type' => 'setDynamicPageDataSourceType',
        'dynamic_page_data_source_id' => 'setDynamicPageDataSourceId',
        'blog_author_id' => 'setBlogAuthorId',
        'tag_ids' => 'setTagIds',
        'html_title' => 'setHtmlTitle',
        'enable_google_amp_output_override' => 'setEnableGoogleAmpOutputOverride',
        'use_featured_image' => 'setUseFeaturedImage',
        'post_body' => 'setPostBody',
        'post_summary' => 'setPostSummary',
        'rss_body' => 'setRssBody',
        'rss_summary' => 'setRssSummary',
        'currently_published' => 'setCurrentlyPublished',
        'page_expiry_enabled' => 'setPageExpiryEnabled',
        'page_expiry_redirect_id' => 'setPageExpiryRedirectId',
        'page_expiry_redirect_url' => 'setPageExpiryRedirectUrl',
        'page_expiry_date' => 'setPageExpiryDate',
        'include_default_custom_css' => 'setIncludeDefaultCustomCss',
        'enable_layout_stylesheets' => 'setEnableLayoutStylesheets',
        'enable_domain_stylesheets' => 'setEnableDomainStylesheets',
        'publish_immediately' => 'setPublishImmediately',
        'featured_image' => 'setFeaturedImage',
        'featured_image_alt_text' => 'setFeaturedImageAltText',
        'link_rel_canonical_url' => 'setLinkRelCanonicalUrl',
        'content_type_category' => 'setContentTypeCategory',
        'attached_stylesheets' => 'setAttachedStylesheets',
        'meta_description' => 'setMetaDescription',
        'head_html' => 'setHeadHtml',
        'footer_html' => 'setFooterHtml',
        'archived_in_dashboard' => 'setArchivedInDashboard',
        'public_access_rules_enabled' => 'setPublicAccessRulesEnabled',
        'public_access_rules' => 'setPublicAccessRules',
        'layout_sections' => 'setLayoutSections',
        'theme_settings_values' => 'setThemeSettingsValues',
        'url' => 'setUrl',
        'password' => 'setPassword',
        'current_state' => 'setCurrentState',
        'publish_date' => 'setPublishDate',
        'created' => 'setCreated',
        'updated' => 'setUpdated',
        'deleted_at' => 'setDeletedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'slug' => 'getSlug',
        'content_group_id' => 'getContentGroupId',
        'campaign' => 'getCampaign',
        'category_id' => 'getCategoryId',
        'state' => 'getState',
        'name' => 'getName',
        'mab_experiment_id' => 'getMabExperimentId',
        'archived' => 'getArchived',
        'author_name' => 'getAuthorName',
        'ab_test_id' => 'getAbTestId',
        'created_by_id' => 'getCreatedById',
        'updated_by_id' => 'getUpdatedById',
        'domain' => 'getDomain',
        'ab_status' => 'getAbStatus',
        'folder_id' => 'getFolderId',
        'widget_containers' => 'getWidgetContainers',
        'widgets' => 'getWidgets',
        'language' => 'getLanguage',
        'translated_from_id' => 'getTranslatedFromId',
        'translations' => 'getTranslations',
        'dynamic_page_data_source_type' => 'getDynamicPageDataSourceType',
        'dynamic_page_data_source_id' => 'getDynamicPageDataSourceId',
        'blog_author_id' => 'getBlogAuthorId',
        'tag_ids' => 'getTagIds',
        'html_title' => 'getHtmlTitle',
        'enable_google_amp_output_override' => 'getEnableGoogleAmpOutputOverride',
        'use_featured_image' => 'getUseFeaturedImage',
        'post_body' => 'getPostBody',
        'post_summary' => 'getPostSummary',
        'rss_body' => 'getRssBody',
        'rss_summary' => 'getRssSummary',
        'currently_published' => 'getCurrentlyPublished',
        'page_expiry_enabled' => 'getPageExpiryEnabled',
        'page_expiry_redirect_id' => 'getPageExpiryRedirectId',
        'page_expiry_redirect_url' => 'getPageExpiryRedirectUrl',
        'page_expiry_date' => 'getPageExpiryDate',
        'include_default_custom_css' => 'getIncludeDefaultCustomCss',
        'enable_layout_stylesheets' => 'getEnableLayoutStylesheets',
        'enable_domain_stylesheets' => 'getEnableDomainStylesheets',
        'publish_immediately' => 'getPublishImmediately',
        'featured_image' => 'getFeaturedImage',
        'featured_image_alt_text' => 'getFeaturedImageAltText',
        'link_rel_canonical_url' => 'getLinkRelCanonicalUrl',
        'content_type_category' => 'getContentTypeCategory',
        'attached_stylesheets' => 'getAttachedStylesheets',
        'meta_description' => 'getMetaDescription',
        'head_html' => 'getHeadHtml',
        'footer_html' => 'getFooterHtml',
        'archived_in_dashboard' => 'getArchivedInDashboard',
        'public_access_rules_enabled' => 'getPublicAccessRulesEnabled',
        'public_access_rules' => 'getPublicAccessRules',
        'layout_sections' => 'getLayoutSections',
        'theme_settings_values' => 'getThemeSettingsValues',
        'url' => 'getUrl',
        'password' => 'getPassword',
        'current_state' => 'getCurrentState',
        'publish_date' => 'getPublishDate',
        'created' => 'getCreated',
        'updated' => 'getUpdated',
        'deleted_at' => 'getDeletedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const AB_STATUS_MASTER = 'master';
    public const AB_STATUS_VARIANT = 'variant';
    public const AB_STATUS_LOSER_VARIANT = 'loser_variant';
    public const AB_STATUS_MAB_MASTER = 'mab_master';
    public const AB_STATUS_MAB_VARIANT = 'mab_variant';
    public const AB_STATUS_AUTOMATED_MASTER = 'automated_master';
    public const AB_STATUS_AUTOMATED_VARIANT = 'automated_variant';
    public const AB_STATUS_AUTOMATED_LOSER_VARIANT = 'automated_loser_variant';
    public const LANGUAGE_AF = 'af';
    public const LANGUAGE_AF_NA = 'af-na';
    public const LANGUAGE_AF_ZA = 'af-za';
    public const LANGUAGE_AGQ = 'agq';
    public const LANGUAGE_AGQ_CM = 'agq-cm';
    public const LANGUAGE_AK = 'ak';
    public const LANGUAGE_AK_GH = 'ak-gh';
    public const LANGUAGE_AM = 'am';
    public const LANGUAGE_AM_ET = 'am-et';
    public const LANGUAGE_AR = 'ar';
    public const LANGUAGE_AR_001 = 'ar-001';
    public const LANGUAGE_AR_AE = 'ar-ae';
    public const LANGUAGE_AR_BH = 'ar-bh';
    public const LANGUAGE_AR_DJ = 'ar-dj';
    public const LANGUAGE_AR_DZ = 'ar-dz';
    public const LANGUAGE_AR_EG = 'ar-eg';
    public const LANGUAGE_AR_EH = 'ar-eh';
    public const LANGUAGE_AR_ER = 'ar-er';
    public const LANGUAGE_AR_IL = 'ar-il';
    public const LANGUAGE_AR_IQ = 'ar-iq';
    public const LANGUAGE_AR_JO = 'ar-jo';
    public const LANGUAGE_AR_KM = 'ar-km';
    public const LANGUAGE_AR_KW = 'ar-kw';
    public const LANGUAGE_AR_LB = 'ar-lb';
    public const LANGUAGE_AR_LY = 'ar-ly';
    public const LANGUAGE_AR_MA = 'ar-ma';
    public const LANGUAGE_AR_MR = 'ar-mr';
    public const LANGUAGE_AR_OM = 'ar-om';
    public const LANGUAGE_AR_PS = 'ar-ps';
    public const LANGUAGE_AR_QA = 'ar-qa';
    public const LANGUAGE_AR_SA = 'ar-sa';
    public const LANGUAGE_AR_SD = 'ar-sd';
    public const LANGUAGE_AR_SO = 'ar-so';
    public const LANGUAGE_AR_SS = 'ar-ss';
    public const LANGUAGE_AR_SY = 'ar-sy';
    public const LANGUAGE_AR_TD = 'ar-td';
    public const LANGUAGE_AR_TN = 'ar-tn';
    public const LANGUAGE_AR_YE = 'ar-ye';
    public const LANGUAGE__AS = 'as';
    public const LANGUAGE_AS_IN = 'as-in';
    public const LANGUAGE_ASA = 'asa';
    public const LANGUAGE_ASA_TZ = 'asa-tz';
    public const LANGUAGE_AST = 'ast';
    public const LANGUAGE_AST_ES = 'ast-es';
    public const LANGUAGE_AZ = 'az';
    public const LANGUAGE_AZ_AZ = 'az-az';
    public const LANGUAGE_BAS = 'bas';
    public const LANGUAGE_BAS_CM = 'bas-cm';
    public const LANGUAGE_BE = 'be';
    public const LANGUAGE_BE_BY = 'be-by';
    public const LANGUAGE_BEM = 'bem';
    public const LANGUAGE_BEM_ZM = 'bem-zm';
    public const LANGUAGE_BEZ = 'bez';
    public const LANGUAGE_BEZ_TZ = 'bez-tz';
    public const LANGUAGE_BG = 'bg';
    public const LANGUAGE_BG_BG = 'bg-bg';
    public const LANGUAGE_BM = 'bm';
    public const LANGUAGE_BM_ML = 'bm-ml';
    public const LANGUAGE_BN = 'bn';
    public const LANGUAGE_BN_BD = 'bn-bd';
    public const LANGUAGE_BN_IN = 'bn-in';
    public const LANGUAGE_BO = 'bo';
    public const LANGUAGE_BO_CN = 'bo-cn';
    public const LANGUAGE_BO_IN = 'bo-in';
    public const LANGUAGE_BR = 'br';
    public const LANGUAGE_BR_FR = 'br-fr';
    public const LANGUAGE_BRX = 'brx';
    public const LANGUAGE_BRX_IN = 'brx-in';
    public const LANGUAGE_BS = 'bs';
    public const LANGUAGE_BS_BA = 'bs-ba';
    public const LANGUAGE_CA = 'ca';
    public const LANGUAGE_CA_AD = 'ca-ad';
    public const LANGUAGE_CA_ES = 'ca-es';
    public const LANGUAGE_CA_FR = 'ca-fr';
    public const LANGUAGE_CA_IT = 'ca-it';
    public const LANGUAGE_CCP = 'ccp';
    public const LANGUAGE_CCP_BD = 'ccp-bd';
    public const LANGUAGE_CCP_IN = 'ccp-in';
    public const LANGUAGE_CE = 'ce';
    public const LANGUAGE_CE_RU = 'ce-ru';
    public const LANGUAGE_CGG = 'cgg';
    public const LANGUAGE_CGG_UG = 'cgg-ug';
    public const LANGUAGE_CHR = 'chr';
    public const LANGUAGE_CHR_US = 'chr-us';
    public const LANGUAGE_CKB = 'ckb';
    public const LANGUAGE_CKB_IQ = 'ckb-iq';
    public const LANGUAGE_CKB_IR = 'ckb-ir';
    public const LANGUAGE_CS = 'cs';
    public const LANGUAGE_CS_CZ = 'cs-cz';
    public const LANGUAGE_CU = 'cu';
    public const LANGUAGE_CU_RU = 'cu-ru';
    public const LANGUAGE_CY = 'cy';
    public const LANGUAGE_CY_GB = 'cy-gb';
    public const LANGUAGE_DA = 'da';
    public const LANGUAGE_DA_DK = 'da-dk';
    public const LANGUAGE_DA_GL = 'da-gl';
    public const LANGUAGE_DAV = 'dav';
    public const LANGUAGE_DAV_KE = 'dav-ke';
    public const LANGUAGE_DE = 'de';
    public const LANGUAGE_DE_AT = 'de-at';
    public const LANGUAGE_DE_BE = 'de-be';
    public const LANGUAGE_DE_CH = 'de-ch';
    public const LANGUAGE_DE_DE = 'de-de';
    public const LANGUAGE_DE_GR = 'de-gr';
    public const LANGUAGE_DE_IT = 'de-it';
    public const LANGUAGE_DE_LI = 'de-li';
    public const LANGUAGE_DE_LU = 'de-lu';
    public const LANGUAGE_DJE = 'dje';
    public const LANGUAGE_DJE_NE = 'dje-ne';
    public const LANGUAGE_DSB = 'dsb';
    public const LANGUAGE_DSB_DE = 'dsb-de';
    public const LANGUAGE_DUA = 'dua';
    public const LANGUAGE_DUA_CM = 'dua-cm';
    public const LANGUAGE_DYO = 'dyo';
    public const LANGUAGE_DYO_SN = 'dyo-sn';
    public const LANGUAGE_DZ = 'dz';
    public const LANGUAGE_DZ_BT = 'dz-bt';
    public const LANGUAGE_EBU = 'ebu';
    public const LANGUAGE_EBU_KE = 'ebu-ke';
    public const LANGUAGE_EE = 'ee';
    public const LANGUAGE_EE_GH = 'ee-gh';
    public const LANGUAGE_EE_TG = 'ee-tg';
    public const LANGUAGE_EL = 'el';
    public const LANGUAGE_EL_CY = 'el-cy';
    public const LANGUAGE_EL_GR = 'el-gr';
    public const LANGUAGE_EN = 'en';
    public const LANGUAGE_EN_001 = 'en-001';
    public const LANGUAGE_EN_150 = 'en-150';
    public const LANGUAGE_EN_AE = 'en-ae';
    public const LANGUAGE_EN_AG = 'en-ag';
    public const LANGUAGE_EN_AI = 'en-ai';
    public const LANGUAGE_EN_AS = 'en-as';
    public const LANGUAGE_EN_AT = 'en-at';
    public const LANGUAGE_EN_AU = 'en-au';
    public const LANGUAGE_EN_BB = 'en-bb';
    public const LANGUAGE_EN_BE = 'en-be';
    public const LANGUAGE_EN_BI = 'en-bi';
    public const LANGUAGE_EN_BM = 'en-bm';
    public const LANGUAGE_EN_BS = 'en-bs';
    public const LANGUAGE_EN_BW = 'en-bw';
    public const LANGUAGE_EN_BZ = 'en-bz';
    public const LANGUAGE_EN_CA = 'en-ca';
    public const LANGUAGE_EN_CC = 'en-cc';
    public const LANGUAGE_EN_CH = 'en-ch';
    public const LANGUAGE_EN_CK = 'en-ck';
    public const LANGUAGE_EN_CM = 'en-cm';
    public const LANGUAGE_EN_CX = 'en-cx';
    public const LANGUAGE_EN_CY = 'en-cy';
    public const LANGUAGE_EN_DE = 'en-de';
    public const LANGUAGE_EN_DG = 'en-dg';
    public const LANGUAGE_EN_DK = 'en-dk';
    public const LANGUAGE_EN_DM = 'en-dm';
    public const LANGUAGE_EN_ER = 'en-er';
    public const LANGUAGE_EN_FI = 'en-fi';
    public const LANGUAGE_EN_FJ = 'en-fj';
    public const LANGUAGE_EN_FK = 'en-fk';
    public const LANGUAGE_EN_FM = 'en-fm';
    public const LANGUAGE_EN_GB = 'en-gb';
    public const LANGUAGE_EN_GD = 'en-gd';
    public const LANGUAGE_EN_GG = 'en-gg';
    public const LANGUAGE_EN_GH = 'en-gh';
    public const LANGUAGE_EN_GI = 'en-gi';
    public const LANGUAGE_EN_GM = 'en-gm';
    public const LANGUAGE_EN_GU = 'en-gu';
    public const LANGUAGE_EN_GY = 'en-gy';
    public const LANGUAGE_EN_HK = 'en-hk';
    public const LANGUAGE_EN_IE = 'en-ie';
    public const LANGUAGE_EN_IL = 'en-il';
    public const LANGUAGE_EN_IM = 'en-im';
    public const LANGUAGE_EN_IN = 'en-in';
    public const LANGUAGE_EN_IO = 'en-io';
    public const LANGUAGE_EN_JE = 'en-je';
    public const LANGUAGE_EN_JM = 'en-jm';
    public const LANGUAGE_EN_KE = 'en-ke';
    public const LANGUAGE_EN_KI = 'en-ki';
    public const LANGUAGE_EN_KN = 'en-kn';
    public const LANGUAGE_EN_KY = 'en-ky';
    public const LANGUAGE_EN_LC = 'en-lc';
    public const LANGUAGE_EN_LR = 'en-lr';
    public const LANGUAGE_EN_LS = 'en-ls';
    public const LANGUAGE_EN_LU = 'en-lu';
    public const LANGUAGE_EN_MG = 'en-mg';
    public const LANGUAGE_EN_MH = 'en-mh';
    public const LANGUAGE_EN_MO = 'en-mo';
    public const LANGUAGE_EN_MP = 'en-mp';
    public const LANGUAGE_EN_MS = 'en-ms';
    public const LANGUAGE_EN_MT = 'en-mt';
    public const LANGUAGE_EN_MU = 'en-mu';
    public const LANGUAGE_EN_MW = 'en-mw';
    public const LANGUAGE_EN_MY = 'en-my';
    public const LANGUAGE_EN_NA = 'en-na';
    public const LANGUAGE_EN_NF = 'en-nf';
    public const LANGUAGE_EN_NG = 'en-ng';
    public const LANGUAGE_EN_NL = 'en-nl';
    public const LANGUAGE_EN_NR = 'en-nr';
    public const LANGUAGE_EN_NU = 'en-nu';
    public const LANGUAGE_EN_NZ = 'en-nz';
    public const LANGUAGE_EN_PG = 'en-pg';
    public const LANGUAGE_EN_PH = 'en-ph';
    public const LANGUAGE_EN_PK = 'en-pk';
    public const LANGUAGE_EN_PN = 'en-pn';
    public const LANGUAGE_EN_PR = 'en-pr';
    public const LANGUAGE_EN_PW = 'en-pw';
    public const LANGUAGE_EN_RW = 'en-rw';
    public const LANGUAGE_EN_SB = 'en-sb';
    public const LANGUAGE_EN_SC = 'en-sc';
    public const LANGUAGE_EN_SD = 'en-sd';
    public const LANGUAGE_EN_SE = 'en-se';
    public const LANGUAGE_EN_SG = 'en-sg';
    public const LANGUAGE_EN_SH = 'en-sh';
    public const LANGUAGE_EN_SI = 'en-si';
    public const LANGUAGE_EN_SL = 'en-sl';
    public const LANGUAGE_EN_SS = 'en-ss';
    public const LANGUAGE_EN_SX = 'en-sx';
    public const LANGUAGE_EN_SZ = 'en-sz';
    public const LANGUAGE_EN_TC = 'en-tc';
    public const LANGUAGE_EN_TK = 'en-tk';
    public const LANGUAGE_EN_TO = 'en-to';
    public const LANGUAGE_EN_TT = 'en-tt';
    public const LANGUAGE_EN_TV = 'en-tv';
    public const LANGUAGE_EN_TZ = 'en-tz';
    public const LANGUAGE_EN_UG = 'en-ug';
    public const LANGUAGE_EN_UM = 'en-um';
    public const LANGUAGE_EN_US = 'en-us';
    public const LANGUAGE_EN_VC = 'en-vc';
    public const LANGUAGE_EN_VG = 'en-vg';
    public const LANGUAGE_EN_VI = 'en-vi';
    public const LANGUAGE_EN_VU = 'en-vu';
    public const LANGUAGE_EN_WS = 'en-ws';
    public const LANGUAGE_EN_ZA = 'en-za';
    public const LANGUAGE_EN_ZM = 'en-zm';
    public const LANGUAGE_EN_ZW = 'en-zw';
    public const LANGUAGE_EO = 'eo';
    public const LANGUAGE_EO_001 = 'eo-001';
    public const LANGUAGE_ES = 'es';
    public const LANGUAGE_ES_419 = 'es-419';
    public const LANGUAGE_ES_AR = 'es-ar';
    public const LANGUAGE_ES_BO = 'es-bo';
    public const LANGUAGE_ES_BR = 'es-br';
    public const LANGUAGE_ES_BZ = 'es-bz';
    public const LANGUAGE_ES_CL = 'es-cl';
    public const LANGUAGE_ES_CO = 'es-co';
    public const LANGUAGE_ES_CR = 'es-cr';
    public const LANGUAGE_ES_CU = 'es-cu';
    public const LANGUAGE_ES_DO = 'es-do';
    public const LANGUAGE_ES_EA = 'es-ea';
    public const LANGUAGE_ES_EC = 'es-ec';
    public const LANGUAGE_ES_ES = 'es-es';
    public const LANGUAGE_ES_GQ = 'es-gq';
    public const LANGUAGE_ES_GT = 'es-gt';
    public const LANGUAGE_ES_HN = 'es-hn';
    public const LANGUAGE_ES_IC = 'es-ic';
    public const LANGUAGE_ES_MX = 'es-mx';
    public const LANGUAGE_ES_NI = 'es-ni';
    public const LANGUAGE_ES_PA = 'es-pa';
    public const LANGUAGE_ES_PE = 'es-pe';
    public const LANGUAGE_ES_PH = 'es-ph';
    public const LANGUAGE_ES_PR = 'es-pr';
    public const LANGUAGE_ES_PY = 'es-py';
    public const LANGUAGE_ES_SV = 'es-sv';
    public const LANGUAGE_ES_US = 'es-us';
    public const LANGUAGE_ES_UY = 'es-uy';
    public const LANGUAGE_ES_VE = 'es-ve';
    public const LANGUAGE_ET = 'et';
    public const LANGUAGE_ET_EE = 'et-ee';
    public const LANGUAGE_EU = 'eu';
    public const LANGUAGE_EU_ES = 'eu-es';
    public const LANGUAGE_EWO = 'ewo';
    public const LANGUAGE_EWO_CM = 'ewo-cm';
    public const LANGUAGE_FA = 'fa';
    public const LANGUAGE_FA_AF = 'fa-af';
    public const LANGUAGE_FA_IR = 'fa-ir';
    public const LANGUAGE_FF = 'ff';
    public const LANGUAGE_FF_CM = 'ff-cm';
    public const LANGUAGE_FF_GN = 'ff-gn';
    public const LANGUAGE_FF_MR = 'ff-mr';
    public const LANGUAGE_FF_SN = 'ff-sn';
    public const LANGUAGE_FI = 'fi';
    public const LANGUAGE_FI_FI = 'fi-fi';
    public const LANGUAGE_FIL = 'fil';
    public const LANGUAGE_FIL_PH = 'fil-ph';
    public const LANGUAGE_FO = 'fo';
    public const LANGUAGE_FO_DK = 'fo-dk';
    public const LANGUAGE_FO_FO = 'fo-fo';
    public const LANGUAGE_FR = 'fr';
    public const LANGUAGE_FR_BE = 'fr-be';
    public const LANGUAGE_FR_BF = 'fr-bf';
    public const LANGUAGE_FR_BI = 'fr-bi';
    public const LANGUAGE_FR_BJ = 'fr-bj';
    public const LANGUAGE_FR_BL = 'fr-bl';
    public const LANGUAGE_FR_CA = 'fr-ca';
    public const LANGUAGE_FR_CD = 'fr-cd';
    public const LANGUAGE_FR_CF = 'fr-cf';
    public const LANGUAGE_FR_CG = 'fr-cg';
    public const LANGUAGE_FR_CH = 'fr-ch';
    public const LANGUAGE_FR_CI = 'fr-ci';
    public const LANGUAGE_FR_CM = 'fr-cm';
    public const LANGUAGE_FR_DJ = 'fr-dj';
    public const LANGUAGE_FR_DZ = 'fr-dz';
    public const LANGUAGE_FR_FR = 'fr-fr';
    public const LANGUAGE_FR_GA = 'fr-ga';
    public const LANGUAGE_FR_GF = 'fr-gf';
    public const LANGUAGE_FR_GN = 'fr-gn';
    public const LANGUAGE_FR_GP = 'fr-gp';
    public const LANGUAGE_FR_GQ = 'fr-gq';
    public const LANGUAGE_FR_HT = 'fr-ht';
    public const LANGUAGE_FR_KM = 'fr-km';
    public const LANGUAGE_FR_LU = 'fr-lu';
    public const LANGUAGE_FR_MA = 'fr-ma';
    public const LANGUAGE_FR_MC = 'fr-mc';
    public const LANGUAGE_FR_MF = 'fr-mf';
    public const LANGUAGE_FR_MG = 'fr-mg';
    public const LANGUAGE_FR_ML = 'fr-ml';
    public const LANGUAGE_FR_MQ = 'fr-mq';
    public const LANGUAGE_FR_MR = 'fr-mr';
    public const LANGUAGE_FR_MU = 'fr-mu';
    public const LANGUAGE_FR_NC = 'fr-nc';
    public const LANGUAGE_FR_NE = 'fr-ne';
    public const LANGUAGE_FR_PF = 'fr-pf';
    public const LANGUAGE_FR_PM = 'fr-pm';
    public const LANGUAGE_FR_RE = 'fr-re';
    public const LANGUAGE_FR_RW = 'fr-rw';
    public const LANGUAGE_FR_SC = 'fr-sc';
    public const LANGUAGE_FR_SN = 'fr-sn';
    public const LANGUAGE_FR_SY = 'fr-sy';
    public const LANGUAGE_FR_TD = 'fr-td';
    public const LANGUAGE_FR_TG = 'fr-tg';
    public const LANGUAGE_FR_TN = 'fr-tn';
    public const LANGUAGE_FR_VU = 'fr-vu';
    public const LANGUAGE_FR_WF = 'fr-wf';
    public const LANGUAGE_FR_YT = 'fr-yt';
    public const LANGUAGE_FUR = 'fur';
    public const LANGUAGE_FUR_IT = 'fur-it';
    public const LANGUAGE_FY = 'fy';
    public const LANGUAGE_FY_NL = 'fy-nl';
    public const LANGUAGE_GA = 'ga';
    public const LANGUAGE_GA_IE = 'ga-ie';
    public const LANGUAGE_GD = 'gd';
    public const LANGUAGE_GD_GB = 'gd-gb';
    public const LANGUAGE_GL = 'gl';
    public const LANGUAGE_GL_ES = 'gl-es';
    public const LANGUAGE_GSW = 'gsw';
    public const LANGUAGE_GSW_CH = 'gsw-ch';
    public const LANGUAGE_GSW_FR = 'gsw-fr';
    public const LANGUAGE_GSW_LI = 'gsw-li';
    public const LANGUAGE_GU = 'gu';
    public const LANGUAGE_GU_IN = 'gu-in';
    public const LANGUAGE_GUZ = 'guz';
    public const LANGUAGE_GUZ_KE = 'guz-ke';
    public const LANGUAGE_GV = 'gv';
    public const LANGUAGE_GV_IM = 'gv-im';
    public const LANGUAGE_HA = 'ha';
    public const LANGUAGE_HA_GH = 'ha-gh';
    public const LANGUAGE_HA_NE = 'ha-ne';
    public const LANGUAGE_HA_NG = 'ha-ng';
    public const LANGUAGE_HAW = 'haw';
    public const LANGUAGE_HAW_US = 'haw-us';
    public const LANGUAGE_HE = 'he';
    public const LANGUAGE_HI = 'hi';
    public const LANGUAGE_HI_IN = 'hi-in';
    public const LANGUAGE_HR = 'hr';
    public const LANGUAGE_HR_BA = 'hr-ba';
    public const LANGUAGE_HR_HR = 'hr-hr';
    public const LANGUAGE_HSB = 'hsb';
    public const LANGUAGE_HSB_DE = 'hsb-de';
    public const LANGUAGE_HU = 'hu';
    public const LANGUAGE_HU_HU = 'hu-hu';
    public const LANGUAGE_HY = 'hy';
    public const LANGUAGE_HY_AM = 'hy-am';
    public const LANGUAGE_ID = 'id';
    public const LANGUAGE_IG = 'ig';
    public const LANGUAGE_IG_NG = 'ig-ng';
    public const LANGUAGE_II = 'ii';
    public const LANGUAGE_II_CN = 'ii-cn';
    public const LANGUAGE_ID_ID = 'id-id';
    public const LANGUAGE_IS = 'is';
    public const LANGUAGE_IS_IS = 'is-is';
    public const LANGUAGE_IT = 'it';
    public const LANGUAGE_IT_CH = 'it-ch';
    public const LANGUAGE_IT_IT = 'it-it';
    public const LANGUAGE_IT_SM = 'it-sm';
    public const LANGUAGE_IT_VA = 'it-va';
    public const LANGUAGE_HE_IL = 'he-il';
    public const LANGUAGE_JA = 'ja';
    public const LANGUAGE_JA_JP = 'ja-jp';
    public const LANGUAGE_JGO = 'jgo';
    public const LANGUAGE_JGO_CM = 'jgo-cm';
    public const LANGUAGE_YI = 'yi';
    public const LANGUAGE_YI_001 = 'yi-001';
    public const LANGUAGE_JMC = 'jmc';
    public const LANGUAGE_JMC_TZ = 'jmc-tz';
    public const LANGUAGE_KA = 'ka';
    public const LANGUAGE_KA_GE = 'ka-ge';
    public const LANGUAGE_KAB = 'kab';
    public const LANGUAGE_KAB_DZ = 'kab-dz';
    public const LANGUAGE_KAM = 'kam';
    public const LANGUAGE_KAM_KE = 'kam-ke';
    public const LANGUAGE_KDE = 'kde';
    public const LANGUAGE_KDE_TZ = 'kde-tz';
    public const LANGUAGE_KEA = 'kea';
    public const LANGUAGE_KEA_CV = 'kea-cv';
    public const LANGUAGE_KHQ = 'khq';
    public const LANGUAGE_KHQ_ML = 'khq-ml';
    public const LANGUAGE_KI = 'ki';
    public const LANGUAGE_KI_KE = 'ki-ke';
    public const LANGUAGE_KK = 'kk';
    public const LANGUAGE_KK_KZ = 'kk-kz';
    public const LANGUAGE_KKJ = 'kkj';
    public const LANGUAGE_KKJ_CM = 'kkj-cm';
    public const LANGUAGE_KL = 'kl';
    public const LANGUAGE_KL_GL = 'kl-gl';
    public const LANGUAGE_KLN = 'kln';
    public const LANGUAGE_KLN_KE = 'kln-ke';
    public const LANGUAGE_KM = 'km';
    public const LANGUAGE_KM_KH = 'km-kh';
    public const LANGUAGE_KN = 'kn';
    public const LANGUAGE_KN_IN = 'kn-in';
    public const LANGUAGE_KO = 'ko';
    public const LANGUAGE_KO_KP = 'ko-kp';
    public const LANGUAGE_KO_KR = 'ko-kr';
    public const LANGUAGE_KOK = 'kok';
    public const LANGUAGE_KOK_IN = 'kok-in';
    public const LANGUAGE_KS = 'ks';
    public const LANGUAGE_KS_IN = 'ks-in';
    public const LANGUAGE_KSB = 'ksb';
    public const LANGUAGE_KSB_TZ = 'ksb-tz';
    public const LANGUAGE_KSF = 'ksf';
    public const LANGUAGE_KSF_CM = 'ksf-cm';
    public const LANGUAGE_KSH = 'ksh';
    public const LANGUAGE_KSH_DE = 'ksh-de';
    public const LANGUAGE_KW = 'kw';
    public const LANGUAGE_KW_GB = 'kw-gb';
    public const LANGUAGE_KY = 'ky';
    public const LANGUAGE_KY_KG = 'ky-kg';
    public const LANGUAGE_LAG = 'lag';
    public const LANGUAGE_LAG_TZ = 'lag-tz';
    public const LANGUAGE_LB = 'lb';
    public const LANGUAGE_LB_LU = 'lb-lu';
    public const LANGUAGE_LG = 'lg';
    public const LANGUAGE_LG_UG = 'lg-ug';
    public const LANGUAGE_LKT = 'lkt';
    public const LANGUAGE_LKT_US = 'lkt-us';
    public const LANGUAGE_LN = 'ln';
    public const LANGUAGE_LN_AO = 'ln-ao';
    public const LANGUAGE_LN_CD = 'ln-cd';
    public const LANGUAGE_LN_CF = 'ln-cf';
    public const LANGUAGE_LN_CG = 'ln-cg';
    public const LANGUAGE_LO = 'lo';
    public const LANGUAGE_LO_LA = 'lo-la';
    public const LANGUAGE_LRC = 'lrc';
    public const LANGUAGE_LRC_IQ = 'lrc-iq';
    public const LANGUAGE_LRC_IR = 'lrc-ir';
    public const LANGUAGE_LT = 'lt';
    public const LANGUAGE_LT_LT = 'lt-lt';
    public const LANGUAGE_LU = 'lu';
    public const LANGUAGE_LU_CD = 'lu-cd';
    public const LANGUAGE_LUO = 'luo';
    public const LANGUAGE_LUO_KE = 'luo-ke';
    public const LANGUAGE_LUY = 'luy';
    public const LANGUAGE_LUY_KE = 'luy-ke';
    public const LANGUAGE_LV = 'lv';
    public const LANGUAGE_LV_LV = 'lv-lv';
    public const LANGUAGE_MAS = 'mas';
    public const LANGUAGE_MAS_KE = 'mas-ke';
    public const LANGUAGE_MAS_TZ = 'mas-tz';
    public const LANGUAGE_MER = 'mer';
    public const LANGUAGE_MER_KE = 'mer-ke';
    public const LANGUAGE_MFE = 'mfe';
    public const LANGUAGE_MFE_MU = 'mfe-mu';
    public const LANGUAGE_MG = 'mg';
    public const LANGUAGE_MG_MG = 'mg-mg';
    public const LANGUAGE_MGH = 'mgh';
    public const LANGUAGE_MGH_MZ = 'mgh-mz';
    public const LANGUAGE_MGO = 'mgo';
    public const LANGUAGE_MGO_CM = 'mgo-cm';
    public const LANGUAGE_MK = 'mk';
    public const LANGUAGE_MK_MK = 'mk-mk';
    public const LANGUAGE_ML = 'ml';
    public const LANGUAGE_ML_IN = 'ml-in';
    public const LANGUAGE_MN = 'mn';
    public const LANGUAGE_MN_MN = 'mn-mn';
    public const LANGUAGE_MR = 'mr';
    public const LANGUAGE_MR_IN = 'mr-in';
    public const LANGUAGE_MS = 'ms';
    public const LANGUAGE_MS_BN = 'ms-bn';
    public const LANGUAGE_MS_MY = 'ms-my';
    public const LANGUAGE_MS_SG = 'ms-sg';
    public const LANGUAGE_MT = 'mt';
    public const LANGUAGE_MT_MT = 'mt-mt';
    public const LANGUAGE_MUA = 'mua';
    public const LANGUAGE_MUA_CM = 'mua-cm';
    public const LANGUAGE_MY = 'my';
    public const LANGUAGE_MY_MM = 'my-mm';
    public const LANGUAGE_MZN = 'mzn';
    public const LANGUAGE_MZN_IR = 'mzn-ir';
    public const LANGUAGE_NAQ = 'naq';
    public const LANGUAGE_NAQ_NA = 'naq-na';
    public const LANGUAGE_NB = 'nb';
    public const LANGUAGE_NB_NO = 'nb-no';
    public const LANGUAGE_NB_SJ = 'nb-sj';
    public const LANGUAGE_ND = 'nd';
    public const LANGUAGE_ND_ZW = 'nd-zw';
    public const LANGUAGE_NDS = 'nds';
    public const LANGUAGE_NDS_DE = 'nds-de';
    public const LANGUAGE_NDS_NL = 'nds-nl';
    public const LANGUAGE_NE = 'ne';
    public const LANGUAGE_NE_IN = 'ne-in';
    public const LANGUAGE_NE_NP = 'ne-np';
    public const LANGUAGE_NL = 'nl';
    public const LANGUAGE_NL_AW = 'nl-aw';
    public const LANGUAGE_NL_BE = 'nl-be';
    public const LANGUAGE_NL_CH = 'nl-ch';
    public const LANGUAGE_NL_BQ = 'nl-bq';
    public const LANGUAGE_NL_CW = 'nl-cw';
    public const LANGUAGE_NL_LU = 'nl-lu';
    public const LANGUAGE_NL_NL = 'nl-nl';
    public const LANGUAGE_NL_SR = 'nl-sr';
    public const LANGUAGE_NL_SX = 'nl-sx';
    public const LANGUAGE_NMG = 'nmg';
    public const LANGUAGE_NMG_CM = 'nmg-cm';
    public const LANGUAGE_NN = 'nn';
    public const LANGUAGE_NN_NO = 'nn-no';
    public const LANGUAGE_NNH = 'nnh';
    public const LANGUAGE_NNH_CM = 'nnh-cm';
    public const LANGUAGE_NO = 'no';
    public const LANGUAGE_NO_NO = 'no-no';
    public const LANGUAGE_NUS = 'nus';
    public const LANGUAGE_NUS_SS = 'nus-ss';
    public const LANGUAGE_NYN = 'nyn';
    public const LANGUAGE_NYN_UG = 'nyn-ug';
    public const LANGUAGE_OM = 'om';
    public const LANGUAGE_OM_ET = 'om-et';
    public const LANGUAGE_OM_KE = 'om-ke';
    public const LANGUAGE__OR = 'or';
    public const LANGUAGE_OR_IN = 'or-in';
    public const LANGUAGE_OS = 'os';
    public const LANGUAGE_OS_GE = 'os-ge';
    public const LANGUAGE_OS_RU = 'os-ru';
    public const LANGUAGE_PA = 'pa';
    public const LANGUAGE_PA_IN = 'pa-in';
    public const LANGUAGE_PA_PK = 'pa-pk';
    public const LANGUAGE_PL = 'pl';
    public const LANGUAGE_PL_PL = 'pl-pl';
    public const LANGUAGE_PRG = 'prg';
    public const LANGUAGE_PRG_001 = 'prg-001';
    public const LANGUAGE_PS = 'ps';
    public const LANGUAGE_PS_AF = 'ps-af';
    public const LANGUAGE_PT = 'pt';
    public const LANGUAGE_PT_AO = 'pt-ao';
    public const LANGUAGE_PT_BR = 'pt-br';
    public const LANGUAGE_PT_CH = 'pt-ch';
    public const LANGUAGE_PT_CV = 'pt-cv';
    public const LANGUAGE_PT_GQ = 'pt-gq';
    public const LANGUAGE_PT_GW = 'pt-gw';
    public const LANGUAGE_PT_LU = 'pt-lu';
    public const LANGUAGE_PT_MO = 'pt-mo';
    public const LANGUAGE_PT_MZ = 'pt-mz';
    public const LANGUAGE_PT_PT = 'pt-pt';
    public const LANGUAGE_PT_ST = 'pt-st';
    public const LANGUAGE_PT_TL = 'pt-tl';
    public const LANGUAGE_QU = 'qu';
    public const LANGUAGE_QU_BO = 'qu-bo';
    public const LANGUAGE_QU_EC = 'qu-ec';
    public const LANGUAGE_QU_PE = 'qu-pe';
    public const LANGUAGE_RM = 'rm';
    public const LANGUAGE_RM_CH = 'rm-ch';
    public const LANGUAGE_RN = 'rn';
    public const LANGUAGE_RN_BI = 'rn-bi';
    public const LANGUAGE_RO = 'ro';
    public const LANGUAGE_RO_MD = 'ro-md';
    public const LANGUAGE_RO_RO = 'ro-ro';
    public const LANGUAGE_ROF = 'rof';
    public const LANGUAGE_ROF_TZ = 'rof-tz';
    public const LANGUAGE_RU = 'ru';
    public const LANGUAGE_RU_BY = 'ru-by';
    public const LANGUAGE_RU_KG = 'ru-kg';
    public const LANGUAGE_RU_KZ = 'ru-kz';
    public const LANGUAGE_RU_MD = 'ru-md';
    public const LANGUAGE_RU_RU = 'ru-ru';
    public const LANGUAGE_RU_UA = 'ru-ua';
    public const LANGUAGE_RW = 'rw';
    public const LANGUAGE_RW_RW = 'rw-rw';
    public const LANGUAGE_RWK = 'rwk';
    public const LANGUAGE_RWK_TZ = 'rwk-tz';
    public const LANGUAGE_SA = 'sa';
    public const LANGUAGE_SAH = 'sah';
    public const LANGUAGE_SAH_RU = 'sah-ru';
    public const LANGUAGE_SAQ = 'saq';
    public const LANGUAGE_SAQ_KE = 'saq-ke';
    public const LANGUAGE_SBP = 'sbp';
    public const LANGUAGE_SBP_TZ = 'sbp-tz';
    public const LANGUAGE_SD = 'sd';
    public const LANGUAGE_SD_PK = 'sd-pk';
    public const LANGUAGE_SE = 'se';
    public const LANGUAGE_SE_FI = 'se-fi';
    public const LANGUAGE_SE_NO = 'se-no';
    public const LANGUAGE_SE_SE = 'se-se';
    public const LANGUAGE_SEH = 'seh';
    public const LANGUAGE_SEH_MZ = 'seh-mz';
    public const LANGUAGE_SES = 'ses';
    public const LANGUAGE_SES_ML = 'ses-ml';
    public const LANGUAGE_SG = 'sg';
    public const LANGUAGE_SG_CF = 'sg-cf';
    public const LANGUAGE_SHI = 'shi';
    public const LANGUAGE_SHI_MA = 'shi-ma';
    public const LANGUAGE_SI = 'si';
    public const LANGUAGE_SI_LK = 'si-lk';
    public const LANGUAGE_SK = 'sk';
    public const LANGUAGE_SK_SK = 'sk-sk';
    public const LANGUAGE_SL = 'sl';
    public const LANGUAGE_SL_SI = 'sl-si';
    public const LANGUAGE_SMN = 'smn';
    public const LANGUAGE_SMN_FI = 'smn-fi';
    public const LANGUAGE_SN = 'sn';
    public const LANGUAGE_SN_ZW = 'sn-zw';
    public const LANGUAGE_SO = 'so';
    public const LANGUAGE_SO_DJ = 'so-dj';
    public const LANGUAGE_SO_ET = 'so-et';
    public const LANGUAGE_SO_KE = 'so-ke';
    public const LANGUAGE_SO_SO = 'so-so';
    public const LANGUAGE_SQ = 'sq';
    public const LANGUAGE_SQ_AL = 'sq-al';
    public const LANGUAGE_SQ_MK = 'sq-mk';
    public const LANGUAGE_SQ_XK = 'sq-xk';
    public const LANGUAGE_SR = 'sr';
    public const LANGUAGE_SR_BA = 'sr-ba';
    public const LANGUAGE_SR_CS = 'sr-cs';
    public const LANGUAGE_SR_ME = 'sr-me';
    public const LANGUAGE_SR_RS = 'sr-rs';
    public const LANGUAGE_SR_XK = 'sr-xk';
    public const LANGUAGE_SV = 'sv';
    public const LANGUAGE_SV_AX = 'sv-ax';
    public const LANGUAGE_SV_FI = 'sv-fi';
    public const LANGUAGE_SV_SE = 'sv-se';
    public const LANGUAGE_SW = 'sw';
    public const LANGUAGE_SW_CD = 'sw-cd';
    public const LANGUAGE_SW_KE = 'sw-ke';
    public const LANGUAGE_SW_TZ = 'sw-tz';
    public const LANGUAGE_SW_UG = 'sw-ug';
    public const LANGUAGE_SY = 'sy';
    public const LANGUAGE_TA = 'ta';
    public const LANGUAGE_TA_IN = 'ta-in';
    public const LANGUAGE_TA_LK = 'ta-lk';
    public const LANGUAGE_TA_MY = 'ta-my';
    public const LANGUAGE_TA_SG = 'ta-sg';
    public const LANGUAGE_TE = 'te';
    public const LANGUAGE_TE_IN = 'te-in';
    public const LANGUAGE_TEO = 'teo';
    public const LANGUAGE_TEO_KE = 'teo-ke';
    public const LANGUAGE_TEO_UG = 'teo-ug';
    public const LANGUAGE_TG = 'tg';
    public const LANGUAGE_TG_TJ = 'tg-tj';
    public const LANGUAGE_TH = 'th';
    public const LANGUAGE_TH_TH = 'th-th';
    public const LANGUAGE_TI = 'ti';
    public const LANGUAGE_TI_ER = 'ti-er';
    public const LANGUAGE_TI_ET = 'ti-et';
    public const LANGUAGE_TK = 'tk';
    public const LANGUAGE_TK_TM = 'tk-tm';
    public const LANGUAGE_TO = 'to';
    public const LANGUAGE_TO_TO = 'to-to';
    public const LANGUAGE_TR = 'tr';
    public const LANGUAGE_TR_CY = 'tr-cy';
    public const LANGUAGE_TR_TR = 'tr-tr';
    public const LANGUAGE_TT = 'tt';
    public const LANGUAGE_TT_RU = 'tt-ru';
    public const LANGUAGE_TWQ = 'twq';
    public const LANGUAGE_TWQ_NE = 'twq-ne';
    public const LANGUAGE_TZM = 'tzm';
    public const LANGUAGE_TZM_MA = 'tzm-ma';
    public const LANGUAGE_UG = 'ug';
    public const LANGUAGE_UG_CN = 'ug-cn';
    public const LANGUAGE_UK = 'uk';
    public const LANGUAGE_UK_UA = 'uk-ua';
    public const LANGUAGE_UR = 'ur';
    public const LANGUAGE_UR_IN = 'ur-in';
    public const LANGUAGE_UR_PK = 'ur-pk';
    public const LANGUAGE_UZ = 'uz';
    public const LANGUAGE_UZ_AF = 'uz-af';
    public const LANGUAGE_UZ_UZ = 'uz-uz';
    public const LANGUAGE_VAI = 'vai';
    public const LANGUAGE_VAI_LR = 'vai-lr';
    public const LANGUAGE_VI = 'vi';
    public const LANGUAGE_VI_VN = 'vi-vn';
    public const LANGUAGE_VO = 'vo';
    public const LANGUAGE_VO_001 = 'vo-001';
    public const LANGUAGE_VUN = 'vun';
    public const LANGUAGE_VUN_TZ = 'vun-tz';
    public const LANGUAGE_WAE = 'wae';
    public const LANGUAGE_WAE_CH = 'wae-ch';
    public const LANGUAGE_WO = 'wo';
    public const LANGUAGE_WO_SN = 'wo-sn';
    public const LANGUAGE_XOG = 'xog';
    public const LANGUAGE_XOG_UG = 'xog-ug';
    public const LANGUAGE_YAV = 'yav';
    public const LANGUAGE_YAV_CM = 'yav-cm';
    public const LANGUAGE_YO = 'yo';
    public const LANGUAGE_YO_BJ = 'yo-bj';
    public const LANGUAGE_YO_NG = 'yo-ng';
    public const LANGUAGE_YUE = 'yue';
    public const LANGUAGE_YUE_CN = 'yue-cn';
    public const LANGUAGE_YUE_HK = 'yue-hk';
    public const LANGUAGE_ZGH = 'zgh';
    public const LANGUAGE_ZGH_MA = 'zgh-ma';
    public const LANGUAGE_ZH = 'zh';
    public const LANGUAGE_ZH_CN = 'zh-cn';
    public const LANGUAGE_ZH_HK = 'zh-hk';
    public const LANGUAGE_ZH_MO = 'zh-mo';
    public const LANGUAGE_ZH_SG = 'zh-sg';
    public const LANGUAGE_ZH_TW = 'zh-tw';
    public const LANGUAGE_ZH_HANS = 'zh-hans';
    public const LANGUAGE_ZH_HANT = 'zh-hant';
    public const LANGUAGE_ZU = 'zu';
    public const LANGUAGE_ZU_ZA = 'zu-za';
    public const CONTENT_TYPE_CATEGORY__0 = '0';
    public const CONTENT_TYPE_CATEGORY__1 = '1';
    public const CONTENT_TYPE_CATEGORY__2 = '2';
    public const CONTENT_TYPE_CATEGORY__3 = '3';
    public const CONTENT_TYPE_CATEGORY__4 = '4';
    public const CONTENT_TYPE_CATEGORY__5 = '5';
    public const CONTENT_TYPE_CATEGORY__6 = '6';
    public const CONTENT_TYPE_CATEGORY__7 = '7';
    public const CONTENT_TYPE_CATEGORY__8 = '8';
    public const CONTENT_TYPE_CATEGORY__9 = '9';
    public const CURRENT_STATE_AUTOMATED = 'AUTOMATED';
    public const CURRENT_STATE_AUTOMATED_DRAFT = 'AUTOMATED_DRAFT';
    public const CURRENT_STATE_AUTOMATED_SENDING = 'AUTOMATED_SENDING';
    public const CURRENT_STATE_AUTOMATED_FOR_FORM = 'AUTOMATED_FOR_FORM';
    public const CURRENT_STATE_AUTOMATED_FOR_FORM_BUFFER = 'AUTOMATED_FOR_FORM_BUFFER';
    public const CURRENT_STATE_AUTOMATED_FOR_FORM_DRAFT = 'AUTOMATED_FOR_FORM_DRAFT';
    public const CURRENT_STATE_AUTOMATED_FOR_FORM_LEGACY = 'AUTOMATED_FOR_FORM_LEGACY';
    public const CURRENT_STATE_BLOG_EMAIL_DRAFT = 'BLOG_EMAIL_DRAFT';
    public const CURRENT_STATE_BLOG_EMAIL_PUBLISHED = 'BLOG_EMAIL_PUBLISHED';
    public const CURRENT_STATE_DRAFT = 'DRAFT';
    public const CURRENT_STATE_DRAFT_AB = 'DRAFT_AB';
    public const CURRENT_STATE_DRAFT_AB_VARIANT = 'DRAFT_AB_VARIANT';
    public const CURRENT_STATE_ERROR = 'ERROR';
    public const CURRENT_STATE_LOSER_AB_VARIANT = 'LOSER_AB_VARIANT';
    public const CURRENT_STATE_PAGE_STUB = 'PAGE_STUB';
    public const CURRENT_STATE_PRE_PROCESSING = 'PRE_PROCESSING';
    public const CURRENT_STATE_PROCESSING = 'PROCESSING';
    public const CURRENT_STATE_PUBLISHED = 'PUBLISHED';
    public const CURRENT_STATE_PUBLISHED_AB = 'PUBLISHED_AB';
    public const CURRENT_STATE_PUBLISHED_AB_VARIANT = 'PUBLISHED_AB_VARIANT';
    public const CURRENT_STATE_PUBLISHED_OR_SCHEDULED = 'PUBLISHED_OR_SCHEDULED';
    public const CURRENT_STATE_RSS_TO_EMAIL_DRAFT = 'RSS_TO_EMAIL_DRAFT';
    public const CURRENT_STATE_RSS_TO_EMAIL_PUBLISHED = 'RSS_TO_EMAIL_PUBLISHED';
    public const CURRENT_STATE_SCHEDULED = 'SCHEDULED';
    public const CURRENT_STATE_SCHEDULED_AB = 'SCHEDULED_AB';
    public const CURRENT_STATE_SCHEDULED_OR_PUBLISHED = 'SCHEDULED_OR_PUBLISHED';
    public const CURRENT_STATE_AUTOMATED_AB = 'AUTOMATED_AB';
    public const CURRENT_STATE_AUTOMATED_AB_VARIANT = 'AUTOMATED_AB_VARIANT';
    public const CURRENT_STATE_AUTOMATED_DRAFT_AB = 'AUTOMATED_DRAFT_AB';
    public const CURRENT_STATE_AUTOMATED_DRAFT_ABVARIANT = 'AUTOMATED_DRAFT_ABVARIANT';
    public const CURRENT_STATE_AUTOMATED_LOSER_ABVARIANT = 'AUTOMATED_LOSER_ABVARIANT';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAbStatusAllowableValues()
    {
        return [
            self::AB_STATUS_MASTER,
            self::AB_STATUS_VARIANT,
            self::AB_STATUS_LOSER_VARIANT,
            self::AB_STATUS_MAB_MASTER,
            self::AB_STATUS_MAB_VARIANT,
            self::AB_STATUS_AUTOMATED_MASTER,
            self::AB_STATUS_AUTOMATED_VARIANT,
            self::AB_STATUS_AUTOMATED_LOSER_VARIANT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getLanguageAllowableValues()
    {
        return [
            self::LANGUAGE_AF,
            self::LANGUAGE_AF_NA,
            self::LANGUAGE_AF_ZA,
            self::LANGUAGE_AGQ,
            self::LANGUAGE_AGQ_CM,
            self::LANGUAGE_AK,
            self::LANGUAGE_AK_GH,
            self::LANGUAGE_AM,
            self::LANGUAGE_AM_ET,
            self::LANGUAGE_AR,
            self::LANGUAGE_AR_001,
            self::LANGUAGE_AR_AE,
            self::LANGUAGE_AR_BH,
            self::LANGUAGE_AR_DJ,
            self::LANGUAGE_AR_DZ,
            self::LANGUAGE_AR_EG,
            self::LANGUAGE_AR_EH,
            self::LANGUAGE_AR_ER,
            self::LANGUAGE_AR_IL,
            self::LANGUAGE_AR_IQ,
            self::LANGUAGE_AR_JO,
            self::LANGUAGE_AR_KM,
            self::LANGUAGE_AR_KW,
            self::LANGUAGE_AR_LB,
            self::LANGUAGE_AR_LY,
            self::LANGUAGE_AR_MA,
            self::LANGUAGE_AR_MR,
            self::LANGUAGE_AR_OM,
            self::LANGUAGE_AR_PS,
            self::LANGUAGE_AR_QA,
            self::LANGUAGE_AR_SA,
            self::LANGUAGE_AR_SD,
            self::LANGUAGE_AR_SO,
            self::LANGUAGE_AR_SS,
            self::LANGUAGE_AR_SY,
            self::LANGUAGE_AR_TD,
            self::LANGUAGE_AR_TN,
            self::LANGUAGE_AR_YE,
            self::LANGUAGE__AS,
            self::LANGUAGE_AS_IN,
            self::LANGUAGE_ASA,
            self::LANGUAGE_ASA_TZ,
            self::LANGUAGE_AST,
            self::LANGUAGE_AST_ES,
            self::LANGUAGE_AZ,
            self::LANGUAGE_AZ_AZ,
            self::LANGUAGE_BAS,
            self::LANGUAGE_BAS_CM,
            self::LANGUAGE_BE,
            self::LANGUAGE_BE_BY,
            self::LANGUAGE_BEM,
            self::LANGUAGE_BEM_ZM,
            self::LANGUAGE_BEZ,
            self::LANGUAGE_BEZ_TZ,
            self::LANGUAGE_BG,
            self::LANGUAGE_BG_BG,
            self::LANGUAGE_BM,
            self::LANGUAGE_BM_ML,
            self::LANGUAGE_BN,
            self::LANGUAGE_BN_BD,
            self::LANGUAGE_BN_IN,
            self::LANGUAGE_BO,
            self::LANGUAGE_BO_CN,
            self::LANGUAGE_BO_IN,
            self::LANGUAGE_BR,
            self::LANGUAGE_BR_FR,
            self::LANGUAGE_BRX,
            self::LANGUAGE_BRX_IN,
            self::LANGUAGE_BS,
            self::LANGUAGE_BS_BA,
            self::LANGUAGE_CA,
            self::LANGUAGE_CA_AD,
            self::LANGUAGE_CA_ES,
            self::LANGUAGE_CA_FR,
            self::LANGUAGE_CA_IT,
            self::LANGUAGE_CCP,
            self::LANGUAGE_CCP_BD,
            self::LANGUAGE_CCP_IN,
            self::LANGUAGE_CE,
            self::LANGUAGE_CE_RU,
            self::LANGUAGE_CGG,
            self::LANGUAGE_CGG_UG,
            self::LANGUAGE_CHR,
            self::LANGUAGE_CHR_US,
            self::LANGUAGE_CKB,
            self::LANGUAGE_CKB_IQ,
            self::LANGUAGE_CKB_IR,
            self::LANGUAGE_CS,
            self::LANGUAGE_CS_CZ,
            self::LANGUAGE_CU,
            self::LANGUAGE_CU_RU,
            self::LANGUAGE_CY,
            self::LANGUAGE_CY_GB,
            self::LANGUAGE_DA,
            self::LANGUAGE_DA_DK,
            self::LANGUAGE_DA_GL,
            self::LANGUAGE_DAV,
            self::LANGUAGE_DAV_KE,
            self::LANGUAGE_DE,
            self::LANGUAGE_DE_AT,
            self::LANGUAGE_DE_BE,
            self::LANGUAGE_DE_CH,
            self::LANGUAGE_DE_DE,
            self::LANGUAGE_DE_GR,
            self::LANGUAGE_DE_IT,
            self::LANGUAGE_DE_LI,
            self::LANGUAGE_DE_LU,
            self::LANGUAGE_DJE,
            self::LANGUAGE_DJE_NE,
            self::LANGUAGE_DSB,
            self::LANGUAGE_DSB_DE,
            self::LANGUAGE_DUA,
            self::LANGUAGE_DUA_CM,
            self::LANGUAGE_DYO,
            self::LANGUAGE_DYO_SN,
            self::LANGUAGE_DZ,
            self::LANGUAGE_DZ_BT,
            self::LANGUAGE_EBU,
            self::LANGUAGE_EBU_KE,
            self::LANGUAGE_EE,
            self::LANGUAGE_EE_GH,
            self::LANGUAGE_EE_TG,
            self::LANGUAGE_EL,
            self::LANGUAGE_EL_CY,
            self::LANGUAGE_EL_GR,
            self::LANGUAGE_EN,
            self::LANGUAGE_EN_001,
            self::LANGUAGE_EN_150,
            self::LANGUAGE_EN_AE,
            self::LANGUAGE_EN_AG,
            self::LANGUAGE_EN_AI,
            self::LANGUAGE_EN_AS,
            self::LANGUAGE_EN_AT,
            self::LANGUAGE_EN_AU,
            self::LANGUAGE_EN_BB,
            self::LANGUAGE_EN_BE,
            self::LANGUAGE_EN_BI,
            self::LANGUAGE_EN_BM,
            self::LANGUAGE_EN_BS,
            self::LANGUAGE_EN_BW,
            self::LANGUAGE_EN_BZ,
            self::LANGUAGE_EN_CA,
            self::LANGUAGE_EN_CC,
            self::LANGUAGE_EN_CH,
            self::LANGUAGE_EN_CK,
            self::LANGUAGE_EN_CM,
            self::LANGUAGE_EN_CX,
            self::LANGUAGE_EN_CY,
            self::LANGUAGE_EN_DE,
            self::LANGUAGE_EN_DG,
            self::LANGUAGE_EN_DK,
            self::LANGUAGE_EN_DM,
            self::LANGUAGE_EN_ER,
            self::LANGUAGE_EN_FI,
            self::LANGUAGE_EN_FJ,
            self::LANGUAGE_EN_FK,
            self::LANGUAGE_EN_FM,
            self::LANGUAGE_EN_GB,
            self::LANGUAGE_EN_GD,
            self::LANGUAGE_EN_GG,
            self::LANGUAGE_EN_GH,
            self::LANGUAGE_EN_GI,
            self::LANGUAGE_EN_GM,
            self::LANGUAGE_EN_GU,
            self::LANGUAGE_EN_GY,
            self::LANGUAGE_EN_HK,
            self::LANGUAGE_EN_IE,
            self::LANGUAGE_EN_IL,
            self::LANGUAGE_EN_IM,
            self::LANGUAGE_EN_IN,
            self::LANGUAGE_EN_IO,
            self::LANGUAGE_EN_JE,
            self::LANGUAGE_EN_JM,
            self::LANGUAGE_EN_KE,
            self::LANGUAGE_EN_KI,
            self::LANGUAGE_EN_KN,
            self::LANGUAGE_EN_KY,
            self::LANGUAGE_EN_LC,
            self::LANGUAGE_EN_LR,
            self::LANGUAGE_EN_LS,
            self::LANGUAGE_EN_LU,
            self::LANGUAGE_EN_MG,
            self::LANGUAGE_EN_MH,
            self::LANGUAGE_EN_MO,
            self::LANGUAGE_EN_MP,
            self::LANGUAGE_EN_MS,
            self::LANGUAGE_EN_MT,
            self::LANGUAGE_EN_MU,
            self::LANGUAGE_EN_MW,
            self::LANGUAGE_EN_MY,
            self::LANGUAGE_EN_NA,
            self::LANGUAGE_EN_NF,
            self::LANGUAGE_EN_NG,
            self::LANGUAGE_EN_NL,
            self::LANGUAGE_EN_NR,
            self::LANGUAGE_EN_NU,
            self::LANGUAGE_EN_NZ,
            self::LANGUAGE_EN_PG,
            self::LANGUAGE_EN_PH,
            self::LANGUAGE_EN_PK,
            self::LANGUAGE_EN_PN,
            self::LANGUAGE_EN_PR,
            self::LANGUAGE_EN_PW,
            self::LANGUAGE_EN_RW,
            self::LANGUAGE_EN_SB,
            self::LANGUAGE_EN_SC,
            self::LANGUAGE_EN_SD,
            self::LANGUAGE_EN_SE,
            self::LANGUAGE_EN_SG,
            self::LANGUAGE_EN_SH,
            self::LANGUAGE_EN_SI,
            self::LANGUAGE_EN_SL,
            self::LANGUAGE_EN_SS,
            self::LANGUAGE_EN_SX,
            self::LANGUAGE_EN_SZ,
            self::LANGUAGE_EN_TC,
            self::LANGUAGE_EN_TK,
            self::LANGUAGE_EN_TO,
            self::LANGUAGE_EN_TT,
            self::LANGUAGE_EN_TV,
            self::LANGUAGE_EN_TZ,
            self::LANGUAGE_EN_UG,
            self::LANGUAGE_EN_UM,
            self::LANGUAGE_EN_US,
            self::LANGUAGE_EN_VC,
            self::LANGUAGE_EN_VG,
            self::LANGUAGE_EN_VI,
            self::LANGUAGE_EN_VU,
            self::LANGUAGE_EN_WS,
            self::LANGUAGE_EN_ZA,
            self::LANGUAGE_EN_ZM,
            self::LANGUAGE_EN_ZW,
            self::LANGUAGE_EO,
            self::LANGUAGE_EO_001,
            self::LANGUAGE_ES,
            self::LANGUAGE_ES_419,
            self::LANGUAGE_ES_AR,
            self::LANGUAGE_ES_BO,
            self::LANGUAGE_ES_BR,
            self::LANGUAGE_ES_BZ,
            self::LANGUAGE_ES_CL,
            self::LANGUAGE_ES_CO,
            self::LANGUAGE_ES_CR,
            self::LANGUAGE_ES_CU,
            self::LANGUAGE_ES_DO,
            self::LANGUAGE_ES_EA,
            self::LANGUAGE_ES_EC,
            self::LANGUAGE_ES_ES,
            self::LANGUAGE_ES_GQ,
            self::LANGUAGE_ES_GT,
            self::LANGUAGE_ES_HN,
            self::LANGUAGE_ES_IC,
            self::LANGUAGE_ES_MX,
            self::LANGUAGE_ES_NI,
            self::LANGUAGE_ES_PA,
            self::LANGUAGE_ES_PE,
            self::LANGUAGE_ES_PH,
            self::LANGUAGE_ES_PR,
            self::LANGUAGE_ES_PY,
            self::LANGUAGE_ES_SV,
            self::LANGUAGE_ES_US,
            self::LANGUAGE_ES_UY,
            self::LANGUAGE_ES_VE,
            self::LANGUAGE_ET,
            self::LANGUAGE_ET_EE,
            self::LANGUAGE_EU,
            self::LANGUAGE_EU_ES,
            self::LANGUAGE_EWO,
            self::LANGUAGE_EWO_CM,
            self::LANGUAGE_FA,
            self::LANGUAGE_FA_AF,
            self::LANGUAGE_FA_IR,
            self::LANGUAGE_FF,
            self::LANGUAGE_FF_CM,
            self::LANGUAGE_FF_GN,
            self::LANGUAGE_FF_MR,
            self::LANGUAGE_FF_SN,
            self::LANGUAGE_FI,
            self::LANGUAGE_FI_FI,
            self::LANGUAGE_FIL,
            self::LANGUAGE_FIL_PH,
            self::LANGUAGE_FO,
            self::LANGUAGE_FO_DK,
            self::LANGUAGE_FO_FO,
            self::LANGUAGE_FR,
            self::LANGUAGE_FR_BE,
            self::LANGUAGE_FR_BF,
            self::LANGUAGE_FR_BI,
            self::LANGUAGE_FR_BJ,
            self::LANGUAGE_FR_BL,
            self::LANGUAGE_FR_CA,
            self::LANGUAGE_FR_CD,
            self::LANGUAGE_FR_CF,
            self::LANGUAGE_FR_CG,
            self::LANGUAGE_FR_CH,
            self::LANGUAGE_FR_CI,
            self::LANGUAGE_FR_CM,
            self::LANGUAGE_FR_DJ,
            self::LANGUAGE_FR_DZ,
            self::LANGUAGE_FR_FR,
            self::LANGUAGE_FR_GA,
            self::LANGUAGE_FR_GF,
            self::LANGUAGE_FR_GN,
            self::LANGUAGE_FR_GP,
            self::LANGUAGE_FR_GQ,
            self::LANGUAGE_FR_HT,
            self::LANGUAGE_FR_KM,
            self::LANGUAGE_FR_LU,
            self::LANGUAGE_FR_MA,
            self::LANGUAGE_FR_MC,
            self::LANGUAGE_FR_MF,
            self::LANGUAGE_FR_MG,
            self::LANGUAGE_FR_ML,
            self::LANGUAGE_FR_MQ,
            self::LANGUAGE_FR_MR,
            self::LANGUAGE_FR_MU,
            self::LANGUAGE_FR_NC,
            self::LANGUAGE_FR_NE,
            self::LANGUAGE_FR_PF,
            self::LANGUAGE_FR_PM,
            self::LANGUAGE_FR_RE,
            self::LANGUAGE_FR_RW,
            self::LANGUAGE_FR_SC,
            self::LANGUAGE_FR_SN,
            self::LANGUAGE_FR_SY,
            self::LANGUAGE_FR_TD,
            self::LANGUAGE_FR_TG,
            self::LANGUAGE_FR_TN,
            self::LANGUAGE_FR_VU,
            self::LANGUAGE_FR_WF,
            self::LANGUAGE_FR_YT,
            self::LANGUAGE_FUR,
            self::LANGUAGE_FUR_IT,
            self::LANGUAGE_FY,
            self::LANGUAGE_FY_NL,
            self::LANGUAGE_GA,
            self::LANGUAGE_GA_IE,
            self::LANGUAGE_GD,
            self::LANGUAGE_GD_GB,
            self::LANGUAGE_GL,
            self::LANGUAGE_GL_ES,
            self::LANGUAGE_GSW,
            self::LANGUAGE_GSW_CH,
            self::LANGUAGE_GSW_FR,
            self::LANGUAGE_GSW_LI,
            self::LANGUAGE_GU,
            self::LANGUAGE_GU_IN,
            self::LANGUAGE_GUZ,
            self::LANGUAGE_GUZ_KE,
            self::LANGUAGE_GV,
            self::LANGUAGE_GV_IM,
            self::LANGUAGE_HA,
            self::LANGUAGE_HA_GH,
            self::LANGUAGE_HA_NE,
            self::LANGUAGE_HA_NG,
            self::LANGUAGE_HAW,
            self::LANGUAGE_HAW_US,
            self::LANGUAGE_HE,
            self::LANGUAGE_HI,
            self::LANGUAGE_HI_IN,
            self::LANGUAGE_HR,
            self::LANGUAGE_HR_BA,
            self::LANGUAGE_HR_HR,
            self::LANGUAGE_HSB,
            self::LANGUAGE_HSB_DE,
            self::LANGUAGE_HU,
            self::LANGUAGE_HU_HU,
            self::LANGUAGE_HY,
            self::LANGUAGE_HY_AM,
            self::LANGUAGE_ID,
            self::LANGUAGE_IG,
            self::LANGUAGE_IG_NG,
            self::LANGUAGE_II,
            self::LANGUAGE_II_CN,
            self::LANGUAGE_ID_ID,
            self::LANGUAGE_IS,
            self::LANGUAGE_IS_IS,
            self::LANGUAGE_IT,
            self::LANGUAGE_IT_CH,
            self::LANGUAGE_IT_IT,
            self::LANGUAGE_IT_SM,
            self::LANGUAGE_IT_VA,
            self::LANGUAGE_HE_IL,
            self::LANGUAGE_JA,
            self::LANGUAGE_JA_JP,
            self::LANGUAGE_JGO,
            self::LANGUAGE_JGO_CM,
            self::LANGUAGE_YI,
            self::LANGUAGE_YI_001,
            self::LANGUAGE_JMC,
            self::LANGUAGE_JMC_TZ,
            self::LANGUAGE_KA,
            self::LANGUAGE_KA_GE,
            self::LANGUAGE_KAB,
            self::LANGUAGE_KAB_DZ,
            self::LANGUAGE_KAM,
            self::LANGUAGE_KAM_KE,
            self::LANGUAGE_KDE,
            self::LANGUAGE_KDE_TZ,
            self::LANGUAGE_KEA,
            self::LANGUAGE_KEA_CV,
            self::LANGUAGE_KHQ,
            self::LANGUAGE_KHQ_ML,
            self::LANGUAGE_KI,
            self::LANGUAGE_KI_KE,
            self::LANGUAGE_KK,
            self::LANGUAGE_KK_KZ,
            self::LANGUAGE_KKJ,
            self::LANGUAGE_KKJ_CM,
            self::LANGUAGE_KL,
            self::LANGUAGE_KL_GL,
            self::LANGUAGE_KLN,
            self::LANGUAGE_KLN_KE,
            self::LANGUAGE_KM,
            self::LANGUAGE_KM_KH,
            self::LANGUAGE_KN,
            self::LANGUAGE_KN_IN,
            self::LANGUAGE_KO,
            self::LANGUAGE_KO_KP,
            self::LANGUAGE_KO_KR,
            self::LANGUAGE_KOK,
            self::LANGUAGE_KOK_IN,
            self::LANGUAGE_KS,
            self::LANGUAGE_KS_IN,
            self::LANGUAGE_KSB,
            self::LANGUAGE_KSB_TZ,
            self::LANGUAGE_KSF,
            self::LANGUAGE_KSF_CM,
            self::LANGUAGE_KSH,
            self::LANGUAGE_KSH_DE,
            self::LANGUAGE_KW,
            self::LANGUAGE_KW_GB,
            self::LANGUAGE_KY,
            self::LANGUAGE_KY_KG,
            self::LANGUAGE_LAG,
            self::LANGUAGE_LAG_TZ,
            self::LANGUAGE_LB,
            self::LANGUAGE_LB_LU,
            self::LANGUAGE_LG,
            self::LANGUAGE_LG_UG,
            self::LANGUAGE_LKT,
            self::LANGUAGE_LKT_US,
            self::LANGUAGE_LN,
            self::LANGUAGE_LN_AO,
            self::LANGUAGE_LN_CD,
            self::LANGUAGE_LN_CF,
            self::LANGUAGE_LN_CG,
            self::LANGUAGE_LO,
            self::LANGUAGE_LO_LA,
            self::LANGUAGE_LRC,
            self::LANGUAGE_LRC_IQ,
            self::LANGUAGE_LRC_IR,
            self::LANGUAGE_LT,
            self::LANGUAGE_LT_LT,
            self::LANGUAGE_LU,
            self::LANGUAGE_LU_CD,
            self::LANGUAGE_LUO,
            self::LANGUAGE_LUO_KE,
            self::LANGUAGE_LUY,
            self::LANGUAGE_LUY_KE,
            self::LANGUAGE_LV,
            self::LANGUAGE_LV_LV,
            self::LANGUAGE_MAS,
            self::LANGUAGE_MAS_KE,
            self::LANGUAGE_MAS_TZ,
            self::LANGUAGE_MER,
            self::LANGUAGE_MER_KE,
            self::LANGUAGE_MFE,
            self::LANGUAGE_MFE_MU,
            self::LANGUAGE_MG,
            self::LANGUAGE_MG_MG,
            self::LANGUAGE_MGH,
            self::LANGUAGE_MGH_MZ,
            self::LANGUAGE_MGO,
            self::LANGUAGE_MGO_CM,
            self::LANGUAGE_MK,
            self::LANGUAGE_MK_MK,
            self::LANGUAGE_ML,
            self::LANGUAGE_ML_IN,
            self::LANGUAGE_MN,
            self::LANGUAGE_MN_MN,
            self::LANGUAGE_MR,
            self::LANGUAGE_MR_IN,
            self::LANGUAGE_MS,
            self::LANGUAGE_MS_BN,
            self::LANGUAGE_MS_MY,
            self::LANGUAGE_MS_SG,
            self::LANGUAGE_MT,
            self::LANGUAGE_MT_MT,
            self::LANGUAGE_MUA,
            self::LANGUAGE_MUA_CM,
            self::LANGUAGE_MY,
            self::LANGUAGE_MY_MM,
            self::LANGUAGE_MZN,
            self::LANGUAGE_MZN_IR,
            self::LANGUAGE_NAQ,
            self::LANGUAGE_NAQ_NA,
            self::LANGUAGE_NB,
            self::LANGUAGE_NB_NO,
            self::LANGUAGE_NB_SJ,
            self::LANGUAGE_ND,
            self::LANGUAGE_ND_ZW,
            self::LANGUAGE_NDS,
            self::LANGUAGE_NDS_DE,
            self::LANGUAGE_NDS_NL,
            self::LANGUAGE_NE,
            self::LANGUAGE_NE_IN,
            self::LANGUAGE_NE_NP,
            self::LANGUAGE_NL,
            self::LANGUAGE_NL_AW,
            self::LANGUAGE_NL_BE,
            self::LANGUAGE_NL_CH,
            self::LANGUAGE_NL_BQ,
            self::LANGUAGE_NL_CW,
            self::LANGUAGE_NL_LU,
            self::LANGUAGE_NL_NL,
            self::LANGUAGE_NL_SR,
            self::LANGUAGE_NL_SX,
            self::LANGUAGE_NMG,
            self::LANGUAGE_NMG_CM,
            self::LANGUAGE_NN,
            self::LANGUAGE_NN_NO,
            self::LANGUAGE_NNH,
            self::LANGUAGE_NNH_CM,
            self::LANGUAGE_NO,
            self::LANGUAGE_NO_NO,
            self::LANGUAGE_NUS,
            self::LANGUAGE_NUS_SS,
            self::LANGUAGE_NYN,
            self::LANGUAGE_NYN_UG,
            self::LANGUAGE_OM,
            self::LANGUAGE_OM_ET,
            self::LANGUAGE_OM_KE,
            self::LANGUAGE__OR,
            self::LANGUAGE_OR_IN,
            self::LANGUAGE_OS,
            self::LANGUAGE_OS_GE,
            self::LANGUAGE_OS_RU,
            self::LANGUAGE_PA,
            self::LANGUAGE_PA_IN,
            self::LANGUAGE_PA_PK,
            self::LANGUAGE_PL,
            self::LANGUAGE_PL_PL,
            self::LANGUAGE_PRG,
            self::LANGUAGE_PRG_001,
            self::LANGUAGE_PS,
            self::LANGUAGE_PS_AF,
            self::LANGUAGE_PT,
            self::LANGUAGE_PT_AO,
            self::LANGUAGE_PT_BR,
            self::LANGUAGE_PT_CH,
            self::LANGUAGE_PT_CV,
            self::LANGUAGE_PT_GQ,
            self::LANGUAGE_PT_GW,
            self::LANGUAGE_PT_LU,
            self::LANGUAGE_PT_MO,
            self::LANGUAGE_PT_MZ,
            self::LANGUAGE_PT_PT,
            self::LANGUAGE_PT_ST,
            self::LANGUAGE_PT_TL,
            self::LANGUAGE_QU,
            self::LANGUAGE_QU_BO,
            self::LANGUAGE_QU_EC,
            self::LANGUAGE_QU_PE,
            self::LANGUAGE_RM,
            self::LANGUAGE_RM_CH,
            self::LANGUAGE_RN,
            self::LANGUAGE_RN_BI,
            self::LANGUAGE_RO,
            self::LANGUAGE_RO_MD,
            self::LANGUAGE_RO_RO,
            self::LANGUAGE_ROF,
            self::LANGUAGE_ROF_TZ,
            self::LANGUAGE_RU,
            self::LANGUAGE_RU_BY,
            self::LANGUAGE_RU_KG,
            self::LANGUAGE_RU_KZ,
            self::LANGUAGE_RU_MD,
            self::LANGUAGE_RU_RU,
            self::LANGUAGE_RU_UA,
            self::LANGUAGE_RW,
            self::LANGUAGE_RW_RW,
            self::LANGUAGE_RWK,
            self::LANGUAGE_RWK_TZ,
            self::LANGUAGE_SA,
            self::LANGUAGE_SAH,
            self::LANGUAGE_SAH_RU,
            self::LANGUAGE_SAQ,
            self::LANGUAGE_SAQ_KE,
            self::LANGUAGE_SBP,
            self::LANGUAGE_SBP_TZ,
            self::LANGUAGE_SD,
            self::LANGUAGE_SD_PK,
            self::LANGUAGE_SE,
            self::LANGUAGE_SE_FI,
            self::LANGUAGE_SE_NO,
            self::LANGUAGE_SE_SE,
            self::LANGUAGE_SEH,
            self::LANGUAGE_SEH_MZ,
            self::LANGUAGE_SES,
            self::LANGUAGE_SES_ML,
            self::LANGUAGE_SG,
            self::LANGUAGE_SG_CF,
            self::LANGUAGE_SHI,
            self::LANGUAGE_SHI_MA,
            self::LANGUAGE_SI,
            self::LANGUAGE_SI_LK,
            self::LANGUAGE_SK,
            self::LANGUAGE_SK_SK,
            self::LANGUAGE_SL,
            self::LANGUAGE_SL_SI,
            self::LANGUAGE_SMN,
            self::LANGUAGE_SMN_FI,
            self::LANGUAGE_SN,
            self::LANGUAGE_SN_ZW,
            self::LANGUAGE_SO,
            self::LANGUAGE_SO_DJ,
            self::LANGUAGE_SO_ET,
            self::LANGUAGE_SO_KE,
            self::LANGUAGE_SO_SO,
            self::LANGUAGE_SQ,
            self::LANGUAGE_SQ_AL,
            self::LANGUAGE_SQ_MK,
            self::LANGUAGE_SQ_XK,
            self::LANGUAGE_SR,
            self::LANGUAGE_SR_BA,
            self::LANGUAGE_SR_CS,
            self::LANGUAGE_SR_ME,
            self::LANGUAGE_SR_RS,
            self::LANGUAGE_SR_XK,
            self::LANGUAGE_SV,
            self::LANGUAGE_SV_AX,
            self::LANGUAGE_SV_FI,
            self::LANGUAGE_SV_SE,
            self::LANGUAGE_SW,
            self::LANGUAGE_SW_CD,
            self::LANGUAGE_SW_KE,
            self::LANGUAGE_SW_TZ,
            self::LANGUAGE_SW_UG,
            self::LANGUAGE_SY,
            self::LANGUAGE_TA,
            self::LANGUAGE_TA_IN,
            self::LANGUAGE_TA_LK,
            self::LANGUAGE_TA_MY,
            self::LANGUAGE_TA_SG,
            self::LANGUAGE_TE,
            self::LANGUAGE_TE_IN,
            self::LANGUAGE_TEO,
            self::LANGUAGE_TEO_KE,
            self::LANGUAGE_TEO_UG,
            self::LANGUAGE_TG,
            self::LANGUAGE_TG_TJ,
            self::LANGUAGE_TH,
            self::LANGUAGE_TH_TH,
            self::LANGUAGE_TI,
            self::LANGUAGE_TI_ER,
            self::LANGUAGE_TI_ET,
            self::LANGUAGE_TK,
            self::LANGUAGE_TK_TM,
            self::LANGUAGE_TO,
            self::LANGUAGE_TO_TO,
            self::LANGUAGE_TR,
            self::LANGUAGE_TR_CY,
            self::LANGUAGE_TR_TR,
            self::LANGUAGE_TT,
            self::LANGUAGE_TT_RU,
            self::LANGUAGE_TWQ,
            self::LANGUAGE_TWQ_NE,
            self::LANGUAGE_TZM,
            self::LANGUAGE_TZM_MA,
            self::LANGUAGE_UG,
            self::LANGUAGE_UG_CN,
            self::LANGUAGE_UK,
            self::LANGUAGE_UK_UA,
            self::LANGUAGE_UR,
            self::LANGUAGE_UR_IN,
            self::LANGUAGE_UR_PK,
            self::LANGUAGE_UZ,
            self::LANGUAGE_UZ_AF,
            self::LANGUAGE_UZ_UZ,
            self::LANGUAGE_VAI,
            self::LANGUAGE_VAI_LR,
            self::LANGUAGE_VI,
            self::LANGUAGE_VI_VN,
            self::LANGUAGE_VO,
            self::LANGUAGE_VO_001,
            self::LANGUAGE_VUN,
            self::LANGUAGE_VUN_TZ,
            self::LANGUAGE_WAE,
            self::LANGUAGE_WAE_CH,
            self::LANGUAGE_WO,
            self::LANGUAGE_WO_SN,
            self::LANGUAGE_XOG,
            self::LANGUAGE_XOG_UG,
            self::LANGUAGE_YAV,
            self::LANGUAGE_YAV_CM,
            self::LANGUAGE_YO,
            self::LANGUAGE_YO_BJ,
            self::LANGUAGE_YO_NG,
            self::LANGUAGE_YUE,
            self::LANGUAGE_YUE_CN,
            self::LANGUAGE_YUE_HK,
            self::LANGUAGE_ZGH,
            self::LANGUAGE_ZGH_MA,
            self::LANGUAGE_ZH,
            self::LANGUAGE_ZH_CN,
            self::LANGUAGE_ZH_HK,
            self::LANGUAGE_ZH_MO,
            self::LANGUAGE_ZH_SG,
            self::LANGUAGE_ZH_TW,
            self::LANGUAGE_ZH_HANS,
            self::LANGUAGE_ZH_HANT,
            self::LANGUAGE_ZU,
            self::LANGUAGE_ZU_ZA,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getContentTypeCategoryAllowableValues()
    {
        return [
            self::CONTENT_TYPE_CATEGORY__0,
            self::CONTENT_TYPE_CATEGORY__1,
            self::CONTENT_TYPE_CATEGORY__2,
            self::CONTENT_TYPE_CATEGORY__3,
            self::CONTENT_TYPE_CATEGORY__4,
            self::CONTENT_TYPE_CATEGORY__5,
            self::CONTENT_TYPE_CATEGORY__6,
            self::CONTENT_TYPE_CATEGORY__7,
            self::CONTENT_TYPE_CATEGORY__8,
            self::CONTENT_TYPE_CATEGORY__9,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCurrentStateAllowableValues()
    {
        return [
            self::CURRENT_STATE_AUTOMATED,
            self::CURRENT_STATE_AUTOMATED_DRAFT,
            self::CURRENT_STATE_AUTOMATED_SENDING,
            self::CURRENT_STATE_AUTOMATED_FOR_FORM,
            self::CURRENT_STATE_AUTOMATED_FOR_FORM_BUFFER,
            self::CURRENT_STATE_AUTOMATED_FOR_FORM_DRAFT,
            self::CURRENT_STATE_AUTOMATED_FOR_FORM_LEGACY,
            self::CURRENT_STATE_BLOG_EMAIL_DRAFT,
            self::CURRENT_STATE_BLOG_EMAIL_PUBLISHED,
            self::CURRENT_STATE_DRAFT,
            self::CURRENT_STATE_DRAFT_AB,
            self::CURRENT_STATE_DRAFT_AB_VARIANT,
            self::CURRENT_STATE_ERROR,
            self::CURRENT_STATE_LOSER_AB_VARIANT,
            self::CURRENT_STATE_PAGE_STUB,
            self::CURRENT_STATE_PRE_PROCESSING,
            self::CURRENT_STATE_PROCESSING,
            self::CURRENT_STATE_PUBLISHED,
            self::CURRENT_STATE_PUBLISHED_AB,
            self::CURRENT_STATE_PUBLISHED_AB_VARIANT,
            self::CURRENT_STATE_PUBLISHED_OR_SCHEDULED,
            self::CURRENT_STATE_RSS_TO_EMAIL_DRAFT,
            self::CURRENT_STATE_RSS_TO_EMAIL_PUBLISHED,
            self::CURRENT_STATE_SCHEDULED,
            self::CURRENT_STATE_SCHEDULED_AB,
            self::CURRENT_STATE_SCHEDULED_OR_PUBLISHED,
            self::CURRENT_STATE_AUTOMATED_AB,
            self::CURRENT_STATE_AUTOMATED_AB_VARIANT,
            self::CURRENT_STATE_AUTOMATED_DRAFT_AB,
            self::CURRENT_STATE_AUTOMATED_DRAFT_ABVARIANT,
            self::CURRENT_STATE_AUTOMATED_LOSER_ABVARIANT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['slug'] = $data['slug'] ?? null;
        $this->container['content_group_id'] = $data['content_group_id'] ?? null;
        $this->container['campaign'] = $data['campaign'] ?? null;
        $this->container['category_id'] = $data['category_id'] ?? null;
        $this->container['state'] = $data['state'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['mab_experiment_id'] = $data['mab_experiment_id'] ?? null;
        $this->container['archived'] = $data['archived'] ?? null;
        $this->container['author_name'] = $data['author_name'] ?? null;
        $this->container['ab_test_id'] = $data['ab_test_id'] ?? null;
        $this->container['created_by_id'] = $data['created_by_id'] ?? null;
        $this->container['updated_by_id'] = $data['updated_by_id'] ?? null;
        $this->container['domain'] = $data['domain'] ?? null;
        $this->container['ab_status'] = $data['ab_status'] ?? null;
        $this->container['folder_id'] = $data['folder_id'] ?? null;
        $this->container['widget_containers'] = $data['widget_containers'] ?? null;
        $this->container['widgets'] = $data['widgets'] ?? null;
        $this->container['language'] = $data['language'] ?? null;
        $this->container['translated_from_id'] = $data['translated_from_id'] ?? null;
        $this->container['translations'] = $data['translations'] ?? null;
        $this->container['dynamic_page_data_source_type'] = $data['dynamic_page_data_source_type'] ?? null;
        $this->container['dynamic_page_data_source_id'] = $data['dynamic_page_data_source_id'] ?? null;
        $this->container['blog_author_id'] = $data['blog_author_id'] ?? null;
        $this->container['tag_ids'] = $data['tag_ids'] ?? null;
        $this->container['html_title'] = $data['html_title'] ?? null;
        $this->container['enable_google_amp_output_override'] = $data['enable_google_amp_output_override'] ?? null;
        $this->container['use_featured_image'] = $data['use_featured_image'] ?? null;
        $this->container['post_body'] = $data['post_body'] ?? null;
        $this->container['post_summary'] = $data['post_summary'] ?? null;
        $this->container['rss_body'] = $data['rss_body'] ?? null;
        $this->container['rss_summary'] = $data['rss_summary'] ?? null;
        $this->container['currently_published'] = $data['currently_published'] ?? null;
        $this->container['page_expiry_enabled'] = $data['page_expiry_enabled'] ?? null;
        $this->container['page_expiry_redirect_id'] = $data['page_expiry_redirect_id'] ?? null;
        $this->container['page_expiry_redirect_url'] = $data['page_expiry_redirect_url'] ?? null;
        $this->container['page_expiry_date'] = $data['page_expiry_date'] ?? null;
        $this->container['include_default_custom_css'] = $data['include_default_custom_css'] ?? null;
        $this->container['enable_layout_stylesheets'] = $data['enable_layout_stylesheets'] ?? null;
        $this->container['enable_domain_stylesheets'] = $data['enable_domain_stylesheets'] ?? null;
        $this->container['publish_immediately'] = $data['publish_immediately'] ?? null;
        $this->container['featured_image'] = $data['featured_image'] ?? null;
        $this->container['featured_image_alt_text'] = $data['featured_image_alt_text'] ?? null;
        $this->container['link_rel_canonical_url'] = $data['link_rel_canonical_url'] ?? null;
        $this->container['content_type_category'] = $data['content_type_category'] ?? null;
        $this->container['attached_stylesheets'] = $data['attached_stylesheets'] ?? null;
        $this->container['meta_description'] = $data['meta_description'] ?? null;
        $this->container['head_html'] = $data['head_html'] ?? null;
        $this->container['footer_html'] = $data['footer_html'] ?? null;
        $this->container['archived_in_dashboard'] = $data['archived_in_dashboard'] ?? null;
        $this->container['public_access_rules_enabled'] = $data['public_access_rules_enabled'] ?? null;
        $this->container['public_access_rules'] = $data['public_access_rules'] ?? null;
        $this->container['layout_sections'] = $data['layout_sections'] ?? null;
        $this->container['theme_settings_values'] = $data['theme_settings_values'] ?? null;
        $this->container['url'] = $data['url'] ?? null;
        $this->container['password'] = $data['password'] ?? null;
        $this->container['current_state'] = $data['current_state'] ?? null;
        $this->container['publish_date'] = $data['publish_date'] ?? null;
        $this->container['created'] = $data['created'] ?? null;
        $this->container['updated'] = $data['updated'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['slug'] === null) {
            $invalidProperties[] = "'slug' can't be null";
        }
        if ($this->container['content_group_id'] === null) {
            $invalidProperties[] = "'content_group_id' can't be null";
        }
        if ($this->container['campaign'] === null) {
            $invalidProperties[] = "'campaign' can't be null";
        }
        if ($this->container['category_id'] === null) {
            $invalidProperties[] = "'category_id' can't be null";
        }
        if ($this->container['state'] === null) {
            $invalidProperties[] = "'state' can't be null";
        }
        if ((mb_strlen($this->container['state']) > 25)) {
            $invalidProperties[] = "invalid value for 'state', the character length must be smaller than or equal to 25.";
        }

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['mab_experiment_id'] === null) {
            $invalidProperties[] = "'mab_experiment_id' can't be null";
        }
        if ($this->container['archived'] === null) {
            $invalidProperties[] = "'archived' can't be null";
        }
        if ($this->container['author_name'] === null) {
            $invalidProperties[] = "'author_name' can't be null";
        }
        if ($this->container['ab_test_id'] === null) {
            $invalidProperties[] = "'ab_test_id' can't be null";
        }
        if ($this->container['created_by_id'] === null) {
            $invalidProperties[] = "'created_by_id' can't be null";
        }
        if ($this->container['updated_by_id'] === null) {
            $invalidProperties[] = "'updated_by_id' can't be null";
        }
        if ($this->container['domain'] === null) {
            $invalidProperties[] = "'domain' can't be null";
        }
        if ($this->container['ab_status'] === null) {
            $invalidProperties[] = "'ab_status' can't be null";
        }
        $allowedValues = $this->getAbStatusAllowableValues();
        if (!is_null($this->container['ab_status']) && !in_array($this->container['ab_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'ab_status', must be one of '%s'",
                $this->container['ab_status'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['folder_id'] === null) {
            $invalidProperties[] = "'folder_id' can't be null";
        }
        if ($this->container['widget_containers'] === null) {
            $invalidProperties[] = "'widget_containers' can't be null";
        }
        if ($this->container['widgets'] === null) {
            $invalidProperties[] = "'widgets' can't be null";
        }
        if ($this->container['language'] === null) {
            $invalidProperties[] = "'language' can't be null";
        }
        $allowedValues = $this->getLanguageAllowableValues();
        if (!is_null($this->container['language']) && !in_array($this->container['language'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'language', must be one of '%s'",
                $this->container['language'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['translated_from_id'] === null) {
            $invalidProperties[] = "'translated_from_id' can't be null";
        }
        if ($this->container['translations'] === null) {
            $invalidProperties[] = "'translations' can't be null";
        }
        if ($this->container['dynamic_page_data_source_type'] === null) {
            $invalidProperties[] = "'dynamic_page_data_source_type' can't be null";
        }
        if ($this->container['dynamic_page_data_source_id'] === null) {
            $invalidProperties[] = "'dynamic_page_data_source_id' can't be null";
        }
        if ($this->container['blog_author_id'] === null) {
            $invalidProperties[] = "'blog_author_id' can't be null";
        }
        if ($this->container['tag_ids'] === null) {
            $invalidProperties[] = "'tag_ids' can't be null";
        }
        if ($this->container['html_title'] === null) {
            $invalidProperties[] = "'html_title' can't be null";
        }
        if ($this->container['enable_google_amp_output_override'] === null) {
            $invalidProperties[] = "'enable_google_amp_output_override' can't be null";
        }
        if ($this->container['use_featured_image'] === null) {
            $invalidProperties[] = "'use_featured_image' can't be null";
        }
        if ($this->container['post_body'] === null) {
            $invalidProperties[] = "'post_body' can't be null";
        }
        if ($this->container['post_summary'] === null) {
            $invalidProperties[] = "'post_summary' can't be null";
        }
        if ($this->container['rss_body'] === null) {
            $invalidProperties[] = "'rss_body' can't be null";
        }
        if ($this->container['rss_summary'] === null) {
            $invalidProperties[] = "'rss_summary' can't be null";
        }
        if ($this->container['currently_published'] === null) {
            $invalidProperties[] = "'currently_published' can't be null";
        }
        if ($this->container['page_expiry_enabled'] === null) {
            $invalidProperties[] = "'page_expiry_enabled' can't be null";
        }
        if ($this->container['page_expiry_redirect_id'] === null) {
            $invalidProperties[] = "'page_expiry_redirect_id' can't be null";
        }
        if ($this->container['page_expiry_redirect_url'] === null) {
            $invalidProperties[] = "'page_expiry_redirect_url' can't be null";
        }
        if ($this->container['page_expiry_date'] === null) {
            $invalidProperties[] = "'page_expiry_date' can't be null";
        }
        if ($this->container['include_default_custom_css'] === null) {
            $invalidProperties[] = "'include_default_custom_css' can't be null";
        }
        if ($this->container['enable_layout_stylesheets'] === null) {
            $invalidProperties[] = "'enable_layout_stylesheets' can't be null";
        }
        if ($this->container['enable_domain_stylesheets'] === null) {
            $invalidProperties[] = "'enable_domain_stylesheets' can't be null";
        }
        if ($this->container['publish_immediately'] === null) {
            $invalidProperties[] = "'publish_immediately' can't be null";
        }
        if ($this->container['featured_image'] === null) {
            $invalidProperties[] = "'featured_image' can't be null";
        }
        if ($this->container['featured_image_alt_text'] === null) {
            $invalidProperties[] = "'featured_image_alt_text' can't be null";
        }
        if ($this->container['link_rel_canonical_url'] === null) {
            $invalidProperties[] = "'link_rel_canonical_url' can't be null";
        }
        if ($this->container['content_type_category'] === null) {
            $invalidProperties[] = "'content_type_category' can't be null";
        }
        $allowedValues = $this->getContentTypeCategoryAllowableValues();
        if (!is_null($this->container['content_type_category']) && !in_array($this->container['content_type_category'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'content_type_category', must be one of '%s'",
                $this->container['content_type_category'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['attached_stylesheets'] === null) {
            $invalidProperties[] = "'attached_stylesheets' can't be null";
        }
        if ($this->container['meta_description'] === null) {
            $invalidProperties[] = "'meta_description' can't be null";
        }
        if ($this->container['head_html'] === null) {
            $invalidProperties[] = "'head_html' can't be null";
        }
        if ($this->container['footer_html'] === null) {
            $invalidProperties[] = "'footer_html' can't be null";
        }
        if ($this->container['archived_in_dashboard'] === null) {
            $invalidProperties[] = "'archived_in_dashboard' can't be null";
        }
        if ($this->container['public_access_rules_enabled'] === null) {
            $invalidProperties[] = "'public_access_rules_enabled' can't be null";
        }
        if ($this->container['public_access_rules'] === null) {
            $invalidProperties[] = "'public_access_rules' can't be null";
        }
        if ($this->container['layout_sections'] === null) {
            $invalidProperties[] = "'layout_sections' can't be null";
        }
        if ($this->container['theme_settings_values'] === null) {
            $invalidProperties[] = "'theme_settings_values' can't be null";
        }
        if ($this->container['url'] === null) {
            $invalidProperties[] = "'url' can't be null";
        }
        if ($this->container['password'] === null) {
            $invalidProperties[] = "'password' can't be null";
        }
        if ($this->container['current_state'] === null) {
            $invalidProperties[] = "'current_state' can't be null";
        }
        $allowedValues = $this->getCurrentStateAllowableValues();
        if (!is_null($this->container['current_state']) && !in_array($this->container['current_state'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'current_state', must be one of '%s'",
                $this->container['current_state'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['publish_date'] === null) {
            $invalidProperties[] = "'publish_date' can't be null";
        }
        if ($this->container['created'] === null) {
            $invalidProperties[] = "'created' can't be null";
        }
        if ($this->container['updated'] === null) {
            $invalidProperties[] = "'updated' can't be null";
        }
        if ($this->container['deleted_at'] === null) {
            $invalidProperties[] = "'deleted_at' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id The unique ID of the Blog Post.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets slug
     *
     * @return string
     */
    public function getSlug()
    {
        return $this->container['slug'];
    }

    /**
     * Sets slug
     *
     * @param string $slug The path of the this blog post. This field is appended to the domain to construct the url of this post.
     *
     * @return self
     */
    public function setSlug($slug)
    {
        $this->container['slug'] = $slug;

        return $this;
    }

    /**
     * Gets content_group_id
     *
     * @return string
     */
    public function getContentGroupId()
    {
        return $this->container['content_group_id'];
    }

    /**
     * Sets content_group_id
     *
     * @param string $content_group_id The ID of the parent Blog this Blog Post is associated with.
     *
     * @return self
     */
    public function setContentGroupId($content_group_id)
    {
        $this->container['content_group_id'] = $content_group_id;

        return $this;
    }

    /**
     * Gets campaign
     *
     * @return string
     */
    public function getCampaign()
    {
        return $this->container['campaign'];
    }

    /**
     * Sets campaign
     *
     * @param string $campaign The GUID of the marketing campaign this Blog Post is a part of.
     *
     * @return self
     */
    public function setCampaign($campaign)
    {
        $this->container['campaign'] = $campaign;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return int
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param int $category_id ID of the type of object this is. Should always .
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets state
     *
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     *
     * @param string $state An ENUM descibing the current state of this Blog Post.
     *
     * @return self
     */
    public function setState($state)
    {
        if ((mb_strlen($state) > 25)) {
            throw new \InvalidArgumentException('invalid length for $state when calling BlogPost., must be smaller than or equal to 25.');
        }

        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The internal name of the Blog Post.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets mab_experiment_id
     *
     * @return string
     */
    public function getMabExperimentId()
    {
        return $this->container['mab_experiment_id'];
    }

    /**
     * Sets mab_experiment_id
     *
     * @param string $mab_experiment_id mab_experiment_id
     *
     * @return self
     */
    public function setMabExperimentId($mab_experiment_id)
    {
        $this->container['mab_experiment_id'] = $mab_experiment_id;

        return $this;
    }

    /**
     * Gets archived
     *
     * @return bool
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived
     *
     * @param bool $archived archived
     *
     * @return self
     */
    public function setArchived($archived)
    {
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets author_name
     *
     * @return string
     */
    public function getAuthorName()
    {
        return $this->container['author_name'];
    }

    /**
     * Sets author_name
     *
     * @param string $author_name The name of the user that updated this Blog Post.
     *
     * @return self
     */
    public function setAuthorName($author_name)
    {
        $this->container['author_name'] = $author_name;

        return $this;
    }

    /**
     * Gets ab_test_id
     *
     * @return string
     */
    public function getAbTestId()
    {
        return $this->container['ab_test_id'];
    }

    /**
     * Sets ab_test_id
     *
     * @param string $ab_test_id ab_test_id
     *
     * @return self
     */
    public function setAbTestId($ab_test_id)
    {
        $this->container['ab_test_id'] = $ab_test_id;

        return $this;
    }

    /**
     * Gets created_by_id
     *
     * @return string
     */
    public function getCreatedById()
    {
        return $this->container['created_by_id'];
    }

    /**
     * Sets created_by_id
     *
     * @param string $created_by_id The ID of the user that created this Blog Post.
     *
     * @return self
     */
    public function setCreatedById($created_by_id)
    {
        $this->container['created_by_id'] = $created_by_id;

        return $this;
    }

    /**
     * Gets updated_by_id
     *
     * @return string
     */
    public function getUpdatedById()
    {
        return $this->container['updated_by_id'];
    }

    /**
     * Sets updated_by_id
     *
     * @param string $updated_by_id The ID of the user that updated this Blog Post.
     *
     * @return self
     */
    public function setUpdatedById($updated_by_id)
    {
        $this->container['updated_by_id'] = $updated_by_id;

        return $this;
    }

    /**
     * Gets domain
     *
     * @return string
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     *
     * @param string $domain The domain this Blog Post will resolve to. If null, the Blog Post will default to the domain of the ParentBlog.
     *
     * @return self
     */
    public function setDomain($domain)
    {
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets ab_status
     *
     * @return string
     */
    public function getAbStatus()
    {
        return $this->container['ab_status'];
    }

    /**
     * Sets ab_status
     *
     * @param string $ab_status ab_status
     *
     * @return self
     */
    public function setAbStatus($ab_status)
    {
        $allowedValues = $this->getAbStatusAllowableValues();
        if (!in_array($ab_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'ab_status', must be one of '%s'",
                    $ab_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['ab_status'] = $ab_status;

        return $this;
    }

    /**
     * Gets folder_id
     *
     * @return string
     */
    public function getFolderId()
    {
        return $this->container['folder_id'];
    }

    /**
     * Sets folder_id
     *
     * @param string $folder_id folder_id
     *
     * @return self
     */
    public function setFolderId($folder_id)
    {
        $this->container['folder_id'] = $folder_id;

        return $this;
    }

    /**
     * Gets widget_containers
     *
     * @return array<string,object>
     */
    public function getWidgetContainers()
    {
        return $this->container['widget_containers'];
    }

    /**
     * Sets widget_containers
     *
     * @param array<string,object> $widget_containers A data structure containing the data for all the modules inside the containers for this post. This will only be populated if the page has widget containers.
     *
     * @return self
     */
    public function setWidgetContainers($widget_containers)
    {
        $this->container['widget_containers'] = $widget_containers;

        return $this;
    }

    /**
     * Gets widgets
     *
     * @return array<string,object>
     */
    public function getWidgets()
    {
        return $this->container['widgets'];
    }

    /**
     * Sets widgets
     *
     * @param array<string,object> $widgets A data structure containing the data for all the modules for this page.
     *
     * @return self
     */
    public function setWidgets($widgets)
    {
        $this->container['widgets'] = $widgets;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string $language The explicitly defined ISO 639 language code of the Blog Post. If null, the Blog Post will default to the language of the ParentBlog.
     *
     * @return self
     */
    public function setLanguage($language)
    {
        $allowedValues = $this->getLanguageAllowableValues();
        if (!in_array($language, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'language', must be one of '%s'",
                    $language,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets translated_from_id
     *
     * @return string
     */
    public function getTranslatedFromId()
    {
        return $this->container['translated_from_id'];
    }

    /**
     * Sets translated_from_id
     *
     * @param string $translated_from_id ID of the primary blog post this object was translated from.
     *
     * @return self
     */
    public function setTranslatedFromId($translated_from_id)
    {
        $this->container['translated_from_id'] = $translated_from_id;

        return $this;
    }

    /**
     * Gets translations
     *
     * @return array<string,\HubSpot\Client\Cms\Blogs\BlogPosts\Model\ContentLanguageVariation>
     */
    public function getTranslations()
    {
        return $this->container['translations'];
    }

    /**
     * Sets translations
     *
     * @param array<string,\HubSpot\Client\Cms\Blogs\BlogPosts\Model\ContentLanguageVariation> $translations translations
     *
     * @return self
     */
    public function setTranslations($translations)
    {
        $this->container['translations'] = $translations;

        return $this;
    }

    /**
     * Gets dynamic_page_data_source_type
     *
     * @return int
     */
    public function getDynamicPageDataSourceType()
    {
        return $this->container['dynamic_page_data_source_type'];
    }

    /**
     * Sets dynamic_page_data_source_type
     *
     * @param int $dynamic_page_data_source_type dynamic_page_data_source_type
     *
     * @return self
     */
    public function setDynamicPageDataSourceType($dynamic_page_data_source_type)
    {
        $this->container['dynamic_page_data_source_type'] = $dynamic_page_data_source_type;

        return $this;
    }

    /**
     * Gets dynamic_page_data_source_id
     *
     * @return string
     */
    public function getDynamicPageDataSourceId()
    {
        return $this->container['dynamic_page_data_source_id'];
    }

    /**
     * Sets dynamic_page_data_source_id
     *
     * @param string $dynamic_page_data_source_id dynamic_page_data_source_id
     *
     * @return self
     */
    public function setDynamicPageDataSourceId($dynamic_page_data_source_id)
    {
        $this->container['dynamic_page_data_source_id'] = $dynamic_page_data_source_id;

        return $this;
    }

    /**
     * Gets blog_author_id
     *
     * @return string
     */
    public function getBlogAuthorId()
    {
        return $this->container['blog_author_id'];
    }

    /**
     * Sets blog_author_id
     *
     * @param string $blog_author_id The ID of the Blog Author associated with this Blog Post.
     *
     * @return self
     */
    public function setBlogAuthorId($blog_author_id)
    {
        $this->container['blog_author_id'] = $blog_author_id;

        return $this;
    }

    /**
     * Gets tag_ids
     *
     * @return int[]
     */
    public function getTagIds()
    {
        return $this->container['tag_ids'];
    }

    /**
     * Sets tag_ids
     *
     * @param int[] $tag_ids List of IDs for the tags associated with this Blog Post.
     *
     * @return self
     */
    public function setTagIds($tag_ids)
    {
        $this->container['tag_ids'] = $tag_ids;

        return $this;
    }

    /**
     * Gets html_title
     *
     * @return string
     */
    public function getHtmlTitle()
    {
        return $this->container['html_title'];
    }

    /**
     * Sets html_title
     *
     * @param string $html_title The html title of this Blog Post.
     *
     * @return self
     */
    public function setHtmlTitle($html_title)
    {
        $this->container['html_title'] = $html_title;

        return $this;
    }

    /**
     * Gets enable_google_amp_output_override
     *
     * @return bool
     */
    public function getEnableGoogleAmpOutputOverride()
    {
        return $this->container['enable_google_amp_output_override'];
    }

    /**
     * Sets enable_google_amp_output_override
     *
     * @param bool $enable_google_amp_output_override Boolean to allow overriding the AMP settings for the blog.
     *
     * @return self
     */
    public function setEnableGoogleAmpOutputOverride($enable_google_amp_output_override)
    {
        $this->container['enable_google_amp_output_override'] = $enable_google_amp_output_override;

        return $this;
    }

    /**
     * Gets use_featured_image
     *
     * @return bool
     */
    public function getUseFeaturedImage()
    {
        return $this->container['use_featured_image'];
    }

    /**
     * Sets use_featured_image
     *
     * @param bool $use_featured_image Boolean to determine if this post should use a featuredImage.
     *
     * @return self
     */
    public function setUseFeaturedImage($use_featured_image)
    {
        $this->container['use_featured_image'] = $use_featured_image;

        return $this;
    }

    /**
     * Gets post_body
     *
     * @return string
     */
    public function getPostBody()
    {
        return $this->container['post_body'];
    }

    /**
     * Sets post_body
     *
     * @param string $post_body The HTML of the main post body.
     *
     * @return self
     */
    public function setPostBody($post_body)
    {
        $this->container['post_body'] = $post_body;

        return $this;
    }

    /**
     * Gets post_summary
     *
     * @return string
     */
    public function getPostSummary()
    {
        return $this->container['post_summary'];
    }

    /**
     * Sets post_summary
     *
     * @param string $post_summary The summary of the blog post that will appear on the main listing page.
     *
     * @return self
     */
    public function setPostSummary($post_summary)
    {
        $this->container['post_summary'] = $post_summary;

        return $this;
    }

    /**
     * Gets rss_body
     *
     * @return string
     */
    public function getRssBody()
    {
        return $this->container['rss_body'];
    }

    /**
     * Sets rss_body
     *
     * @param string $rss_body The contents of the RSS body for this Blog Post.
     *
     * @return self
     */
    public function setRssBody($rss_body)
    {
        $this->container['rss_body'] = $rss_body;

        return $this;
    }

    /**
     * Gets rss_summary
     *
     * @return string
     */
    public function getRssSummary()
    {
        return $this->container['rss_summary'];
    }

    /**
     * Sets rss_summary
     *
     * @param string $rss_summary The contents of the RSS summary for this Blog Post.
     *
     * @return self
     */
    public function setRssSummary($rss_summary)
    {
        $this->container['rss_summary'] = $rss_summary;

        return $this;
    }

    /**
     * Gets currently_published
     *
     * @return bool
     */
    public function getCurrentlyPublished()
    {
        return $this->container['currently_published'];
    }

    /**
     * Sets currently_published
     *
     * @param bool $currently_published currently_published
     *
     * @return self
     */
    public function setCurrentlyPublished($currently_published)
    {
        $this->container['currently_published'] = $currently_published;

        return $this;
    }

    /**
     * Gets page_expiry_enabled
     *
     * @return bool
     */
    public function getPageExpiryEnabled()
    {
        return $this->container['page_expiry_enabled'];
    }

    /**
     * Sets page_expiry_enabled
     *
     * @param bool $page_expiry_enabled page_expiry_enabled
     *
     * @return self
     */
    public function setPageExpiryEnabled($page_expiry_enabled)
    {
        $this->container['page_expiry_enabled'] = $page_expiry_enabled;

        return $this;
    }

    /**
     * Gets page_expiry_redirect_id
     *
     * @return int
     */
    public function getPageExpiryRedirectId()
    {
        return $this->container['page_expiry_redirect_id'];
    }

    /**
     * Sets page_expiry_redirect_id
     *
     * @param int $page_expiry_redirect_id page_expiry_redirect_id
     *
     * @return self
     */
    public function setPageExpiryRedirectId($page_expiry_redirect_id)
    {
        $this->container['page_expiry_redirect_id'] = $page_expiry_redirect_id;

        return $this;
    }

    /**
     * Gets page_expiry_redirect_url
     *
     * @return string
     */
    public function getPageExpiryRedirectUrl()
    {
        return $this->container['page_expiry_redirect_url'];
    }

    /**
     * Sets page_expiry_redirect_url
     *
     * @param string $page_expiry_redirect_url page_expiry_redirect_url
     *
     * @return self
     */
    public function setPageExpiryRedirectUrl($page_expiry_redirect_url)
    {
        $this->container['page_expiry_redirect_url'] = $page_expiry_redirect_url;

        return $this;
    }

    /**
     * Gets page_expiry_date
     *
     * @return int
     */
    public function getPageExpiryDate()
    {
        return $this->container['page_expiry_date'];
    }

    /**
     * Sets page_expiry_date
     *
     * @param int $page_expiry_date page_expiry_date
     *
     * @return self
     */
    public function setPageExpiryDate($page_expiry_date)
    {
        $this->container['page_expiry_date'] = $page_expiry_date;

        return $this;
    }

    /**
     * Gets include_default_custom_css
     *
     * @return bool
     */
    public function getIncludeDefaultCustomCss()
    {
        return $this->container['include_default_custom_css'];
    }

    /**
     * Sets include_default_custom_css
     *
     * @param bool $include_default_custom_css Boolean to determine whether or not the Primary CSS Files should be applied.
     *
     * @return self
     */
    public function setIncludeDefaultCustomCss($include_default_custom_css)
    {
        $this->container['include_default_custom_css'] = $include_default_custom_css;

        return $this;
    }

    /**
     * Gets enable_layout_stylesheets
     *
     * @return bool
     */
    public function getEnableLayoutStylesheets()
    {
        return $this->container['enable_layout_stylesheets'];
    }

    /**
     * Sets enable_layout_stylesheets
     *
     * @param bool $enable_layout_stylesheets Boolean to determine whether or not the styles from the template should be applied.
     *
     * @return self
     */
    public function setEnableLayoutStylesheets($enable_layout_stylesheets)
    {
        $this->container['enable_layout_stylesheets'] = $enable_layout_stylesheets;

        return $this;
    }

    /**
     * Gets enable_domain_stylesheets
     *
     * @return bool
     */
    public function getEnableDomainStylesheets()
    {
        return $this->container['enable_domain_stylesheets'];
    }

    /**
     * Sets enable_domain_stylesheets
     *
     * @param bool $enable_domain_stylesheets Boolean to determine whether or not the styles from the template should be applied.
     *
     * @return self
     */
    public function setEnableDomainStylesheets($enable_domain_stylesheets)
    {
        $this->container['enable_domain_stylesheets'] = $enable_domain_stylesheets;

        return $this;
    }

    /**
     * Gets publish_immediately
     *
     * @return bool
     */
    public function getPublishImmediately()
    {
        return $this->container['publish_immediately'];
    }

    /**
     * Sets publish_immediately
     *
     * @param bool $publish_immediately Set this to true if you want to be published immediately when the schedule publish endpoint is called, and to ignore the publish_date setting.
     *
     * @return self
     */
    public function setPublishImmediately($publish_immediately)
    {
        $this->container['publish_immediately'] = $publish_immediately;

        return $this;
    }

    /**
     * Gets featured_image
     *
     * @return string
     */
    public function getFeaturedImage()
    {
        return $this->container['featured_image'];
    }

    /**
     * Sets featured_image
     *
     * @param string $featured_image The featuredImage of this Blog Post.
     *
     * @return self
     */
    public function setFeaturedImage($featured_image)
    {
        $this->container['featured_image'] = $featured_image;

        return $this;
    }

    /**
     * Gets featured_image_alt_text
     *
     * @return string
     */
    public function getFeaturedImageAltText()
    {
        return $this->container['featured_image_alt_text'];
    }

    /**
     * Sets featured_image_alt_text
     *
     * @param string $featured_image_alt_text Alt Text of the featuredImage.
     *
     * @return self
     */
    public function setFeaturedImageAltText($featured_image_alt_text)
    {
        $this->container['featured_image_alt_text'] = $featured_image_alt_text;

        return $this;
    }

    /**
     * Gets link_rel_canonical_url
     *
     * @return string
     */
    public function getLinkRelCanonicalUrl()
    {
        return $this->container['link_rel_canonical_url'];
    }

    /**
     * Sets link_rel_canonical_url
     *
     * @param string $link_rel_canonical_url Optional override to set the URL to be used in the rel=canonical link tag on the page.
     *
     * @return self
     */
    public function setLinkRelCanonicalUrl($link_rel_canonical_url)
    {
        $this->container['link_rel_canonical_url'] = $link_rel_canonical_url;

        return $this;
    }

    /**
     * Gets content_type_category
     *
     * @return string
     */
    public function getContentTypeCategory()
    {
        return $this->container['content_type_category'];
    }

    /**
     * Sets content_type_category
     *
     * @param string $content_type_category An ENUM descibing the type of this object. Should always be BLOG_POST.
     *
     * @return self
     */
    public function setContentTypeCategory($content_type_category)
    {
        $allowedValues = $this->getContentTypeCategoryAllowableValues();
        if (!in_array($content_type_category, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'content_type_category', must be one of '%s'",
                    $content_type_category,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['content_type_category'] = $content_type_category;

        return $this;
    }

    /**
     * Gets attached_stylesheets
     *
     * @return array<string,object>[]
     */
    public function getAttachedStylesheets()
    {
        return $this->container['attached_stylesheets'];
    }

    /**
     * Sets attached_stylesheets
     *
     * @param array<string,object>[] $attached_stylesheets List of stylesheets to attach to this blog post. These stylesheets are attached to just this page. Order of precedence is bottom to top, just like in the HTML.
     *
     * @return self
     */
    public function setAttachedStylesheets($attached_stylesheets)
    {
        $this->container['attached_stylesheets'] = $attached_stylesheets;

        return $this;
    }

    /**
     * Gets meta_description
     *
     * @return string
     */
    public function getMetaDescription()
    {
        return $this->container['meta_description'];
    }

    /**
     * Sets meta_description
     *
     * @param string $meta_description A description that goes in <meta> tag on the page.
     *
     * @return self
     */
    public function setMetaDescription($meta_description)
    {
        $this->container['meta_description'] = $meta_description;

        return $this;
    }

    /**
     * Gets head_html
     *
     * @return string
     */
    public function getHeadHtml()
    {
        return $this->container['head_html'];
    }

    /**
     * Sets head_html
     *
     * @param string $head_html Custom HTML for embed codes, javascript, etc. that goes in the <head> tag of the page.
     *
     * @return self
     */
    public function setHeadHtml($head_html)
    {
        $this->container['head_html'] = $head_html;

        return $this;
    }

    /**
     * Gets footer_html
     *
     * @return string
     */
    public function getFooterHtml()
    {
        return $this->container['footer_html'];
    }

    /**
     * Sets footer_html
     *
     * @param string $footer_html Custom HTML for embed codes, javascript that should be placed before the </body> tag of the page.
     *
     * @return self
     */
    public function setFooterHtml($footer_html)
    {
        $this->container['footer_html'] = $footer_html;

        return $this;
    }

    /**
     * Gets archived_in_dashboard
     *
     * @return bool
     */
    public function getArchivedInDashboard()
    {
        return $this->container['archived_in_dashboard'];
    }

    /**
     * Sets archived_in_dashboard
     *
     * @param bool $archived_in_dashboard If True, the post will not show up in your dashboard, although the post could still be live.
     *
     * @return self
     */
    public function setArchivedInDashboard($archived_in_dashboard)
    {
        $this->container['archived_in_dashboard'] = $archived_in_dashboard;

        return $this;
    }

    /**
     * Gets public_access_rules_enabled
     *
     * @return bool
     */
    public function getPublicAccessRulesEnabled()
    {
        return $this->container['public_access_rules_enabled'];
    }

    /**
     * Sets public_access_rules_enabled
     *
     * @param bool $public_access_rules_enabled Boolean to determine whether or not to respect publicAccessRules.
     *
     * @return self
     */
    public function setPublicAccessRulesEnabled($public_access_rules_enabled)
    {
        $this->container['public_access_rules_enabled'] = $public_access_rules_enabled;

        return $this;
    }

    /**
     * Gets public_access_rules
     *
     * @return object[]
     */
    public function getPublicAccessRules()
    {
        return $this->container['public_access_rules'];
    }

    /**
     * Sets public_access_rules
     *
     * @param object[] $public_access_rules Rules for require member registration to access private content.
     *
     * @return self
     */
    public function setPublicAccessRules($public_access_rules)
    {
        $this->container['public_access_rules'] = $public_access_rules;

        return $this;
    }

    /**
     * Gets layout_sections
     *
     * @return array<string,\HubSpot\Client\Cms\Blogs\BlogPosts\Model\LayoutSection>
     */
    public function getLayoutSections()
    {
        return $this->container['layout_sections'];
    }

    /**
     * Sets layout_sections
     *
     * @param array<string,\HubSpot\Client\Cms\Blogs\BlogPosts\Model\LayoutSection> $layout_sections layout_sections
     *
     * @return self
     */
    public function setLayoutSections($layout_sections)
    {
        $this->container['layout_sections'] = $layout_sections;

        return $this;
    }

    /**
     * Gets theme_settings_values
     *
     * @return array<string,object>
     */
    public function getThemeSettingsValues()
    {
        return $this->container['theme_settings_values'];
    }

    /**
     * Sets theme_settings_values
     *
     * @param array<string,object> $theme_settings_values theme_settings_values
     *
     * @return self
     */
    public function setThemeSettingsValues($theme_settings_values)
    {
        $this->container['theme_settings_values'] = $theme_settings_values;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string $url A generated field representing the URL of this blog post.
     *
     * @return self
     */
    public function setUrl($url)
    {
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets password
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->container['password'];
    }

    /**
     * Sets password
     *
     * @param string $password Set this to create a password protected page. Entering the password will be required to view the page.
     *
     * @return self
     */
    public function setPassword($password)
    {
        $this->container['password'] = $password;

        return $this;
    }

    /**
     * Gets current_state
     *
     * @return string
     */
    public function getCurrentState()
    {
        return $this->container['current_state'];
    }

    /**
     * Sets current_state
     *
     * @param string $current_state A generated ENUM descibing the current state of this Blog Post. Should always match state.
     *
     * @return self
     */
    public function setCurrentState($current_state)
    {
        $allowedValues = $this->getCurrentStateAllowableValues();
        if (!in_array($current_state, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'current_state', must be one of '%s'",
                    $current_state,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['current_state'] = $current_state;

        return $this;
    }

    /**
     * Gets publish_date
     *
     * @return \DateTime
     */
    public function getPublishDate()
    {
        return $this->container['publish_date'];
    }

    /**
     * Sets publish_date
     *
     * @param \DateTime $publish_date The date (ISO8601 format) the blog post is to be published at.
     *
     * @return self
     */
    public function setPublishDate($publish_date)
    {
        $this->container['publish_date'] = $publish_date;

        return $this;
    }

    /**
     * Gets created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->container['created'];
    }

    /**
     * Sets created
     *
     * @param \DateTime $created created
     *
     * @return self
     */
    public function setCreated($created)
    {
        $this->container['created'] = $created;

        return $this;
    }

    /**
     * Gets updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->container['updated'];
    }

    /**
     * Sets updated
     *
     * @param \DateTime $updated updated
     *
     * @return self
     */
    public function setUpdated($updated)
    {
        $this->container['updated'] = $updated;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime $deleted_at The timestamp (ISO8601 format) when this Blog Post was deleted.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


