<?php
/**
 * BlogTagsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Blogs\Tags
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Blog Post endpoints
 *
 * Use these endpoints for interacting with Blog Posts, Blog Authors, and Blog Tags
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\Blogs\Tags\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Cms\Blogs\Tags\ApiException;
use HubSpot\Client\Cms\Blogs\Tags\Configuration;
use HubSpot\Client\Cms\Blogs\Tags\HeaderSelector;
use HubSpot\Client\Cms\Blogs\Tags\ObjectSerializer;

/**
 * BlogTagsApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Blogs\Tags
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BlogTagsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation archive
     *
     * Delete a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archive($object_id, $archived = null)
    {
        $this->archiveWithHttpInfo($object_id, $archived);
    }

    /**
     * Operation archiveWithHttpInfo
     *
     * Delete a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveWithHttpInfo($object_id, $archived = null)
    {
        $request = $this->archiveRequest($object_id, $archived);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveAsync
     *
     * Delete a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsync($object_id, $archived = null)
    {
        return $this->archiveAsyncWithHttpInfo($object_id, $archived)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveAsyncWithHttpInfo
     *
     * Delete a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsyncWithHttpInfo($object_id, $archived = null)
    {
        $returnType = '';
        $request = $this->archiveRequest($object_id, $archived);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archive'
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Whether to return only results that have been archived. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveRequest($object_id, $archived = null)
    {
        // verify the required parameter 'object_id' is set
        if ($object_id === null || (is_array($object_id) && count($object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $object_id when calling archive'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/{objectId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($object_id !== null) {
            $resourcePath = str_replace(
                '{' . 'objectId' . '}',
                ObjectSerializer::toPathValue($object_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation archiveBatch
     *
     * Delete a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archiveBatch($batch_input_string)
    {
        $this->archiveBatchWithHttpInfo($batch_input_string);
    }

    /**
     * Operation archiveBatchWithHttpInfo
     *
     * Delete a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveBatchWithHttpInfo($batch_input_string)
    {
        $request = $this->archiveBatchRequest($batch_input_string);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveBatchAsync
     *
     * Delete a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveBatchAsync($batch_input_string)
    {
        return $this->archiveBatchAsyncWithHttpInfo($batch_input_string)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveBatchAsyncWithHttpInfo
     *
     * Delete a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveBatchAsyncWithHttpInfo($batch_input_string)
    {
        $returnType = '';
        $request = $this->archiveBatchRequest($batch_input_string);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archiveBatch'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveBatchRequest($batch_input_string)
    {
        // verify the required parameter 'batch_input_string' is set
        if ($batch_input_string === null || (is_array($batch_input_string) && count($batch_input_string) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_string when calling archiveBatch'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/batch/archive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_string)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_string));
            } else {
                $httpBody = $batch_input_string;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation attachToLangGroup
     *
     * Attach a Blog Tag to a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function attachToLangGroup($attach_to_lang_primary_request_v_next)
    {
        list($response) = $this->attachToLangGroupWithHttpInfo($attach_to_lang_primary_request_v_next);
        return $response;
    }

    /**
     * Operation attachToLangGroupWithHttpInfo
     *
     * Attach a Blog Tag to a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function attachToLangGroupWithHttpInfo($attach_to_lang_primary_request_v_next)
    {
        $request = $this->attachToLangGroupRequest($attach_to_lang_primary_request_v_next);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Error';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation attachToLangGroupAsync
     *
     * Attach a Blog Tag to a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function attachToLangGroupAsync($attach_to_lang_primary_request_v_next)
    {
        return $this->attachToLangGroupAsyncWithHttpInfo($attach_to_lang_primary_request_v_next)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation attachToLangGroupAsyncWithHttpInfo
     *
     * Attach a Blog Tag to a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function attachToLangGroupAsyncWithHttpInfo($attach_to_lang_primary_request_v_next)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Error';
        $request = $this->attachToLangGroupRequest($attach_to_lang_primary_request_v_next);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'attachToLangGroup'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\AttachToLangPrimaryRequestVNext $attach_to_lang_primary_request_v_next The JSON representation of the AttachToLangPrimaryRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function attachToLangGroupRequest($attach_to_lang_primary_request_v_next)
    {
        // verify the required parameter 'attach_to_lang_primary_request_v_next' is set
        if ($attach_to_lang_primary_request_v_next === null || (is_array($attach_to_lang_primary_request_v_next) && count($attach_to_lang_primary_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $attach_to_lang_primary_request_v_next when calling attachToLangGroup'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/multi-language/attach-to-lang-group';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($attach_to_lang_primary_request_v_next)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($attach_to_lang_primary_request_v_next));
            } else {
                $httpBody = $attach_to_lang_primary_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation create
     *
     * Create a new Blog Tag
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of a new Blog Tag. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\Tag|\HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function create($tag)
    {
        list($response) = $this->createWithHttpInfo($tag);
        return $response;
    }

    /**
     * Operation createWithHttpInfo
     *
     * Create a new Blog Tag
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of a new Blog Tag. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\Tag|\HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWithHttpInfo($tag)
    {
        $request = $this->createRequest($tag);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Tag' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Tag' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAsync
     *
     * Create a new Blog Tag
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of a new Blog Tag. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsync($tag)
    {
        return $this->createAsyncWithHttpInfo($tag)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAsyncWithHttpInfo
     *
     * Create a new Blog Tag
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of a new Blog Tag. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsyncWithHttpInfo($tag)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag';
        $request = $this->createRequest($tag);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'create'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of a new Blog Tag. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRequest($tag)
    {
        // verify the required parameter 'tag' is set
        if ($tag === null || (is_array($tag) && count($tag) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tag when calling create'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($tag)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($tag));
            } else {
                $httpBody = $tag;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBatch
     *
     * Create a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputTag $batch_input_tag The JSON array of new Blog Tags to create. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag|\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors|\HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function createBatch($batch_input_tag)
    {
        list($response) = $this->createBatchWithHttpInfo($batch_input_tag);
        return $response;
    }

    /**
     * Operation createBatchWithHttpInfo
     *
     * Create a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputTag $batch_input_tag The JSON array of new Blog Tags to create. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag|\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors|\HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBatchWithHttpInfo($batch_input_tag)
    {
        $request = $this->createBatchRequest($batch_input_tag);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBatchAsync
     *
     * Create a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputTag $batch_input_tag The JSON array of new Blog Tags to create. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchAsync($batch_input_tag)
    {
        return $this->createBatchAsyncWithHttpInfo($batch_input_tag)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBatchAsyncWithHttpInfo
     *
     * Create a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputTag $batch_input_tag The JSON array of new Blog Tags to create. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchAsyncWithHttpInfo($batch_input_tag)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag';
        $request = $this->createBatchRequest($batch_input_tag);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBatch'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputTag $batch_input_tag The JSON array of new Blog Tags to create. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBatchRequest($batch_input_tag)
    {
        // verify the required parameter 'batch_input_tag' is set
        if ($batch_input_tag === null || (is_array($batch_input_tag) && count($batch_input_tag) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_tag when calling createBatch'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/batch/create';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_tag)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_tag));
            } else {
                $httpBody = $batch_input_tag;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLangVariation
     *
     * Create a new language variation
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\TagCloneRequestVNext $tag_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\Tag|\HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function createLangVariation($tag_clone_request_v_next)
    {
        list($response) = $this->createLangVariationWithHttpInfo($tag_clone_request_v_next);
        return $response;
    }

    /**
     * Operation createLangVariationWithHttpInfo
     *
     * Create a new language variation
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\TagCloneRequestVNext $tag_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\Tag|\HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLangVariationWithHttpInfo($tag_clone_request_v_next)
    {
        $request = $this->createLangVariationRequest($tag_clone_request_v_next);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Tag' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Tag' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLangVariationAsync
     *
     * Create a new language variation
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\TagCloneRequestVNext $tag_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLangVariationAsync($tag_clone_request_v_next)
    {
        return $this->createLangVariationAsyncWithHttpInfo($tag_clone_request_v_next)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLangVariationAsyncWithHttpInfo
     *
     * Create a new language variation
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\TagCloneRequestVNext $tag_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLangVariationAsyncWithHttpInfo($tag_clone_request_v_next)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag';
        $request = $this->createLangVariationRequest($tag_clone_request_v_next);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLangVariation'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\TagCloneRequestVNext $tag_clone_request_v_next The JSON representation of the ContentLanguageCloneRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createLangVariationRequest($tag_clone_request_v_next)
    {
        // verify the required parameter 'tag_clone_request_v_next' is set
        if ($tag_clone_request_v_next === null || (is_array($tag_clone_request_v_next) && count($tag_clone_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tag_clone_request_v_next when calling createLangVariation'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/multi-language/create-language-variation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($tag_clone_request_v_next)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($tag_clone_request_v_next));
            } else {
                $httpBody = $tag_clone_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation detachFromLangGroup
     *
     * Detach a Blog Tag from a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function detachFromLangGroup($detach_from_lang_group_request_v_next)
    {
        list($response) = $this->detachFromLangGroupWithHttpInfo($detach_from_lang_group_request_v_next);
        return $response;
    }

    /**
     * Operation detachFromLangGroupWithHttpInfo
     *
     * Detach a Blog Tag from a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function detachFromLangGroupWithHttpInfo($detach_from_lang_group_request_v_next)
    {
        $request = $this->detachFromLangGroupRequest($detach_from_lang_group_request_v_next);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Error';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation detachFromLangGroupAsync
     *
     * Detach a Blog Tag from a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function detachFromLangGroupAsync($detach_from_lang_group_request_v_next)
    {
        return $this->detachFromLangGroupAsyncWithHttpInfo($detach_from_lang_group_request_v_next)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation detachFromLangGroupAsyncWithHttpInfo
     *
     * Detach a Blog Tag from a multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function detachFromLangGroupAsyncWithHttpInfo($detach_from_lang_group_request_v_next)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Error';
        $request = $this->detachFromLangGroupRequest($detach_from_lang_group_request_v_next);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'detachFromLangGroup'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\DetachFromLangGroupRequestVNext $detach_from_lang_group_request_v_next The JSON representation of the DetachFromLangGroupRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function detachFromLangGroupRequest($detach_from_lang_group_request_v_next)
    {
        // verify the required parameter 'detach_from_lang_group_request_v_next' is set
        if ($detach_from_lang_group_request_v_next === null || (is_array($detach_from_lang_group_request_v_next) && count($detach_from_lang_group_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $detach_from_lang_group_request_v_next when calling detachFromLangGroup'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/multi-language/detach-from-lang-group';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($detach_from_lang_group_request_v_next)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($detach_from_lang_group_request_v_next));
            } else {
                $httpBody = $detach_from_lang_group_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getById
     *
     * Retrieve a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\Tag|\HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function getById($object_id, $archived = null)
    {
        list($response) = $this->getByIdWithHttpInfo($object_id, $archived);
        return $response;
    }

    /**
     * Operation getByIdWithHttpInfo
     *
     * Retrieve a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\Tag|\HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getByIdWithHttpInfo($object_id, $archived = null)
    {
        $request = $this->getByIdRequest($object_id, $archived);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Tag' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Tag' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getByIdAsync
     *
     * Retrieve a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsync($object_id, $archived = null)
    {
        return $this->getByIdAsyncWithHttpInfo($object_id, $archived)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getByIdAsyncWithHttpInfo
     *
     * Retrieve a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsyncWithHttpInfo($object_id, $archived = null)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag';
        $request = $this->getByIdRequest($object_id, $archived);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getById'
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getByIdRequest($object_id, $archived = null)
    {
        // verify the required parameter 'object_id' is set
        if ($object_id === null || (is_array($object_id) && count($object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $object_id when calling getById'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/{objectId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($object_id !== null) {
            $resourcePath = str_replace(
                '{' . 'objectId' . '}',
                ObjectSerializer::toPathValue($object_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPage
     *
     * Get all Blog Tags
     *
     * @param  \DateTime $created_at Only return Blog Tags created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Tags created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Tags created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Tags last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Tags last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Tags last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\CollectionResponseWithTotalTagForwardPaging|\HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function getPage($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null)
    {
        list($response) = $this->getPageWithHttpInfo($created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $sort, $after, $limit, $archived);
        return $response;
    }

    /**
     * Operation getPageWithHttpInfo
     *
     * Get all Blog Tags
     *
     * @param  \DateTime $created_at Only return Blog Tags created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Tags created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Tags created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Tags last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Tags last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Tags last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\CollectionResponseWithTotalTagForwardPaging|\HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPageWithHttpInfo($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null)
    {
        $request = $this->getPageRequest($created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $sort, $after, $limit, $archived);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\CollectionResponseWithTotalTagForwardPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\CollectionResponseWithTotalTagForwardPaging' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\CollectionResponseWithTotalTagForwardPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\CollectionResponseWithTotalTagForwardPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\CollectionResponseWithTotalTagForwardPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPageAsync
     *
     * Get all Blog Tags
     *
     * @param  \DateTime $created_at Only return Blog Tags created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Tags created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Tags created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Tags last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Tags last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Tags last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPageAsync($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null)
    {
        return $this->getPageAsyncWithHttpInfo($created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $sort, $after, $limit, $archived)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPageAsyncWithHttpInfo
     *
     * Get all Blog Tags
     *
     * @param  \DateTime $created_at Only return Blog Tags created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Tags created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Tags created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Tags last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Tags last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Tags last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPageAsyncWithHttpInfo($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\CollectionResponseWithTotalTagForwardPaging';
        $request = $this->getPageRequest($created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $sort, $after, $limit, $archived);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPage'
     *
     * @param  \DateTime $created_at Only return Blog Tags created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return Blog Tags created after the specified time. (optional)
     * @param  \DateTime $created_before Only return Blog Tags created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return Blog Tags last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return Blog Tags last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return Blog Tags last updated before the specified time. (optional)
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 100. (optional)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPageRequest($created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $sort = null, $after = null, $limit = null, $archived = null)
    {

        $resourcePath = '/cms/v3/blogs/tags';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_at,
            'createdAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_after,
            'createdAfter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_before,
            'createdBefore', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_at,
            'updatedAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_after,
            'updatedAfter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_before,
            'updatedBefore', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation readBatch
     *
     * Retrieve a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag|\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors|\HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function readBatch($batch_input_string, $archived = null)
    {
        list($response) = $this->readBatchWithHttpInfo($batch_input_string, $archived);
        return $response;
    }

    /**
     * Operation readBatchWithHttpInfo
     *
     * Retrieve a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag|\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors|\HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function readBatchWithHttpInfo($batch_input_string, $archived = null)
    {
        $request = $this->readBatchRequest($batch_input_string, $archived);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation readBatchAsync
     *
     * Retrieve a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readBatchAsync($batch_input_string, $archived = null)
    {
        return $this->readBatchAsyncWithHttpInfo($batch_input_string, $archived)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation readBatchAsyncWithHttpInfo
     *
     * Retrieve a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readBatchAsyncWithHttpInfo($batch_input_string, $archived = null)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag';
        $request = $this->readBatchRequest($batch_input_string, $archived);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'readBatch'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputString $batch_input_string The JSON array of Blog Tag ids. (required)
     * @param  bool $archived Specifies whether to return deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function readBatchRequest($batch_input_string, $archived = null)
    {
        // verify the required parameter 'batch_input_string' is set
        if ($batch_input_string === null || (is_array($batch_input_string) && count($batch_input_string) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_string when calling readBatch'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/batch/read';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_string)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_string));
            } else {
                $httpBody = $batch_input_string;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setLangPrimary
     *
     * Set a new primary language
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setLangPrimary($set_new_language_primary_request_v_next)
    {
        $this->setLangPrimaryWithHttpInfo($set_new_language_primary_request_v_next);
    }

    /**
     * Operation setLangPrimaryWithHttpInfo
     *
     * Set a new primary language
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setLangPrimaryWithHttpInfo($set_new_language_primary_request_v_next)
    {
        $request = $this->setLangPrimaryRequest($set_new_language_primary_request_v_next);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation setLangPrimaryAsync
     *
     * Set a new primary language
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setLangPrimaryAsync($set_new_language_primary_request_v_next)
    {
        return $this->setLangPrimaryAsyncWithHttpInfo($set_new_language_primary_request_v_next)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setLangPrimaryAsyncWithHttpInfo
     *
     * Set a new primary language
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setLangPrimaryAsyncWithHttpInfo($set_new_language_primary_request_v_next)
    {
        $returnType = '';
        $request = $this->setLangPrimaryRequest($set_new_language_primary_request_v_next);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setLangPrimary'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\SetNewLanguagePrimaryRequestVNext $set_new_language_primary_request_v_next The JSON representation of the SetNewLanguagePrimaryRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setLangPrimaryRequest($set_new_language_primary_request_v_next)
    {
        // verify the required parameter 'set_new_language_primary_request_v_next' is set
        if ($set_new_language_primary_request_v_next === null || (is_array($set_new_language_primary_request_v_next) && count($set_new_language_primary_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $set_new_language_primary_request_v_next when calling setLangPrimary'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/multi-language/set-new-lang-primary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($set_new_language_primary_request_v_next)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($set_new_language_primary_request_v_next));
            } else {
                $httpBody = $set_new_language_primary_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation update
     *
     * Update a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of the updated Blog Tag. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\Tag|\HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function update($object_id, $tag, $archived = null)
    {
        list($response) = $this->updateWithHttpInfo($object_id, $tag, $archived);
        return $response;
    }

    /**
     * Operation updateWithHttpInfo
     *
     * Update a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of the updated Blog Tag. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\Tag|\HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWithHttpInfo($object_id, $tag, $archived = null)
    {
        $request = $this->updateRequest($object_id, $tag, $archived);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Tag' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Tag' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateAsync
     *
     * Update a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of the updated Blog Tag. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAsync($object_id, $tag, $archived = null)
    {
        return $this->updateAsyncWithHttpInfo($object_id, $tag, $archived)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateAsyncWithHttpInfo
     *
     * Update a Blog Tag
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of the updated Blog Tag. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAsyncWithHttpInfo($object_id, $tag, $archived = null)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Tag';
        $request = $this->updateRequest($object_id, $tag, $archived);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'update'
     *
     * @param  string $object_id The Blog Tag id. (required)
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\Tag $tag The JSON representation of the updated Blog Tag. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateRequest($object_id, $tag, $archived = null)
    {
        // verify the required parameter 'object_id' is set
        if ($object_id === null || (is_array($object_id) && count($object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $object_id when calling update'
            );
        }
        // verify the required parameter 'tag' is set
        if ($tag === null || (is_array($tag) && count($tag) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tag when calling update'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/{objectId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($object_id !== null) {
            $resourcePath = str_replace(
                '{' . 'objectId' . '}',
                ObjectSerializer::toPathValue($object_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($tag)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($tag));
            } else {
                $httpBody = $tag;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateBatch
     *
     * Update a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Tags. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag|\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors|\HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function updateBatch($batch_input_json_node, $archived = null)
    {
        list($response) = $this->updateBatchWithHttpInfo($batch_input_json_node, $archived);
        return $response;
    }

    /**
     * Operation updateBatchWithHttpInfo
     *
     * Update a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Tags. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag|\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors|\HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBatchWithHttpInfo($batch_input_json_node, $archived = null)
    {
        $request = $this->updateBatchRequest($batch_input_json_node, $archived);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTagWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateBatchAsync
     *
     * Update a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Tags. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateBatchAsync($batch_input_json_node, $archived = null)
    {
        return $this->updateBatchAsyncWithHttpInfo($batch_input_json_node, $archived)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateBatchAsyncWithHttpInfo
     *
     * Update a batch of Blog Tags
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Tags. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateBatchAsyncWithHttpInfo($batch_input_json_node, $archived = null)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\BatchResponseTag';
        $request = $this->updateBatchRequest($batch_input_json_node, $archived);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateBatch'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\BatchInputJsonNode $batch_input_json_node A JSON array of the JSON representations of the updated Blog Tags. (required)
     * @param  bool $archived Specifies whether to update deleted Blog Tags. Defaults to &#x60;false&#x60;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateBatchRequest($batch_input_json_node, $archived = null)
    {
        // verify the required parameter 'batch_input_json_node' is set
        if ($batch_input_json_node === null || (is_array($batch_input_json_node) && count($batch_input_json_node) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_json_node when calling updateBatch'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/batch/update';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_json_node)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_json_node));
            } else {
                $httpBody = $batch_input_json_node;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateLangs
     *
     * Update languages of multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Blogs\Tags\Model\Error
     */
    public function updateLangs($update_languages_request_v_next)
    {
        list($response) = $this->updateLangsWithHttpInfo($update_languages_request_v_next);
        return $response;
    }

    /**
     * Operation updateLangsWithHttpInfo
     *
     * Update languages of multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     *
     * @throws \HubSpot\Client\Cms\Blogs\Tags\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Blogs\Tags\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLangsWithHttpInfo($update_languages_request_v_next)
    {
        $request = $this->updateLangsRequest($update_languages_request_v_next);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                default:
                    if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Blogs\Tags\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Blogs\Tags\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Error';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Blogs\Tags\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateLangsAsync
     *
     * Update languages of multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLangsAsync($update_languages_request_v_next)
    {
        return $this->updateLangsAsyncWithHttpInfo($update_languages_request_v_next)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateLangsAsyncWithHttpInfo
     *
     * Update languages of multi-language group
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLangsAsyncWithHttpInfo($update_languages_request_v_next)
    {
        $returnType = '\HubSpot\Client\Cms\Blogs\Tags\Model\Error';
        $request = $this->updateLangsRequest($update_languages_request_v_next);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateLangs'
     *
     * @param  \HubSpot\Client\Cms\Blogs\Tags\Model\UpdateLanguagesRequestVNext $update_languages_request_v_next The JSON representation of the UpdateLanguagesRequest object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateLangsRequest($update_languages_request_v_next)
    {
        // verify the required parameter 'update_languages_request_v_next' is set
        if ($update_languages_request_v_next === null || (is_array($update_languages_request_v_next) && count($update_languages_request_v_next) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_languages_request_v_next when calling updateLangs'
            );
        }

        $resourcePath = '/cms/v3/blogs/tags/multi-language/update-languages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($update_languages_request_v_next)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($update_languages_request_v_next));
            } else {
                $httpBody = $update_languages_request_v_next;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
