<?php
/**
 * UrlMapping
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\UrlRedirects
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * URL redirects
 *
 * URL redirect operations
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\UrlRedirects\Model;

use \ArrayAccess;
use \HubSpot\Client\Cms\UrlRedirects\ObjectSerializer;

/**
 * UrlMapping Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Cms\UrlRedirects
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UrlMapping implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UrlMapping';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'route_prefix' => 'string',
        'destination' => 'string',
        'redirect_style' => 'int',
        'is_only_after_not_found' => 'bool',
        'is_match_full_url' => 'bool',
        'is_match_query_string' => 'bool',
        'is_pattern' => 'bool',
        'is_trailing_slash_optional' => 'bool',
        'is_protocol_agnostic' => 'bool',
        'precedence' => 'int',
        'created' => '\DateTime',
        'updated' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'route_prefix' => null,
        'destination' => null,
        'redirect_style' => 'int32',
        'is_only_after_not_found' => null,
        'is_match_full_url' => null,
        'is_match_query_string' => null,
        'is_pattern' => null,
        'is_trailing_slash_optional' => null,
        'is_protocol_agnostic' => null,
        'precedence' => 'int32',
        'created' => 'date-time',
        'updated' => 'date-time'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'route_prefix' => 'routePrefix',
        'destination' => 'destination',
        'redirect_style' => 'redirectStyle',
        'is_only_after_not_found' => 'isOnlyAfterNotFound',
        'is_match_full_url' => 'isMatchFullUrl',
        'is_match_query_string' => 'isMatchQueryString',
        'is_pattern' => 'isPattern',
        'is_trailing_slash_optional' => 'isTrailingSlashOptional',
        'is_protocol_agnostic' => 'isProtocolAgnostic',
        'precedence' => 'precedence',
        'created' => 'created',
        'updated' => 'updated'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'route_prefix' => 'setRoutePrefix',
        'destination' => 'setDestination',
        'redirect_style' => 'setRedirectStyle',
        'is_only_after_not_found' => 'setIsOnlyAfterNotFound',
        'is_match_full_url' => 'setIsMatchFullUrl',
        'is_match_query_string' => 'setIsMatchQueryString',
        'is_pattern' => 'setIsPattern',
        'is_trailing_slash_optional' => 'setIsTrailingSlashOptional',
        'is_protocol_agnostic' => 'setIsProtocolAgnostic',
        'precedence' => 'setPrecedence',
        'created' => 'setCreated',
        'updated' => 'setUpdated'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'route_prefix' => 'getRoutePrefix',
        'destination' => 'getDestination',
        'redirect_style' => 'getRedirectStyle',
        'is_only_after_not_found' => 'getIsOnlyAfterNotFound',
        'is_match_full_url' => 'getIsMatchFullUrl',
        'is_match_query_string' => 'getIsMatchQueryString',
        'is_pattern' => 'getIsPattern',
        'is_trailing_slash_optional' => 'getIsTrailingSlashOptional',
        'is_protocol_agnostic' => 'getIsProtocolAgnostic',
        'precedence' => 'getPrecedence',
        'created' => 'getCreated',
        'updated' => 'getUpdated'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['route_prefix'] = $data['route_prefix'] ?? null;
        $this->container['destination'] = $data['destination'] ?? null;
        $this->container['redirect_style'] = $data['redirect_style'] ?? null;
        $this->container['is_only_after_not_found'] = $data['is_only_after_not_found'] ?? null;
        $this->container['is_match_full_url'] = $data['is_match_full_url'] ?? null;
        $this->container['is_match_query_string'] = $data['is_match_query_string'] ?? null;
        $this->container['is_pattern'] = $data['is_pattern'] ?? null;
        $this->container['is_trailing_slash_optional'] = $data['is_trailing_slash_optional'] ?? null;
        $this->container['is_protocol_agnostic'] = $data['is_protocol_agnostic'] ?? null;
        $this->container['precedence'] = $data['precedence'] ?? null;
        $this->container['created'] = $data['created'] ?? null;
        $this->container['updated'] = $data['updated'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['route_prefix'] === null) {
            $invalidProperties[] = "'route_prefix' can't be null";
        }
        if ($this->container['destination'] === null) {
            $invalidProperties[] = "'destination' can't be null";
        }
        if ($this->container['redirect_style'] === null) {
            $invalidProperties[] = "'redirect_style' can't be null";
        }
        if ($this->container['is_only_after_not_found'] === null) {
            $invalidProperties[] = "'is_only_after_not_found' can't be null";
        }
        if ($this->container['is_match_full_url'] === null) {
            $invalidProperties[] = "'is_match_full_url' can't be null";
        }
        if ($this->container['is_match_query_string'] === null) {
            $invalidProperties[] = "'is_match_query_string' can't be null";
        }
        if ($this->container['is_pattern'] === null) {
            $invalidProperties[] = "'is_pattern' can't be null";
        }
        if ($this->container['is_trailing_slash_optional'] === null) {
            $invalidProperties[] = "'is_trailing_slash_optional' can't be null";
        }
        if ($this->container['is_protocol_agnostic'] === null) {
            $invalidProperties[] = "'is_protocol_agnostic' can't be null";
        }
        if ($this->container['precedence'] === null) {
            $invalidProperties[] = "'precedence' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id The unique ID of this URL redirect.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets route_prefix
     *
     * @return string
     */
    public function getRoutePrefix()
    {
        return $this->container['route_prefix'];
    }

    /**
     * Sets route_prefix
     *
     * @param string $route_prefix The target incoming URL, path, or pattern to match for redirection.
     *
     * @return self
     */
    public function setRoutePrefix($route_prefix)
    {
        $this->container['route_prefix'] = $route_prefix;

        return $this;
    }

    /**
     * Gets destination
     *
     * @return string
     */
    public function getDestination()
    {
        return $this->container['destination'];
    }

    /**
     * Sets destination
     *
     * @param string $destination The destination URL, where the target URL should be redirected if it matches the `routePrefix`.
     *
     * @return self
     */
    public function setDestination($destination)
    {
        $this->container['destination'] = $destination;

        return $this;
    }

    /**
     * Gets redirect_style
     *
     * @return int
     */
    public function getRedirectStyle()
    {
        return $this->container['redirect_style'];
    }

    /**
     * Sets redirect_style
     *
     * @param int $redirect_style The type of redirect to create. Options include: 301 (permanent), 302 (temporary), or 305 (proxy). Find more details [here](https://knowledge.hubspot.com/cos-general/how-to-redirect-a-hubspot-page).
     *
     * @return self
     */
    public function setRedirectStyle($redirect_style)
    {
        $this->container['redirect_style'] = $redirect_style;

        return $this;
    }

    /**
     * Gets is_only_after_not_found
     *
     * @return bool
     */
    public function getIsOnlyAfterNotFound()
    {
        return $this->container['is_only_after_not_found'];
    }

    /**
     * Sets is_only_after_not_found
     *
     * @param bool $is_only_after_not_found Whether the URL redirect mapping should apply only if a live page on the URL isn't found. If False, the URL redirect mapping will take precedence over any existing page.
     *
     * @return self
     */
    public function setIsOnlyAfterNotFound($is_only_after_not_found)
    {
        $this->container['is_only_after_not_found'] = $is_only_after_not_found;

        return $this;
    }

    /**
     * Gets is_match_full_url
     *
     * @return bool
     */
    public function getIsMatchFullUrl()
    {
        return $this->container['is_match_full_url'];
    }

    /**
     * Sets is_match_full_url
     *
     * @param bool $is_match_full_url Whether the `routePrefix` should match on the entire URL, including the domain.
     *
     * @return self
     */
    public function setIsMatchFullUrl($is_match_full_url)
    {
        $this->container['is_match_full_url'] = $is_match_full_url;

        return $this;
    }

    /**
     * Gets is_match_query_string
     *
     * @return bool
     */
    public function getIsMatchQueryString()
    {
        return $this->container['is_match_query_string'];
    }

    /**
     * Sets is_match_query_string
     *
     * @param bool $is_match_query_string Whether the `routePrefix` should match on the entire URL path, including the query string.
     *
     * @return self
     */
    public function setIsMatchQueryString($is_match_query_string)
    {
        $this->container['is_match_query_string'] = $is_match_query_string;

        return $this;
    }

    /**
     * Gets is_pattern
     *
     * @return bool
     */
    public function getIsPattern()
    {
        return $this->container['is_pattern'];
    }

    /**
     * Sets is_pattern
     *
     * @param bool $is_pattern Whether the `routePrefix` should match based on pattern.
     *
     * @return self
     */
    public function setIsPattern($is_pattern)
    {
        $this->container['is_pattern'] = $is_pattern;

        return $this;
    }

    /**
     * Gets is_trailing_slash_optional
     *
     * @return bool
     */
    public function getIsTrailingSlashOptional()
    {
        return $this->container['is_trailing_slash_optional'];
    }

    /**
     * Sets is_trailing_slash_optional
     *
     * @param bool $is_trailing_slash_optional Whether a trailing slash will be ignored.
     *
     * @return self
     */
    public function setIsTrailingSlashOptional($is_trailing_slash_optional)
    {
        $this->container['is_trailing_slash_optional'] = $is_trailing_slash_optional;

        return $this;
    }

    /**
     * Gets is_protocol_agnostic
     *
     * @return bool
     */
    public function getIsProtocolAgnostic()
    {
        return $this->container['is_protocol_agnostic'];
    }

    /**
     * Sets is_protocol_agnostic
     *
     * @param bool $is_protocol_agnostic Whether the `routePrefix` should match both HTTP and HTTPS protocols.
     *
     * @return self
     */
    public function setIsProtocolAgnostic($is_protocol_agnostic)
    {
        $this->container['is_protocol_agnostic'] = $is_protocol_agnostic;

        return $this;
    }

    /**
     * Gets precedence
     *
     * @return int
     */
    public function getPrecedence()
    {
        return $this->container['precedence'];
    }

    /**
     * Sets precedence
     *
     * @param int $precedence Used to prioritize URL redirection. If a given URL matches more than one redirect, the one with the **lower** precedence will be used.
     *
     * @return self
     */
    public function setPrecedence($precedence)
    {
        $this->container['precedence'] = $precedence;

        return $this;
    }

    /**
     * Gets created
     *
     * @return \DateTime|null
     */
    public function getCreated()
    {
        return $this->container['created'];
    }

    /**
     * Sets created
     *
     * @param \DateTime|null $created created
     *
     * @return self
     */
    public function setCreated($created)
    {
        $this->container['created'] = $created;

        return $this;
    }

    /**
     * Gets updated
     *
     * @return \DateTime|null
     */
    public function getUpdated()
    {
        return $this->container['updated'];
    }

    /**
     * Sets updated
     *
     * @param \DateTime|null $updated updated
     *
     * @return self
     */
    public function setUpdated($updated)
    {
        $this->container['updated'] = $updated;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


