<?php
/**
 * BatchApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Associations
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Associations
 *
 * Associations define the relationships between objects in HubSpot. These endpoints allow you to create, read, and remove associations.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Associations\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Crm\Associations\ApiException;
use HubSpot\Client\Crm\Associations\Configuration;
use HubSpot\Client\Crm\Associations\HeaderSelector;
use HubSpot\Client\Crm\Associations\ObjectSerializer;

/**
 * BatchApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Associations
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BatchApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation archive
     *
     * Archive a batch of associations
     *
     * @param  string $from_object_type from_object_type (required)
     * @param  string $to_object_type to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association batch_input_public_association (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archive($from_object_type, $to_object_type, $batch_input_public_association)
    {
        $this->archiveWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association);
    }

    /**
     * Operation archiveWithHttpInfo
     *
     * Archive a batch of associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association)
    {
        $request = $this->archiveRequest($from_object_type, $to_object_type, $batch_input_public_association);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveAsync
     *
     * Archive a batch of associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsync($from_object_type, $to_object_type, $batch_input_public_association)
    {
        return $this->archiveAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveAsyncWithHttpInfo
     *
     * Archive a batch of associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association)
    {
        $returnType = '';
        $request = $this->archiveRequest($from_object_type, $to_object_type, $batch_input_public_association);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archive'
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveRequest($from_object_type, $to_object_type, $batch_input_public_association)
    {
        // verify the required parameter 'from_object_type' is set
        if ($from_object_type === null || (is_array($from_object_type) && count($from_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_object_type when calling archive'
            );
        }
        // verify the required parameter 'to_object_type' is set
        if ($to_object_type === null || (is_array($to_object_type) && count($to_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_object_type when calling archive'
            );
        }
        // verify the required parameter 'batch_input_public_association' is set
        if ($batch_input_public_association === null || (is_array($batch_input_public_association) && count($batch_input_public_association) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_public_association when calling archive'
            );
        }

        $resourcePath = '/crm/v3/associations/{fromObjectType}/{toObjectType}/batch/archive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($from_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'fromObjectType' . '}',
                ObjectSerializer::toPathValue($from_object_type),
                $resourcePath
            );
        }
        // path params
        if ($to_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'toObjectType' . '}',
                ObjectSerializer::toPathValue($to_object_type),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_public_association)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_public_association));
            } else {
                $httpBody = $batch_input_public_association;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation create
     *
     * Create a batch of associations
     *
     * @param  string $from_object_type from_object_type (required)
     * @param  string $to_object_type to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association batch_input_public_association (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociation|\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationWithErrors|\HubSpot\Client\Crm\Associations\Model\Error
     */
    public function create($from_object_type, $to_object_type, $batch_input_public_association)
    {
        list($response) = $this->createWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association);
        return $response;
    }

    /**
     * Operation createWithHttpInfo
     *
     * Create a batch of associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociation|\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationWithErrors|\HubSpot\Client\Crm\Associations\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association)
    {
        $request = $this->createRequest($from_object_type, $to_object_type, $batch_input_public_association);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociation' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociation' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociation', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationWithErrors' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Crm\Associations\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociation';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociation',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAsync
     *
     * Create a batch of associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsync($from_object_type, $to_object_type, $batch_input_public_association)
    {
        return $this->createAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAsyncWithHttpInfo
     *
     * Create a batch of associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association)
    {
        $returnType = '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociation';
        $request = $this->createRequest($from_object_type, $to_object_type, $batch_input_public_association);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'create'
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicAssociation $batch_input_public_association (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRequest($from_object_type, $to_object_type, $batch_input_public_association)
    {
        // verify the required parameter 'from_object_type' is set
        if ($from_object_type === null || (is_array($from_object_type) && count($from_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_object_type when calling create'
            );
        }
        // verify the required parameter 'to_object_type' is set
        if ($to_object_type === null || (is_array($to_object_type) && count($to_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_object_type when calling create'
            );
        }
        // verify the required parameter 'batch_input_public_association' is set
        if ($batch_input_public_association === null || (is_array($batch_input_public_association) && count($batch_input_public_association) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_public_association when calling create'
            );
        }

        $resourcePath = '/crm/v3/associations/{fromObjectType}/{toObjectType}/batch/create';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($from_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'fromObjectType' . '}',
                ObjectSerializer::toPathValue($from_object_type),
                $resourcePath
            );
        }
        // path params
        if ($to_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'toObjectType' . '}',
                ObjectSerializer::toPathValue($to_object_type),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_public_association)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_public_association));
            } else {
                $httpBody = $batch_input_public_association;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation read
     *
     * Read a batch of associations
     *
     * @param  string $from_object_type from_object_type (required)
     * @param  string $to_object_type to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicObjectId $batch_input_public_object_id batch_input_public_object_id (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMulti|\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMultiWithErrors|\HubSpot\Client\Crm\Associations\Model\Error
     */
    public function read($from_object_type, $to_object_type, $batch_input_public_object_id)
    {
        list($response) = $this->readWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_object_id);
        return $response;
    }

    /**
     * Operation readWithHttpInfo
     *
     * Read a batch of associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicObjectId $batch_input_public_object_id (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMulti|\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMultiWithErrors|\HubSpot\Client\Crm\Associations\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function readWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_object_id)
    {
        $request = $this->readRequest($from_object_type, $to_object_type, $batch_input_public_object_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMulti' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMulti' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMulti', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMultiWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMultiWithErrors' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMultiWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Crm\Associations\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMulti';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMulti',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMultiWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation readAsync
     *
     * Read a batch of associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicObjectId $batch_input_public_object_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readAsync($from_object_type, $to_object_type, $batch_input_public_object_id)
    {
        return $this->readAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_object_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation readAsyncWithHttpInfo
     *
     * Read a batch of associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicObjectId $batch_input_public_object_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_object_id)
    {
        $returnType = '\HubSpot\Client\Crm\Associations\Model\BatchResponsePublicAssociationMulti';
        $request = $this->readRequest($from_object_type, $to_object_type, $batch_input_public_object_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'read'
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\Model\BatchInputPublicObjectId $batch_input_public_object_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function readRequest($from_object_type, $to_object_type, $batch_input_public_object_id)
    {
        // verify the required parameter 'from_object_type' is set
        if ($from_object_type === null || (is_array($from_object_type) && count($from_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_object_type when calling read'
            );
        }
        // verify the required parameter 'to_object_type' is set
        if ($to_object_type === null || (is_array($to_object_type) && count($to_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_object_type when calling read'
            );
        }
        // verify the required parameter 'batch_input_public_object_id' is set
        if ($batch_input_public_object_id === null || (is_array($batch_input_public_object_id) && count($batch_input_public_object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_public_object_id when calling read'
            );
        }

        $resourcePath = '/crm/v3/associations/{fromObjectType}/{toObjectType}/batch/read';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($from_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'fromObjectType' . '}',
                ObjectSerializer::toPathValue($from_object_type),
                $resourcePath
            );
        }
        // path params
        if ($to_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'toObjectType' . '}',
                ObjectSerializer::toPathValue($to_object_type),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_public_object_id)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_public_object_id));
            } else {
                $httpBody = $batch_input_public_object_id;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
