<?php
/**
 * BatchApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Associations\V4
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CrmPublicObjectsService
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v4
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Associations\V4\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Crm\Associations\V4\ApiException;
use HubSpot\Client\Crm\Associations\V4\Configuration;
use HubSpot\Client\Crm\Associations\V4\HeaderSelector;
use HubSpot\Client\Crm\Associations\V4\ObjectSerializer;

/**
 * BatchApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Associations\V4
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BatchApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation archive
     *
     * Delete
     *
     * @param  string $from_object_type from_object_type (required)
     * @param  string $to_object_type to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiArchive $batch_input_public_association_multi_archive batch_input_public_association_multi_archive (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archive($from_object_type, $to_object_type, $batch_input_public_association_multi_archive)
    {
        $this->archiveWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_archive);
    }

    /**
     * Operation archiveWithHttpInfo
     *
     * Delete
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiArchive $batch_input_public_association_multi_archive (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_archive)
    {
        $request = $this->archiveRequest($from_object_type, $to_object_type, $batch_input_public_association_multi_archive);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveAsync
     *
     * Delete
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiArchive $batch_input_public_association_multi_archive (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsync($from_object_type, $to_object_type, $batch_input_public_association_multi_archive)
    {
        return $this->archiveAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_archive)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveAsyncWithHttpInfo
     *
     * Delete
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiArchive $batch_input_public_association_multi_archive (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_archive)
    {
        $returnType = '';
        $request = $this->archiveRequest($from_object_type, $to_object_type, $batch_input_public_association_multi_archive);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archive'
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiArchive $batch_input_public_association_multi_archive (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveRequest($from_object_type, $to_object_type, $batch_input_public_association_multi_archive)
    {
        // verify the required parameter 'from_object_type' is set
        if ($from_object_type === null || (is_array($from_object_type) && count($from_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_object_type when calling archive'
            );
        }
        // verify the required parameter 'to_object_type' is set
        if ($to_object_type === null || (is_array($to_object_type) && count($to_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_object_type when calling archive'
            );
        }
        // verify the required parameter 'batch_input_public_association_multi_archive' is set
        if ($batch_input_public_association_multi_archive === null || (is_array($batch_input_public_association_multi_archive) && count($batch_input_public_association_multi_archive) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_public_association_multi_archive when calling archive'
            );
        }

        $resourcePath = '/crm/v4/associations/{fromObjectType}/{toObjectType}/batch/archive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($from_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'fromObjectType' . '}',
                ObjectSerializer::toPathValue($from_object_type),
                $resourcePath
            );
        }
        // path params
        if ($to_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'toObjectType' . '}',
                ObjectSerializer::toPathValue($to_object_type),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_public_association_multi_archive)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_public_association_multi_archive));
            } else {
                $httpBody = $batch_input_public_association_multi_archive;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation archiveLabels
     *
     * Delete Specific Labels
     *
     * @param  string $from_object_type from_object_type (required)
     * @param  string $to_object_type to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post batch_input_public_association_multi_post (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archiveLabels($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        $this->archiveLabelsWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_post);
    }

    /**
     * Operation archiveLabelsWithHttpInfo
     *
     * Delete Specific Labels
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveLabelsWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        $request = $this->archiveLabelsRequest($from_object_type, $to_object_type, $batch_input_public_association_multi_post);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveLabelsAsync
     *
     * Delete Specific Labels
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveLabelsAsync($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        return $this->archiveLabelsAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveLabelsAsyncWithHttpInfo
     *
     * Delete Specific Labels
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveLabelsAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        $returnType = '';
        $request = $this->archiveLabelsRequest($from_object_type, $to_object_type, $batch_input_public_association_multi_post);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archiveLabels'
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveLabelsRequest($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        // verify the required parameter 'from_object_type' is set
        if ($from_object_type === null || (is_array($from_object_type) && count($from_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_object_type when calling archiveLabels'
            );
        }
        // verify the required parameter 'to_object_type' is set
        if ($to_object_type === null || (is_array($to_object_type) && count($to_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_object_type when calling archiveLabels'
            );
        }
        // verify the required parameter 'batch_input_public_association_multi_post' is set
        if ($batch_input_public_association_multi_post === null || (is_array($batch_input_public_association_multi_post) && count($batch_input_public_association_multi_post) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_public_association_multi_post when calling archiveLabels'
            );
        }

        $resourcePath = '/crm/v4/associations/{fromObjectType}/{toObjectType}/batch/labels/archive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($from_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'fromObjectType' . '}',
                ObjectSerializer::toPathValue($from_object_type),
                $resourcePath
            );
        }
        // path params
        if ($to_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'toObjectType' . '}',
                ObjectSerializer::toPathValue($to_object_type),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_public_association_multi_post)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_public_association_multi_post));
            } else {
                $httpBody = $batch_input_public_association_multi_post;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation create
     *
     * Create
     *
     * @param  string $from_object_type from_object_type (required)
     * @param  string $to_object_type to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post batch_input_public_association_multi_post (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPair|\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPairWithErrors|\HubSpot\Client\Crm\Associations\V4\Model\Error
     */
    public function create($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        list($response) = $this->createWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_post);
        return $response;
    }

    /**
     * Operation createWithHttpInfo
     *
     * Create
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPair|\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPairWithErrors|\HubSpot\Client\Crm\Associations\V4\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        $request = $this->createRequest($from_object_type, $to_object_type, $batch_input_public_association_multi_post);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPair' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPair' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPair', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPairWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPairWithErrors' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPairWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Crm\Associations\V4\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\V4\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\V4\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPair';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPair',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPairWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAsync
     *
     * Create
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsync($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        return $this->createAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAsyncWithHttpInfo
     *
     * Create
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        $returnType = '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponseLabelsBetweenObjectPair';
        $request = $this->createRequest($from_object_type, $to_object_type, $batch_input_public_association_multi_post);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'create'
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicAssociationMultiPost $batch_input_public_association_multi_post (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRequest($from_object_type, $to_object_type, $batch_input_public_association_multi_post)
    {
        // verify the required parameter 'from_object_type' is set
        if ($from_object_type === null || (is_array($from_object_type) && count($from_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_object_type when calling create'
            );
        }
        // verify the required parameter 'to_object_type' is set
        if ($to_object_type === null || (is_array($to_object_type) && count($to_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_object_type when calling create'
            );
        }
        // verify the required parameter 'batch_input_public_association_multi_post' is set
        if ($batch_input_public_association_multi_post === null || (is_array($batch_input_public_association_multi_post) && count($batch_input_public_association_multi_post) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_public_association_multi_post when calling create'
            );
        }

        $resourcePath = '/crm/v4/associations/{fromObjectType}/{toObjectType}/batch/create';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($from_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'fromObjectType' . '}',
                ObjectSerializer::toPathValue($from_object_type),
                $resourcePath
            );
        }
        // path params
        if ($to_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'toObjectType' . '}',
                ObjectSerializer::toPathValue($to_object_type),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_public_association_multi_post)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_public_association_multi_post));
            } else {
                $httpBody = $batch_input_public_association_multi_post;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createDefault
     *
     * Create Default Associations
     *
     * @param  string $from_object_type from_object_type (required)
     * @param  string $to_object_type to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicDefaultAssociationMultiPost $batch_input_public_default_association_multi_post batch_input_public_default_association_multi_post (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicDefaultAssociation|\HubSpot\Client\Crm\Associations\V4\Model\Error
     */
    public function createDefault($from_object_type, $to_object_type, $batch_input_public_default_association_multi_post)
    {
        list($response) = $this->createDefaultWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_default_association_multi_post);
        return $response;
    }

    /**
     * Operation createDefaultWithHttpInfo
     *
     * Create Default Associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicDefaultAssociationMultiPost $batch_input_public_default_association_multi_post (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicDefaultAssociation|\HubSpot\Client\Crm\Associations\V4\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDefaultWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_default_association_multi_post)
    {
        $request = $this->createDefaultRequest($from_object_type, $to_object_type, $batch_input_public_default_association_multi_post);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicDefaultAssociation' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicDefaultAssociation' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicDefaultAssociation', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Crm\Associations\V4\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\V4\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\V4\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicDefaultAssociation';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicDefaultAssociation',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createDefaultAsync
     *
     * Create Default Associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicDefaultAssociationMultiPost $batch_input_public_default_association_multi_post (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDefaultAsync($from_object_type, $to_object_type, $batch_input_public_default_association_multi_post)
    {
        return $this->createDefaultAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_default_association_multi_post)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createDefaultAsyncWithHttpInfo
     *
     * Create Default Associations
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicDefaultAssociationMultiPost $batch_input_public_default_association_multi_post (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDefaultAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_default_association_multi_post)
    {
        $returnType = '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicDefaultAssociation';
        $request = $this->createDefaultRequest($from_object_type, $to_object_type, $batch_input_public_default_association_multi_post);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createDefault'
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicDefaultAssociationMultiPost $batch_input_public_default_association_multi_post (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createDefaultRequest($from_object_type, $to_object_type, $batch_input_public_default_association_multi_post)
    {
        // verify the required parameter 'from_object_type' is set
        if ($from_object_type === null || (is_array($from_object_type) && count($from_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_object_type when calling createDefault'
            );
        }
        // verify the required parameter 'to_object_type' is set
        if ($to_object_type === null || (is_array($to_object_type) && count($to_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_object_type when calling createDefault'
            );
        }
        // verify the required parameter 'batch_input_public_default_association_multi_post' is set
        if ($batch_input_public_default_association_multi_post === null || (is_array($batch_input_public_default_association_multi_post) && count($batch_input_public_default_association_multi_post) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_public_default_association_multi_post when calling createDefault'
            );
        }

        $resourcePath = '/crm/v4/associations/{fromObjectType}/{toObjectType}/batch/associate/default';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($from_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'fromObjectType' . '}',
                ObjectSerializer::toPathValue($from_object_type),
                $resourcePath
            );
        }
        // path params
        if ($to_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'toObjectType' . '}',
                ObjectSerializer::toPathValue($to_object_type),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_public_default_association_multi_post)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_public_default_association_multi_post));
            } else {
                $httpBody = $batch_input_public_default_association_multi_post;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPage
     *
     * Read
     *
     * @param  string $from_object_type from_object_type (required)
     * @param  string $to_object_type to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicFetchAssociationsBatchRequest $batch_input_public_fetch_associations_batch_request batch_input_public_fetch_associations_batch_request (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabel|\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabelWithErrors|\HubSpot\Client\Crm\Associations\V4\Model\Error
     */
    public function getPage($from_object_type, $to_object_type, $batch_input_public_fetch_associations_batch_request)
    {
        list($response) = $this->getPageWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_fetch_associations_batch_request);
        return $response;
    }

    /**
     * Operation getPageWithHttpInfo
     *
     * Read
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicFetchAssociationsBatchRequest $batch_input_public_fetch_associations_batch_request (required)
     *
     * @throws \HubSpot\Client\Crm\Associations\V4\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabel|\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabelWithErrors|\HubSpot\Client\Crm\Associations\V4\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPageWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_fetch_associations_batch_request)
    {
        $request = $this->getPageRequest($from_object_type, $to_object_type, $batch_input_public_fetch_associations_batch_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabel' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 207:
                    if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabelWithErrors' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabelWithErrors' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabelWithErrors', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Crm\Associations\V4\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Crm\Associations\V4\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Crm\Associations\V4\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 207:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabelWithErrors',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Associations\V4\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPageAsync
     *
     * Read
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicFetchAssociationsBatchRequest $batch_input_public_fetch_associations_batch_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPageAsync($from_object_type, $to_object_type, $batch_input_public_fetch_associations_batch_request)
    {
        return $this->getPageAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_fetch_associations_batch_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPageAsyncWithHttpInfo
     *
     * Read
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicFetchAssociationsBatchRequest $batch_input_public_fetch_associations_batch_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPageAsyncWithHttpInfo($from_object_type, $to_object_type, $batch_input_public_fetch_associations_batch_request)
    {
        $returnType = '\HubSpot\Client\Crm\Associations\V4\Model\BatchResponsePublicAssociationMultiWithLabel';
        $request = $this->getPageRequest($from_object_type, $to_object_type, $batch_input_public_fetch_associations_batch_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPage'
     *
     * @param  string $from_object_type (required)
     * @param  string $to_object_type (required)
     * @param  \HubSpot\Client\Crm\Associations\V4\Model\BatchInputPublicFetchAssociationsBatchRequest $batch_input_public_fetch_associations_batch_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPageRequest($from_object_type, $to_object_type, $batch_input_public_fetch_associations_batch_request)
    {
        // verify the required parameter 'from_object_type' is set
        if ($from_object_type === null || (is_array($from_object_type) && count($from_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_object_type when calling getPage'
            );
        }
        // verify the required parameter 'to_object_type' is set
        if ($to_object_type === null || (is_array($to_object_type) && count($to_object_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_object_type when calling getPage'
            );
        }
        // verify the required parameter 'batch_input_public_fetch_associations_batch_request' is set
        if ($batch_input_public_fetch_associations_batch_request === null || (is_array($batch_input_public_fetch_associations_batch_request) && count($batch_input_public_fetch_associations_batch_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_public_fetch_associations_batch_request when calling getPage'
            );
        }

        $resourcePath = '/crm/v4/associations/{fromObjectType}/{toObjectType}/batch/read';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($from_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'fromObjectType' . '}',
                ObjectSerializer::toPathValue($from_object_type),
                $resourcePath
            );
        }
        // path params
        if ($to_object_type !== null) {
            $resourcePath = str_replace(
                '{' . 'toObjectType' . '}',
                ObjectSerializer::toPathValue($to_object_type),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_public_fetch_associations_batch_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_public_fetch_associations_batch_request));
            } else {
                $httpBody = $batch_input_public_fetch_associations_batch_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
