<?php
/**
 * CallbacksApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Extensions\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Accounting Extension
 *
 * These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Extensions\Accounting\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Crm\Extensions\Accounting\ApiException;
use HubSpot\Client\Crm\Extensions\Accounting\Configuration;
use HubSpot\Client\Crm\Extensions\Accounting\HeaderSelector;
use HubSpot\Client\Crm\Extensions\Accounting\ObjectSerializer;

/**
 * CallbacksApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Extensions\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CallbacksApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createCustomer
     *
     * Endpoint for customer creation response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created customer. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createCustomer($request_id, $result_id_accounting_response)
    {
        $this->createCustomerWithHttpInfo($request_id, $result_id_accounting_response);
    }

    /**
     * Operation createCustomerWithHttpInfo
     *
     * Endpoint for customer creation response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created customer. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomerWithHttpInfo($request_id, $result_id_accounting_response)
    {
        $request = $this->createCustomerRequest($request_id, $result_id_accounting_response);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCustomerAsync
     *
     * Endpoint for customer creation response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created customer. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerAsync($request_id, $result_id_accounting_response)
    {
        return $this->createCustomerAsyncWithHttpInfo($request_id, $result_id_accounting_response)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCustomerAsyncWithHttpInfo
     *
     * Endpoint for customer creation response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created customer. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerAsyncWithHttpInfo($request_id, $result_id_accounting_response)
    {
        $returnType = '';
        $request = $this->createCustomerRequest($request_id, $result_id_accounting_response);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCustomer'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created customer. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCustomerRequest($request_id, $result_id_accounting_response)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling createCustomer'
            );
        }
        // verify the required parameter 'result_id_accounting_response' is set
        if ($result_id_accounting_response === null || (is_array($result_id_accounting_response) && count($result_id_accounting_response) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $result_id_accounting_response when calling createCustomer'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/customer-create/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($result_id_accounting_response)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($result_id_accounting_response));
            } else {
                $httpBody = $result_id_accounting_response;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createExchangeRate
     *
     * Endpoint for exchange rate response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ExchangeRateResponse $exchange_rate_response The result of the exchange rate request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createExchangeRate($request_id, $exchange_rate_response)
    {
        $this->createExchangeRateWithHttpInfo($request_id, $exchange_rate_response);
    }

    /**
     * Operation createExchangeRateWithHttpInfo
     *
     * Endpoint for exchange rate response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ExchangeRateResponse $exchange_rate_response The result of the exchange rate request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createExchangeRateWithHttpInfo($request_id, $exchange_rate_response)
    {
        $request = $this->createExchangeRateRequest($request_id, $exchange_rate_response);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createExchangeRateAsync
     *
     * Endpoint for exchange rate response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ExchangeRateResponse $exchange_rate_response The result of the exchange rate request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExchangeRateAsync($request_id, $exchange_rate_response)
    {
        return $this->createExchangeRateAsyncWithHttpInfo($request_id, $exchange_rate_response)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createExchangeRateAsyncWithHttpInfo
     *
     * Endpoint for exchange rate response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ExchangeRateResponse $exchange_rate_response The result of the exchange rate request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExchangeRateAsyncWithHttpInfo($request_id, $exchange_rate_response)
    {
        $returnType = '';
        $request = $this->createExchangeRateRequest($request_id, $exchange_rate_response);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createExchangeRate'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ExchangeRateResponse $exchange_rate_response The result of the exchange rate request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createExchangeRateRequest($request_id, $exchange_rate_response)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling createExchangeRate'
            );
        }
        // verify the required parameter 'exchange_rate_response' is set
        if ($exchange_rate_response === null || (is_array($exchange_rate_response) && count($exchange_rate_response) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $exchange_rate_response when calling createExchangeRate'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/exchange-rate/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($exchange_rate_response)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($exchange_rate_response));
            } else {
                $httpBody = $exchange_rate_response;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInvoice
     *
     * Endpoint for invoice creation response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created invoice. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createInvoice($request_id, $result_id_accounting_response)
    {
        $this->createInvoiceWithHttpInfo($request_id, $result_id_accounting_response);
    }

    /**
     * Operation createInvoiceWithHttpInfo
     *
     * Endpoint for invoice creation response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created invoice. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoiceWithHttpInfo($request_id, $result_id_accounting_response)
    {
        $request = $this->createInvoiceRequest($request_id, $result_id_accounting_response);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoiceAsync
     *
     * Endpoint for invoice creation response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created invoice. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAsync($request_id, $result_id_accounting_response)
    {
        return $this->createInvoiceAsyncWithHttpInfo($request_id, $result_id_accounting_response)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoiceAsyncWithHttpInfo
     *
     * Endpoint for invoice creation response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created invoice. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAsyncWithHttpInfo($request_id, $result_id_accounting_response)
    {
        $returnType = '';
        $request = $this->createInvoiceRequest($request_id, $result_id_accounting_response);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoice'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ResultIdAccountingResponse $result_id_accounting_response The ID of the created invoice. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInvoiceRequest($request_id, $result_id_accounting_response)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling createInvoice'
            );
        }
        // verify the required parameter 'result_id_accounting_response' is set
        if ($result_id_accounting_response === null || (is_array($result_id_accounting_response) && count($result_id_accounting_response) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $result_id_accounting_response when calling createInvoice'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/invoice-create/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($result_id_accounting_response)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($result_id_accounting_response));
            } else {
                $httpBody = $result_id_accounting_response;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTerm
     *
     * Endpoint for terms search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TermsResponse $terms_response The result of the terms search (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createTerm($request_id, $terms_response)
    {
        $this->createTermWithHttpInfo($request_id, $terms_response);
    }

    /**
     * Operation createTermWithHttpInfo
     *
     * Endpoint for terms search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TermsResponse $terms_response The result of the terms search (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTermWithHttpInfo($request_id, $terms_response)
    {
        $request = $this->createTermRequest($request_id, $terms_response);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTermAsync
     *
     * Endpoint for terms search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TermsResponse $terms_response The result of the terms search (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTermAsync($request_id, $terms_response)
    {
        return $this->createTermAsyncWithHttpInfo($request_id, $terms_response)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTermAsyncWithHttpInfo
     *
     * Endpoint for terms search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TermsResponse $terms_response The result of the terms search (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTermAsyncWithHttpInfo($request_id, $terms_response)
    {
        $returnType = '';
        $request = $this->createTermRequest($request_id, $terms_response);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTerm'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TermsResponse $terms_response The result of the terms search (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createTermRequest($request_id, $terms_response)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling createTerm'
            );
        }
        // verify the required parameter 'terms_response' is set
        if ($terms_response === null || (is_array($terms_response) && count($terms_response) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $terms_response when calling createTerm'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/terms/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($terms_response)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($terms_response));
            } else {
                $httpBody = $terms_response;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation doCustomerSearch
     *
     * Endpoint for customer search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\CustomerSearchResponseExternal $customer_search_response_external The result of the customer search request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function doCustomerSearch($request_id, $customer_search_response_external)
    {
        $this->doCustomerSearchWithHttpInfo($request_id, $customer_search_response_external);
    }

    /**
     * Operation doCustomerSearchWithHttpInfo
     *
     * Endpoint for customer search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\CustomerSearchResponseExternal $customer_search_response_external The result of the customer search request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function doCustomerSearchWithHttpInfo($request_id, $customer_search_response_external)
    {
        $request = $this->doCustomerSearchRequest($request_id, $customer_search_response_external);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation doCustomerSearchAsync
     *
     * Endpoint for customer search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\CustomerSearchResponseExternal $customer_search_response_external The result of the customer search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doCustomerSearchAsync($request_id, $customer_search_response_external)
    {
        return $this->doCustomerSearchAsyncWithHttpInfo($request_id, $customer_search_response_external)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation doCustomerSearchAsyncWithHttpInfo
     *
     * Endpoint for customer search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\CustomerSearchResponseExternal $customer_search_response_external The result of the customer search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doCustomerSearchAsyncWithHttpInfo($request_id, $customer_search_response_external)
    {
        $returnType = '';
        $request = $this->doCustomerSearchRequest($request_id, $customer_search_response_external);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'doCustomerSearch'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\CustomerSearchResponseExternal $customer_search_response_external The result of the customer search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function doCustomerSearchRequest($request_id, $customer_search_response_external)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling doCustomerSearch'
            );
        }
        // verify the required parameter 'customer_search_response_external' is set
        if ($customer_search_response_external === null || (is_array($customer_search_response_external) && count($customer_search_response_external) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_search_response_external when calling doCustomerSearch'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/customer-search/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($customer_search_response_external)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($customer_search_response_external));
            } else {
                $httpBody = $customer_search_response_external;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation doInvoiceSearch
     *
     * Endpoint for invoice search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoiceSearchResponse $invoice_search_response The result of the invoice search request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function doInvoiceSearch($request_id, $invoice_search_response)
    {
        $this->doInvoiceSearchWithHttpInfo($request_id, $invoice_search_response);
    }

    /**
     * Operation doInvoiceSearchWithHttpInfo
     *
     * Endpoint for invoice search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoiceSearchResponse $invoice_search_response The result of the invoice search request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function doInvoiceSearchWithHttpInfo($request_id, $invoice_search_response)
    {
        $request = $this->doInvoiceSearchRequest($request_id, $invoice_search_response);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation doInvoiceSearchAsync
     *
     * Endpoint for invoice search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoiceSearchResponse $invoice_search_response The result of the invoice search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doInvoiceSearchAsync($request_id, $invoice_search_response)
    {
        return $this->doInvoiceSearchAsyncWithHttpInfo($request_id, $invoice_search_response)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation doInvoiceSearchAsyncWithHttpInfo
     *
     * Endpoint for invoice search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoiceSearchResponse $invoice_search_response The result of the invoice search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doInvoiceSearchAsyncWithHttpInfo($request_id, $invoice_search_response)
    {
        $returnType = '';
        $request = $this->doInvoiceSearchRequest($request_id, $invoice_search_response);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'doInvoiceSearch'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoiceSearchResponse $invoice_search_response The result of the invoice search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function doInvoiceSearchRequest($request_id, $invoice_search_response)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling doInvoiceSearch'
            );
        }
        // verify the required parameter 'invoice_search_response' is set
        if ($invoice_search_response === null || (is_array($invoice_search_response) && count($invoice_search_response) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoice_search_response when calling doInvoiceSearch'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/invoice-search/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($invoice_search_response)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($invoice_search_response));
            } else {
                $httpBody = $invoice_search_response;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation doProductSearch
     *
     * Endpoint for product search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ProductSearchResponse $product_search_response The result of the product search request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function doProductSearch($request_id, $product_search_response)
    {
        $this->doProductSearchWithHttpInfo($request_id, $product_search_response);
    }

    /**
     * Operation doProductSearchWithHttpInfo
     *
     * Endpoint for product search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ProductSearchResponse $product_search_response The result of the product search request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function doProductSearchWithHttpInfo($request_id, $product_search_response)
    {
        $request = $this->doProductSearchRequest($request_id, $product_search_response);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation doProductSearchAsync
     *
     * Endpoint for product search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ProductSearchResponse $product_search_response The result of the product search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doProductSearchAsync($request_id, $product_search_response)
    {
        return $this->doProductSearchAsyncWithHttpInfo($request_id, $product_search_response)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation doProductSearchAsyncWithHttpInfo
     *
     * Endpoint for product search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ProductSearchResponse $product_search_response The result of the product search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doProductSearchAsyncWithHttpInfo($request_id, $product_search_response)
    {
        $returnType = '';
        $request = $this->doProductSearchRequest($request_id, $product_search_response);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'doProductSearch'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\ProductSearchResponse $product_search_response The result of the product search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function doProductSearchRequest($request_id, $product_search_response)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling doProductSearch'
            );
        }
        // verify the required parameter 'product_search_response' is set
        if ($product_search_response === null || (is_array($product_search_response) && count($product_search_response) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_search_response when calling doProductSearch'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/product-search/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($product_search_response)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($product_search_response));
            } else {
                $httpBody = $product_search_response;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation doTaxSearch
     *
     * Endpoint for taxes search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TaxSearchResponse $tax_search_response The result of the taxes search request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function doTaxSearch($request_id, $tax_search_response)
    {
        $this->doTaxSearchWithHttpInfo($request_id, $tax_search_response);
    }

    /**
     * Operation doTaxSearchWithHttpInfo
     *
     * Endpoint for taxes search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TaxSearchResponse $tax_search_response The result of the taxes search request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function doTaxSearchWithHttpInfo($request_id, $tax_search_response)
    {
        $request = $this->doTaxSearchRequest($request_id, $tax_search_response);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation doTaxSearchAsync
     *
     * Endpoint for taxes search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TaxSearchResponse $tax_search_response The result of the taxes search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doTaxSearchAsync($request_id, $tax_search_response)
    {
        return $this->doTaxSearchAsyncWithHttpInfo($request_id, $tax_search_response)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation doTaxSearchAsyncWithHttpInfo
     *
     * Endpoint for taxes search response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TaxSearchResponse $tax_search_response The result of the taxes search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doTaxSearchAsyncWithHttpInfo($request_id, $tax_search_response)
    {
        $returnType = '';
        $request = $this->doTaxSearchRequest($request_id, $tax_search_response);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'doTaxSearch'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\TaxSearchResponse $tax_search_response The result of the taxes search request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function doTaxSearchRequest($request_id, $tax_search_response)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling doTaxSearch'
            );
        }
        // verify the required parameter 'tax_search_response' is set
        if ($tax_search_response === null || (is_array($tax_search_response) && count($tax_search_response) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tax_search_response when calling doTaxSearch'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/tax-search/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($tax_search_response)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($tax_search_response));
            } else {
                $httpBody = $tax_search_response;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getById
     *
     * Endpoint for invoice get-by-id response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicesResponseExternal $invoices_response_external The result of the invoice request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function getById($request_id, $invoices_response_external)
    {
        $this->getByIdWithHttpInfo($request_id, $invoices_response_external);
    }

    /**
     * Operation getByIdWithHttpInfo
     *
     * Endpoint for invoice get-by-id response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicesResponseExternal $invoices_response_external The result of the invoice request. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getByIdWithHttpInfo($request_id, $invoices_response_external)
    {
        $request = $this->getByIdRequest($request_id, $invoices_response_external);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getByIdAsync
     *
     * Endpoint for invoice get-by-id response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicesResponseExternal $invoices_response_external The result of the invoice request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsync($request_id, $invoices_response_external)
    {
        return $this->getByIdAsyncWithHttpInfo($request_id, $invoices_response_external)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getByIdAsyncWithHttpInfo
     *
     * Endpoint for invoice get-by-id response
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicesResponseExternal $invoices_response_external The result of the invoice request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsyncWithHttpInfo($request_id, $invoices_response_external)
    {
        $returnType = '';
        $request = $this->getByIdRequest($request_id, $invoices_response_external);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getById'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicesResponseExternal $invoices_response_external The result of the invoice request. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getByIdRequest($request_id, $invoices_response_external)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling getById'
            );
        }
        // verify the required parameter 'invoices_response_external' is set
        if ($invoices_response_external === null || (is_array($invoices_response_external) && count($invoices_response_external) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoices_response_external when calling getById'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/invoices/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($invoices_response_external)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($invoices_response_external));
            } else {
                $httpBody = $invoices_response_external;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation invoicePdf
     *
     * Endpoint for PDF content of invoice
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicePdfResponse $invoice_pdf_response The bytes of the invoice PDF. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function invoicePdf($request_id, $invoice_pdf_response)
    {
        $this->invoicePdfWithHttpInfo($request_id, $invoice_pdf_response);
    }

    /**
     * Operation invoicePdfWithHttpInfo
     *
     * Endpoint for PDF content of invoice
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicePdfResponse $invoice_pdf_response The bytes of the invoice PDF. (required)
     *
     * @throws \HubSpot\Client\Crm\Extensions\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function invoicePdfWithHttpInfo($request_id, $invoice_pdf_response)
    {
        $request = $this->invoicePdfRequest($request_id, $invoice_pdf_response);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Crm\Extensions\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation invoicePdfAsync
     *
     * Endpoint for PDF content of invoice
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicePdfResponse $invoice_pdf_response The bytes of the invoice PDF. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function invoicePdfAsync($request_id, $invoice_pdf_response)
    {
        return $this->invoicePdfAsyncWithHttpInfo($request_id, $invoice_pdf_response)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation invoicePdfAsyncWithHttpInfo
     *
     * Endpoint for PDF content of invoice
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicePdfResponse $invoice_pdf_response The bytes of the invoice PDF. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function invoicePdfAsyncWithHttpInfo($request_id, $invoice_pdf_response)
    {
        $returnType = '';
        $request = $this->invoicePdfRequest($request_id, $invoice_pdf_response);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'invoicePdf'
     *
     * @param  string $request_id The ID of the request that this response is for (required)
     * @param  \HubSpot\Client\Crm\Extensions\Accounting\Model\InvoicePdfResponse $invoice_pdf_response The bytes of the invoice PDF. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function invoicePdfRequest($request_id, $invoice_pdf_response)
    {
        // verify the required parameter 'request_id' is set
        if ($request_id === null || (is_array($request_id) && count($request_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_id when calling invoicePdf'
            );
        }
        // verify the required parameter 'invoice_pdf_response' is set
        if ($invoice_pdf_response === null || (is_array($invoice_pdf_response) && count($invoice_pdf_response) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoice_pdf_response when calling invoicePdf'
            );
        }

        $resourcePath = '/crm/v3/extensions/accounting/callback/invoice-pdf/{requestId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($request_id !== null) {
            $resourcePath = str_replace(
                '{' . 'requestId' . '}',
                ObjectSerializer::toPathValue($request_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($invoice_pdf_response)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($invoice_pdf_response));
            } else {
                $httpBody = $invoice_pdf_response;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
