<?php
/**
 * IntegratorCardPayloadResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Extensions\Cards
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CRM cards
 *
 * Allows an app to extend the CRM UI by surfacing custom cards in the sidebar of record pages. These cards are defined up-front as part of app configuration, then populated by external data fetch requests when the record page is accessed by a user.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Extensions\Cards\Model;

use \ArrayAccess;
use \HubSpot\Client\Crm\Extensions\Cards\ObjectSerializer;

/**
 * IntegratorCardPayloadResponse Class Doc Comment
 *
 * @category Class
 * @description The card details payload, sent to HubSpot by an app in response to a data fetch request when a user visits a CRM record page.
 * @package  HubSpot\Client\Crm\Extensions\Cards
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class IntegratorCardPayloadResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'IntegratorCardPayloadResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'total_count' => 'int',
        'all_items_link_url' => 'string',
        'card_label' => 'string',
        'top_level_actions' => '\HubSpot\Client\Crm\Extensions\Cards\Model\TopLevelActions',
        'sections' => '\HubSpot\Client\Crm\Extensions\Cards\Model\IntegratorObjectResult[]',
        'response_version' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'total_count' => 'int32',
        'all_items_link_url' => null,
        'card_label' => null,
        'top_level_actions' => null,
        'sections' => null,
        'response_version' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'total_count' => 'totalCount',
        'all_items_link_url' => 'allItemsLinkUrl',
        'card_label' => 'cardLabel',
        'top_level_actions' => 'topLevelActions',
        'sections' => 'sections',
        'response_version' => 'responseVersion'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'total_count' => 'setTotalCount',
        'all_items_link_url' => 'setAllItemsLinkUrl',
        'card_label' => 'setCardLabel',
        'top_level_actions' => 'setTopLevelActions',
        'sections' => 'setSections',
        'response_version' => 'setResponseVersion'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'total_count' => 'getTotalCount',
        'all_items_link_url' => 'getAllItemsLinkUrl',
        'card_label' => 'getCardLabel',
        'top_level_actions' => 'getTopLevelActions',
        'sections' => 'getSections',
        'response_version' => 'getResponseVersion'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const RESPONSE_VERSION_V1 = 'v1';
    public const RESPONSE_VERSION_V3 = 'v3';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getResponseVersionAllowableValues()
    {
        return [
            self::RESPONSE_VERSION_V1,
            self::RESPONSE_VERSION_V3,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['total_count'] = $data['total_count'] ?? null;
        $this->container['all_items_link_url'] = $data['all_items_link_url'] ?? null;
        $this->container['card_label'] = $data['card_label'] ?? null;
        $this->container['top_level_actions'] = $data['top_level_actions'] ?? null;
        $this->container['sections'] = $data['sections'] ?? null;
        $this->container['response_version'] = $data['response_version'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['total_count'] === null) {
            $invalidProperties[] = "'total_count' can't be null";
        }
        $allowedValues = $this->getResponseVersionAllowableValues();
        if (!is_null($this->container['response_version']) && !in_array($this->container['response_version'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'response_version', must be one of '%s'",
                $this->container['response_version'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets total_count
     *
     * @return int
     */
    public function getTotalCount()
    {
        return $this->container['total_count'];
    }

    /**
     * Sets total_count
     *
     * @param int $total_count The total number of card properties that will be sent in this response.
     *
     * @return self
     */
    public function setTotalCount($total_count)
    {
        $this->container['total_count'] = $total_count;

        return $this;
    }

    /**
     * Gets all_items_link_url
     *
     * @return string|null
     */
    public function getAllItemsLinkUrl()
    {
        return $this->container['all_items_link_url'];
    }

    /**
     * Sets all_items_link_url
     *
     * @param string|null $all_items_link_url URL to a page the integrator has built that displays all details for this card. This URL will be displayed to users under a `See more [x]` link if there are more than five items in your response, where `[x]` is the value of `itemLabel`.
     *
     * @return self
     */
    public function setAllItemsLinkUrl($all_items_link_url)
    {
        $this->container['all_items_link_url'] = $all_items_link_url;

        return $this;
    }

    /**
     * Gets card_label
     *
     * @return string|null
     */
    public function getCardLabel()
    {
        return $this->container['card_label'];
    }

    /**
     * Sets card_label
     *
     * @param string|null $card_label The label to be used for the `allItemsLinkUrl` link (e.g. 'See more tickets'). If not provided, this falls back to the card's title.
     *
     * @return self
     */
    public function setCardLabel($card_label)
    {
        $this->container['card_label'] = $card_label;

        return $this;
    }

    /**
     * Gets top_level_actions
     *
     * @return \HubSpot\Client\Crm\Extensions\Cards\Model\TopLevelActions|null
     */
    public function getTopLevelActions()
    {
        return $this->container['top_level_actions'];
    }

    /**
     * Sets top_level_actions
     *
     * @param \HubSpot\Client\Crm\Extensions\Cards\Model\TopLevelActions|null $top_level_actions top_level_actions
     *
     * @return self
     */
    public function setTopLevelActions($top_level_actions)
    {
        $this->container['top_level_actions'] = $top_level_actions;

        return $this;
    }

    /**
     * Gets sections
     *
     * @return \HubSpot\Client\Crm\Extensions\Cards\Model\IntegratorObjectResult[]|null
     */
    public function getSections()
    {
        return $this->container['sections'];
    }

    /**
     * Sets sections
     *
     * @param \HubSpot\Client\Crm\Extensions\Cards\Model\IntegratorObjectResult[]|null $sections A list of up to five valid card sub categories.
     *
     * @return self
     */
    public function setSections($sections)
    {
        $this->container['sections'] = $sections;

        return $this;
    }

    /**
     * Gets response_version
     *
     * @return string|null
     */
    public function getResponseVersion()
    {
        return $this->container['response_version'];
    }

    /**
     * Sets response_version
     *
     * @param string|null $response_version response_version
     *
     * @return self
     */
    public function setResponseVersion($response_version)
    {
        $allowedValues = $this->getResponseVersionAllowableValues();
        if (!is_null($response_version) && !in_array($response_version, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'response_version', must be one of '%s'",
                    $response_version,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['response_version'] = $response_version;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


