<?php
/**
 * AssociationSpec
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Quotes
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Quotes
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Quotes\Model;

use \ArrayAccess;
use \HubSpot\Client\Crm\Quotes\ObjectSerializer;

/**
 * AssociationSpec Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Quotes
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class AssociationSpec implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'AssociationSpec';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'association_category' => 'string',
        'association_type_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'association_category' => null,
        'association_type_id' => 'int32'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'association_category' => 'associationCategory',
        'association_type_id' => 'associationTypeId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'association_category' => 'setAssociationCategory',
        'association_type_id' => 'setAssociationTypeId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'association_category' => 'getAssociationCategory',
        'association_type_id' => 'getAssociationTypeId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ASSOCIATION_CATEGORY_HUBSPOT_DEFINED = 'HUBSPOT_DEFINED';
    public const ASSOCIATION_CATEGORY_USER_DEFINED = 'USER_DEFINED';
    public const ASSOCIATION_CATEGORY_INTEGRATOR_DEFINED = 'INTEGRATOR_DEFINED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAssociationCategoryAllowableValues()
    {
        return [
            self::ASSOCIATION_CATEGORY_HUBSPOT_DEFINED,
            self::ASSOCIATION_CATEGORY_USER_DEFINED,
            self::ASSOCIATION_CATEGORY_INTEGRATOR_DEFINED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['association_category'] = $data['association_category'] ?? null;
        $this->container['association_type_id'] = $data['association_type_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['association_category'] === null) {
            $invalidProperties[] = "'association_category' can't be null";
        }
        $allowedValues = $this->getAssociationCategoryAllowableValues();
        if (!is_null($this->container['association_category']) && !in_array($this->container['association_category'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'association_category', must be one of '%s'",
                $this->container['association_category'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['association_type_id'] === null) {
            $invalidProperties[] = "'association_type_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets association_category
     *
     * @return string
     */
    public function getAssociationCategory()
    {
        return $this->container['association_category'];
    }

    /**
     * Sets association_category
     *
     * @param string $association_category association_category
     *
     * @return self
     */
    public function setAssociationCategory($association_category)
    {
        $allowedValues = $this->getAssociationCategoryAllowableValues();
        if (!in_array($association_category, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'association_category', must be one of '%s'",
                    $association_category,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['association_category'] = $association_category;

        return $this;
    }

    /**
     * Gets association_type_id
     *
     * @return int
     */
    public function getAssociationTypeId()
    {
        return $this->container['association_type_id'];
    }

    /**
     * Sets association_type_id
     *
     * @param int $association_type_id association_type_id
     *
     * @return self
     */
    public function setAssociationTypeId($association_type_id)
    {
        $this->container['association_type_id'] = $association_type_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


