<?php
/**
 * FilesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Files
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Files
 *
 * Upload and manage files.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Files\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Files\ApiException;
use HubSpot\Client\Files\Configuration;
use HubSpot\Client\Files\HeaderSelector;
use HubSpot\Client\Files\ObjectSerializer;

/**
 * FilesApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Files
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FilesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation archive
     *
     * Delete file
     *
     * @param  string $file_id File ID to delete (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archive($file_id)
    {
        $this->archiveWithHttpInfo($file_id);
    }

    /**
     * Operation archiveWithHttpInfo
     *
     * Delete file
     *
     * @param  string $file_id File ID to delete (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveWithHttpInfo($file_id)
    {
        $request = $this->archiveRequest($file_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveAsync
     *
     * Delete file
     *
     * @param  string $file_id File ID to delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsync($file_id)
    {
        return $this->archiveAsyncWithHttpInfo($file_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveAsyncWithHttpInfo
     *
     * Delete file
     *
     * @param  string $file_id File ID to delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsyncWithHttpInfo($file_id)
    {
        $returnType = '';
        $request = $this->archiveRequest($file_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archive'
     *
     * @param  string $file_id File ID to delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveRequest($file_id)
    {
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling archive'
            );
        }
        if (!preg_match("/\\d+/", $file_id)) {
            throw new \InvalidArgumentException("invalid value for \"file_id\" when calling FilesApi.archive, must conform to the pattern /\\d+/.");
        }


        $resourcePath = '/files/v3/files/{fileId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'fileId' . '}',
                ObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation archiveGDPR
     *
     * GDPR delete
     *
     * @param  string $file_id ID of file to GDPR delete (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archiveGDPR($file_id)
    {
        $this->archiveGDPRWithHttpInfo($file_id);
    }

    /**
     * Operation archiveGDPRWithHttpInfo
     *
     * GDPR delete
     *
     * @param  string $file_id ID of file to GDPR delete (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveGDPRWithHttpInfo($file_id)
    {
        $request = $this->archiveGDPRRequest($file_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveGDPRAsync
     *
     * GDPR delete
     *
     * @param  string $file_id ID of file to GDPR delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveGDPRAsync($file_id)
    {
        return $this->archiveGDPRAsyncWithHttpInfo($file_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveGDPRAsyncWithHttpInfo
     *
     * GDPR delete
     *
     * @param  string $file_id ID of file to GDPR delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveGDPRAsyncWithHttpInfo($file_id)
    {
        $returnType = '';
        $request = $this->archiveGDPRRequest($file_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archiveGDPR'
     *
     * @param  string $file_id ID of file to GDPR delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveGDPRRequest($file_id)
    {
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling archiveGDPR'
            );
        }
        if (!preg_match("/\\d+/", $file_id)) {
            throw new \InvalidArgumentException("invalid value for \"file_id\" when calling FilesApi.archiveGDPR, must conform to the pattern /\\d+/.");
        }


        $resourcePath = '/files/v3/files/{fileId}/gdpr-delete';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'fileId' . '}',
                ObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation checkImport
     *
     * Check import status.
     *
     * @param  string $task_id Import by URL task ID (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Files\Model\FileActionResponse|\HubSpot\Client\Files\Model\Error
     */
    public function checkImport($task_id)
    {
        list($response) = $this->checkImportWithHttpInfo($task_id);
        return $response;
    }

    /**
     * Operation checkImportWithHttpInfo
     *
     * Check import status.
     *
     * @param  string $task_id Import by URL task ID (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Files\Model\FileActionResponse|\HubSpot\Client\Files\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function checkImportWithHttpInfo($task_id)
    {
        $request = $this->checkImportRequest($task_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Files\Model\FileActionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\FileActionResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\FileActionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Files\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Files\Model\FileActionResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\FileActionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation checkImportAsync
     *
     * Check import status.
     *
     * @param  string $task_id Import by URL task ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkImportAsync($task_id)
    {
        return $this->checkImportAsyncWithHttpInfo($task_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation checkImportAsyncWithHttpInfo
     *
     * Check import status.
     *
     * @param  string $task_id Import by URL task ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkImportAsyncWithHttpInfo($task_id)
    {
        $returnType = '\HubSpot\Client\Files\Model\FileActionResponse';
        $request = $this->checkImportRequest($task_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'checkImport'
     *
     * @param  string $task_id Import by URL task ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function checkImportRequest($task_id)
    {
        // verify the required parameter 'task_id' is set
        if ($task_id === null || (is_array($task_id) && count($task_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $task_id when calling checkImport'
            );
        }

        $resourcePath = '/files/v3/files/import-from-url/async/tasks/{taskId}/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($task_id !== null) {
            $resourcePath = str_replace(
                '{' . 'taskId' . '}',
                ObjectSerializer::toPathValue($task_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation doSearch
     *
     * Search files
     *
     * @param  string[] $properties Desired file properties in the return object. (optional)
     * @param  string $after The maximum offset of items for a given search is 10000. Narrow your search down if you are reaching this limit. (optional)
     * @param  string $before before (optional)
     * @param  int $limit Number of items to return. Maximum limit is 100. (optional)
     * @param  string[] $sort Sort files by a given field. (optional)
     * @param  string $id Search files by given ID. (optional)
     * @param  \DateTime $created_at Search files by time of creation. (optional)
     * @param  \DateTime $created_at_lte created_at_lte (optional)
     * @param  \DateTime $created_at_gte created_at_gte (optional)
     * @param  \DateTime $updated_at Search files by time of latest updated. (optional)
     * @param  \DateTime $updated_at_lte updated_at_lte (optional)
     * @param  \DateTime $updated_at_gte updated_at_gte (optional)
     * @param  string $name Search for files containing the given name. (optional)
     * @param  string $path Search files by path. (optional)
     * @param  int $parent_folder_id Search files within given folder ID. (optional)
     * @param  int $size Query by file size. (optional)
     * @param  int $height Search files by height of image or video. (optional)
     * @param  int $width Search files by width of image or video. (optional)
     * @param  string $encoding Search files with specified encoding. (optional)
     * @param  string $type Filter by provided file type. (optional)
     * @param  string $extension Search files by given extension. (optional)
     * @param  string $url Search for given URL (optional)
     * @param  bool $is_usable_in_content If true shows files that have been marked to be used in new content. It false shows files that should not be used in new content. (optional)
     * @param  bool $allows_anonymous_access If &#39;true&#39; will show private files; if &#39;false&#39; will show public files (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Files\Model\CollectionResponseFile|\HubSpot\Client\Files\Model\Error
     */
    public function doSearch($properties = null, $after = null, $before = null, $limit = null, $sort = null, $id = null, $created_at = null, $created_at_lte = null, $created_at_gte = null, $updated_at = null, $updated_at_lte = null, $updated_at_gte = null, $name = null, $path = null, $parent_folder_id = null, $size = null, $height = null, $width = null, $encoding = null, $type = null, $extension = null, $url = null, $is_usable_in_content = null, $allows_anonymous_access = null)
    {
        list($response) = $this->doSearchWithHttpInfo($properties, $after, $before, $limit, $sort, $id, $created_at, $created_at_lte, $created_at_gte, $updated_at, $updated_at_lte, $updated_at_gte, $name, $path, $parent_folder_id, $size, $height, $width, $encoding, $type, $extension, $url, $is_usable_in_content, $allows_anonymous_access);
        return $response;
    }

    /**
     * Operation doSearchWithHttpInfo
     *
     * Search files
     *
     * @param  string[] $properties Desired file properties in the return object. (optional)
     * @param  string $after The maximum offset of items for a given search is 10000. Narrow your search down if you are reaching this limit. (optional)
     * @param  string $before (optional)
     * @param  int $limit Number of items to return. Maximum limit is 100. (optional)
     * @param  string[] $sort Sort files by a given field. (optional)
     * @param  string $id Search files by given ID. (optional)
     * @param  \DateTime $created_at Search files by time of creation. (optional)
     * @param  \DateTime $created_at_lte (optional)
     * @param  \DateTime $created_at_gte (optional)
     * @param  \DateTime $updated_at Search files by time of latest updated. (optional)
     * @param  \DateTime $updated_at_lte (optional)
     * @param  \DateTime $updated_at_gte (optional)
     * @param  string $name Search for files containing the given name. (optional)
     * @param  string $path Search files by path. (optional)
     * @param  int $parent_folder_id Search files within given folder ID. (optional)
     * @param  int $size Query by file size. (optional)
     * @param  int $height Search files by height of image or video. (optional)
     * @param  int $width Search files by width of image or video. (optional)
     * @param  string $encoding Search files with specified encoding. (optional)
     * @param  string $type Filter by provided file type. (optional)
     * @param  string $extension Search files by given extension. (optional)
     * @param  string $url Search for given URL (optional)
     * @param  bool $is_usable_in_content If true shows files that have been marked to be used in new content. It false shows files that should not be used in new content. (optional)
     * @param  bool $allows_anonymous_access If &#39;true&#39; will show private files; if &#39;false&#39; will show public files (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Files\Model\CollectionResponseFile|\HubSpot\Client\Files\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function doSearchWithHttpInfo($properties = null, $after = null, $before = null, $limit = null, $sort = null, $id = null, $created_at = null, $created_at_lte = null, $created_at_gte = null, $updated_at = null, $updated_at_lte = null, $updated_at_gte = null, $name = null, $path = null, $parent_folder_id = null, $size = null, $height = null, $width = null, $encoding = null, $type = null, $extension = null, $url = null, $is_usable_in_content = null, $allows_anonymous_access = null)
    {
        $request = $this->doSearchRequest($properties, $after, $before, $limit, $sort, $id, $created_at, $created_at_lte, $created_at_gte, $updated_at, $updated_at_lte, $updated_at_gte, $name, $path, $parent_folder_id, $size, $height, $width, $encoding, $type, $extension, $url, $is_usable_in_content, $allows_anonymous_access);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Files\Model\CollectionResponseFile' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\CollectionResponseFile' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\CollectionResponseFile', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Files\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Files\Model\CollectionResponseFile';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\CollectionResponseFile',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation doSearchAsync
     *
     * Search files
     *
     * @param  string[] $properties Desired file properties in the return object. (optional)
     * @param  string $after The maximum offset of items for a given search is 10000. Narrow your search down if you are reaching this limit. (optional)
     * @param  string $before (optional)
     * @param  int $limit Number of items to return. Maximum limit is 100. (optional)
     * @param  string[] $sort Sort files by a given field. (optional)
     * @param  string $id Search files by given ID. (optional)
     * @param  \DateTime $created_at Search files by time of creation. (optional)
     * @param  \DateTime $created_at_lte (optional)
     * @param  \DateTime $created_at_gte (optional)
     * @param  \DateTime $updated_at Search files by time of latest updated. (optional)
     * @param  \DateTime $updated_at_lte (optional)
     * @param  \DateTime $updated_at_gte (optional)
     * @param  string $name Search for files containing the given name. (optional)
     * @param  string $path Search files by path. (optional)
     * @param  int $parent_folder_id Search files within given folder ID. (optional)
     * @param  int $size Query by file size. (optional)
     * @param  int $height Search files by height of image or video. (optional)
     * @param  int $width Search files by width of image or video. (optional)
     * @param  string $encoding Search files with specified encoding. (optional)
     * @param  string $type Filter by provided file type. (optional)
     * @param  string $extension Search files by given extension. (optional)
     * @param  string $url Search for given URL (optional)
     * @param  bool $is_usable_in_content If true shows files that have been marked to be used in new content. It false shows files that should not be used in new content. (optional)
     * @param  bool $allows_anonymous_access If &#39;true&#39; will show private files; if &#39;false&#39; will show public files (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doSearchAsync($properties = null, $after = null, $before = null, $limit = null, $sort = null, $id = null, $created_at = null, $created_at_lte = null, $created_at_gte = null, $updated_at = null, $updated_at_lte = null, $updated_at_gte = null, $name = null, $path = null, $parent_folder_id = null, $size = null, $height = null, $width = null, $encoding = null, $type = null, $extension = null, $url = null, $is_usable_in_content = null, $allows_anonymous_access = null)
    {
        return $this->doSearchAsyncWithHttpInfo($properties, $after, $before, $limit, $sort, $id, $created_at, $created_at_lte, $created_at_gte, $updated_at, $updated_at_lte, $updated_at_gte, $name, $path, $parent_folder_id, $size, $height, $width, $encoding, $type, $extension, $url, $is_usable_in_content, $allows_anonymous_access)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation doSearchAsyncWithHttpInfo
     *
     * Search files
     *
     * @param  string[] $properties Desired file properties in the return object. (optional)
     * @param  string $after The maximum offset of items for a given search is 10000. Narrow your search down if you are reaching this limit. (optional)
     * @param  string $before (optional)
     * @param  int $limit Number of items to return. Maximum limit is 100. (optional)
     * @param  string[] $sort Sort files by a given field. (optional)
     * @param  string $id Search files by given ID. (optional)
     * @param  \DateTime $created_at Search files by time of creation. (optional)
     * @param  \DateTime $created_at_lte (optional)
     * @param  \DateTime $created_at_gte (optional)
     * @param  \DateTime $updated_at Search files by time of latest updated. (optional)
     * @param  \DateTime $updated_at_lte (optional)
     * @param  \DateTime $updated_at_gte (optional)
     * @param  string $name Search for files containing the given name. (optional)
     * @param  string $path Search files by path. (optional)
     * @param  int $parent_folder_id Search files within given folder ID. (optional)
     * @param  int $size Query by file size. (optional)
     * @param  int $height Search files by height of image or video. (optional)
     * @param  int $width Search files by width of image or video. (optional)
     * @param  string $encoding Search files with specified encoding. (optional)
     * @param  string $type Filter by provided file type. (optional)
     * @param  string $extension Search files by given extension. (optional)
     * @param  string $url Search for given URL (optional)
     * @param  bool $is_usable_in_content If true shows files that have been marked to be used in new content. It false shows files that should not be used in new content. (optional)
     * @param  bool $allows_anonymous_access If &#39;true&#39; will show private files; if &#39;false&#39; will show public files (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doSearchAsyncWithHttpInfo($properties = null, $after = null, $before = null, $limit = null, $sort = null, $id = null, $created_at = null, $created_at_lte = null, $created_at_gte = null, $updated_at = null, $updated_at_lte = null, $updated_at_gte = null, $name = null, $path = null, $parent_folder_id = null, $size = null, $height = null, $width = null, $encoding = null, $type = null, $extension = null, $url = null, $is_usable_in_content = null, $allows_anonymous_access = null)
    {
        $returnType = '\HubSpot\Client\Files\Model\CollectionResponseFile';
        $request = $this->doSearchRequest($properties, $after, $before, $limit, $sort, $id, $created_at, $created_at_lte, $created_at_gte, $updated_at, $updated_at_lte, $updated_at_gte, $name, $path, $parent_folder_id, $size, $height, $width, $encoding, $type, $extension, $url, $is_usable_in_content, $allows_anonymous_access);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'doSearch'
     *
     * @param  string[] $properties Desired file properties in the return object. (optional)
     * @param  string $after The maximum offset of items for a given search is 10000. Narrow your search down if you are reaching this limit. (optional)
     * @param  string $before (optional)
     * @param  int $limit Number of items to return. Maximum limit is 100. (optional)
     * @param  string[] $sort Sort files by a given field. (optional)
     * @param  string $id Search files by given ID. (optional)
     * @param  \DateTime $created_at Search files by time of creation. (optional)
     * @param  \DateTime $created_at_lte (optional)
     * @param  \DateTime $created_at_gte (optional)
     * @param  \DateTime $updated_at Search files by time of latest updated. (optional)
     * @param  \DateTime $updated_at_lte (optional)
     * @param  \DateTime $updated_at_gte (optional)
     * @param  string $name Search for files containing the given name. (optional)
     * @param  string $path Search files by path. (optional)
     * @param  int $parent_folder_id Search files within given folder ID. (optional)
     * @param  int $size Query by file size. (optional)
     * @param  int $height Search files by height of image or video. (optional)
     * @param  int $width Search files by width of image or video. (optional)
     * @param  string $encoding Search files with specified encoding. (optional)
     * @param  string $type Filter by provided file type. (optional)
     * @param  string $extension Search files by given extension. (optional)
     * @param  string $url Search for given URL (optional)
     * @param  bool $is_usable_in_content If true shows files that have been marked to be used in new content. It false shows files that should not be used in new content. (optional)
     * @param  bool $allows_anonymous_access If &#39;true&#39; will show private files; if &#39;false&#39; will show public files (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function doSearchRequest($properties = null, $after = null, $before = null, $limit = null, $sort = null, $id = null, $created_at = null, $created_at_lte = null, $created_at_gte = null, $updated_at = null, $updated_at_lte = null, $updated_at_gte = null, $name = null, $path = null, $parent_folder_id = null, $size = null, $height = null, $width = null, $encoding = null, $type = null, $extension = null, $url = null, $is_usable_in_content = null, $allows_anonymous_access = null)
    {

        $resourcePath = '/files/v3/files/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $properties,
            'properties', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $before,
            'before', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_at,
            'createdAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_at_lte,
            'createdAtLte', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_at_gte,
            'createdAtGte', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_at,
            'updatedAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_at_lte,
            'updatedAtLte', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_at_gte,
            'updatedAtGte', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $path,
            'path', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $parent_folder_id,
            'parentFolderId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $size,
            'size', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $height,
            'height', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $width,
            'width', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $encoding,
            'encoding', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $type,
            'type', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $extension,
            'extension', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $url,
            'url', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_usable_in_content,
            'isUsableInContent', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $allows_anonymous_access,
            'allowsAnonymousAccess', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getById
     *
     * Get file.
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  string[] $properties properties (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Files\Model\File|\HubSpot\Client\Files\Model\Error
     */
    public function getById($file_id, $properties = null)
    {
        list($response) = $this->getByIdWithHttpInfo($file_id, $properties);
        return $response;
    }

    /**
     * Operation getByIdWithHttpInfo
     *
     * Get file.
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  string[] $properties (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Files\Model\File|\HubSpot\Client\Files\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getByIdWithHttpInfo($file_id, $properties = null)
    {
        $request = $this->getByIdRequest($file_id, $properties);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Files\Model\File' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\File' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\File', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Files\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Files\Model\File';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\File',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getByIdAsync
     *
     * Get file.
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  string[] $properties (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsync($file_id, $properties = null)
    {
        return $this->getByIdAsyncWithHttpInfo($file_id, $properties)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getByIdAsyncWithHttpInfo
     *
     * Get file.
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  string[] $properties (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsyncWithHttpInfo($file_id, $properties = null)
    {
        $returnType = '\HubSpot\Client\Files\Model\File';
        $request = $this->getByIdRequest($file_id, $properties);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getById'
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  string[] $properties (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getByIdRequest($file_id, $properties = null)
    {
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling getById'
            );
        }
        if (!preg_match("/\\d+/", $file_id)) {
            throw new \InvalidArgumentException("invalid value for \"file_id\" when calling FilesApi.getById, must conform to the pattern /\\d+/.");
        }


        $resourcePath = '/files/v3/files/{fileId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $properties,
            'properties', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'fileId' . '}',
                ObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSignedUrl
     *
     * Get signed URL to access private file.
     *
     * @param  string $file_id ID of file. (required)
     * @param  string $size For image files. This will resize the image to the desired size before sharing. Does not affect the original file, just the file served by this signed URL. (optional)
     * @param  int $expiration_seconds How long in seconds the link will provide access to the file. (optional)
     * @param  bool $upscale If size is provided, this will upscale the image to fit the size dimensions. (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Files\Model\SignedUrl|\HubSpot\Client\Files\Model\Error
     */
    public function getSignedUrl($file_id, $size = null, $expiration_seconds = null, $upscale = null)
    {
        list($response) = $this->getSignedUrlWithHttpInfo($file_id, $size, $expiration_seconds, $upscale);
        return $response;
    }

    /**
     * Operation getSignedUrlWithHttpInfo
     *
     * Get signed URL to access private file.
     *
     * @param  string $file_id ID of file. (required)
     * @param  string $size For image files. This will resize the image to the desired size before sharing. Does not affect the original file, just the file served by this signed URL. (optional)
     * @param  int $expiration_seconds How long in seconds the link will provide access to the file. (optional)
     * @param  bool $upscale If size is provided, this will upscale the image to fit the size dimensions. (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Files\Model\SignedUrl|\HubSpot\Client\Files\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSignedUrlWithHttpInfo($file_id, $size = null, $expiration_seconds = null, $upscale = null)
    {
        $request = $this->getSignedUrlRequest($file_id, $size, $expiration_seconds, $upscale);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Files\Model\SignedUrl' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\SignedUrl' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\SignedUrl', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Files\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Files\Model\SignedUrl';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\SignedUrl',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSignedUrlAsync
     *
     * Get signed URL to access private file.
     *
     * @param  string $file_id ID of file. (required)
     * @param  string $size For image files. This will resize the image to the desired size before sharing. Does not affect the original file, just the file served by this signed URL. (optional)
     * @param  int $expiration_seconds How long in seconds the link will provide access to the file. (optional)
     * @param  bool $upscale If size is provided, this will upscale the image to fit the size dimensions. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSignedUrlAsync($file_id, $size = null, $expiration_seconds = null, $upscale = null)
    {
        return $this->getSignedUrlAsyncWithHttpInfo($file_id, $size, $expiration_seconds, $upscale)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSignedUrlAsyncWithHttpInfo
     *
     * Get signed URL to access private file.
     *
     * @param  string $file_id ID of file. (required)
     * @param  string $size For image files. This will resize the image to the desired size before sharing. Does not affect the original file, just the file served by this signed URL. (optional)
     * @param  int $expiration_seconds How long in seconds the link will provide access to the file. (optional)
     * @param  bool $upscale If size is provided, this will upscale the image to fit the size dimensions. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSignedUrlAsyncWithHttpInfo($file_id, $size = null, $expiration_seconds = null, $upscale = null)
    {
        $returnType = '\HubSpot\Client\Files\Model\SignedUrl';
        $request = $this->getSignedUrlRequest($file_id, $size, $expiration_seconds, $upscale);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSignedUrl'
     *
     * @param  string $file_id ID of file. (required)
     * @param  string $size For image files. This will resize the image to the desired size before sharing. Does not affect the original file, just the file served by this signed URL. (optional)
     * @param  int $expiration_seconds How long in seconds the link will provide access to the file. (optional)
     * @param  bool $upscale If size is provided, this will upscale the image to fit the size dimensions. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSignedUrlRequest($file_id, $size = null, $expiration_seconds = null, $upscale = null)
    {
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling getSignedUrl'
            );
        }
        if (!preg_match("/\\d+/", $file_id)) {
            throw new \InvalidArgumentException("invalid value for \"file_id\" when calling FilesApi.getSignedUrl, must conform to the pattern /\\d+/.");
        }


        $resourcePath = '/files/v3/files/{fileId}/signed-url';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $size,
            'size', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $expiration_seconds,
            'expirationSeconds', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $upscale,
            'upscale', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'fileId' . '}',
                ObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation importFromUrl
     *
     * Import a file from a URL into the file manager.
     *
     * @param  \HubSpot\Client\Files\Model\ImportFromUrlInput $import_from_url_input import_from_url_input (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Files\Model\ImportFromUrlTaskLocator|\HubSpot\Client\Files\Model\Error
     */
    public function importFromUrl($import_from_url_input)
    {
        list($response) = $this->importFromUrlWithHttpInfo($import_from_url_input);
        return $response;
    }

    /**
     * Operation importFromUrlWithHttpInfo
     *
     * Import a file from a URL into the file manager.
     *
     * @param  \HubSpot\Client\Files\Model\ImportFromUrlInput $import_from_url_input (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Files\Model\ImportFromUrlTaskLocator|\HubSpot\Client\Files\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function importFromUrlWithHttpInfo($import_from_url_input)
    {
        $request = $this->importFromUrlRequest($import_from_url_input);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 202:
                    if ('\HubSpot\Client\Files\Model\ImportFromUrlTaskLocator' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\ImportFromUrlTaskLocator' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\ImportFromUrlTaskLocator', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Files\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Files\Model\ImportFromUrlTaskLocator';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\ImportFromUrlTaskLocator',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation importFromUrlAsync
     *
     * Import a file from a URL into the file manager.
     *
     * @param  \HubSpot\Client\Files\Model\ImportFromUrlInput $import_from_url_input (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importFromUrlAsync($import_from_url_input)
    {
        return $this->importFromUrlAsyncWithHttpInfo($import_from_url_input)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation importFromUrlAsyncWithHttpInfo
     *
     * Import a file from a URL into the file manager.
     *
     * @param  \HubSpot\Client\Files\Model\ImportFromUrlInput $import_from_url_input (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importFromUrlAsyncWithHttpInfo($import_from_url_input)
    {
        $returnType = '\HubSpot\Client\Files\Model\ImportFromUrlTaskLocator';
        $request = $this->importFromUrlRequest($import_from_url_input);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'importFromUrl'
     *
     * @param  \HubSpot\Client\Files\Model\ImportFromUrlInput $import_from_url_input (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function importFromUrlRequest($import_from_url_input)
    {
        // verify the required parameter 'import_from_url_input' is set
        if ($import_from_url_input === null || (is_array($import_from_url_input) && count($import_from_url_input) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_from_url_input when calling importFromUrl'
            );
        }

        $resourcePath = '/files/v3/files/import-from-url/async';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($import_from_url_input)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($import_from_url_input));
            } else {
                $httpBody = $import_from_url_input;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation replace
     *
     * Replace file.
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  \SplFileObject $file File data that will replace existing file in the file manager. (optional)
     * @param  string $charset_hunch Character set of given file data. (optional)
     * @param  string $options JSON String representing FileReplaceOptions (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Files\Model\File|\HubSpot\Client\Files\Model\Error
     */
    public function replace($file_id, $file = null, $charset_hunch = null, $options = null)
    {
        list($response) = $this->replaceWithHttpInfo($file_id, $file, $charset_hunch, $options);
        return $response;
    }

    /**
     * Operation replaceWithHttpInfo
     *
     * Replace file.
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  \SplFileObject $file File data that will replace existing file in the file manager. (optional)
     * @param  string $charset_hunch Character set of given file data. (optional)
     * @param  string $options JSON String representing FileReplaceOptions (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Files\Model\File|\HubSpot\Client\Files\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function replaceWithHttpInfo($file_id, $file = null, $charset_hunch = null, $options = null)
    {
        $request = $this->replaceRequest($file_id, $file, $charset_hunch, $options);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Files\Model\File' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\File' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\File', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Files\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Files\Model\File';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\File',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation replaceAsync
     *
     * Replace file.
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  \SplFileObject $file File data that will replace existing file in the file manager. (optional)
     * @param  string $charset_hunch Character set of given file data. (optional)
     * @param  string $options JSON String representing FileReplaceOptions (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function replaceAsync($file_id, $file = null, $charset_hunch = null, $options = null)
    {
        return $this->replaceAsyncWithHttpInfo($file_id, $file, $charset_hunch, $options)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation replaceAsyncWithHttpInfo
     *
     * Replace file.
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  \SplFileObject $file File data that will replace existing file in the file manager. (optional)
     * @param  string $charset_hunch Character set of given file data. (optional)
     * @param  string $options JSON String representing FileReplaceOptions (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function replaceAsyncWithHttpInfo($file_id, $file = null, $charset_hunch = null, $options = null)
    {
        $returnType = '\HubSpot\Client\Files\Model\File';
        $request = $this->replaceRequest($file_id, $file, $charset_hunch, $options);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'replace'
     *
     * @param  string $file_id Id of the desired file. (required)
     * @param  \SplFileObject $file File data that will replace existing file in the file manager. (optional)
     * @param  string $charset_hunch Character set of given file data. (optional)
     * @param  string $options JSON String representing FileReplaceOptions (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function replaceRequest($file_id, $file = null, $charset_hunch = null, $options = null)
    {
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling replace'
            );
        }
        if (!preg_match("/\\d+/", $file_id)) {
            throw new \InvalidArgumentException("invalid value for \"file_id\" when calling FilesApi.replace, must conform to the pattern /\\d+/.");
        }


        $resourcePath = '/files/v3/files/{fileId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'fileId' . '}',
                ObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }

        // form params
        if ($file !== null) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($charset_hunch !== null) {
            $formParams['charsetHunch'] = ObjectSerializer::toFormValue($charset_hunch);
        }
        // form params
        if ($options !== null) {
            $formParams['options'] = ObjectSerializer::toFormValue($options);
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['multipart/form-data']
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateProperties
     *
     * update file properties
     *
     * @param  string $file_id ID of file to update (required)
     * @param  \HubSpot\Client\Files\Model\FileUpdateInput $file_update_input Options to update. (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Files\Model\File|\HubSpot\Client\Files\Model\Error
     */
    public function updateProperties($file_id, $file_update_input)
    {
        list($response) = $this->updatePropertiesWithHttpInfo($file_id, $file_update_input);
        return $response;
    }

    /**
     * Operation updatePropertiesWithHttpInfo
     *
     * update file properties
     *
     * @param  string $file_id ID of file to update (required)
     * @param  \HubSpot\Client\Files\Model\FileUpdateInput $file_update_input Options to update. (required)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Files\Model\File|\HubSpot\Client\Files\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePropertiesWithHttpInfo($file_id, $file_update_input)
    {
        $request = $this->updatePropertiesRequest($file_id, $file_update_input);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Files\Model\File' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\File' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\File', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Files\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Files\Model\File';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\File',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updatePropertiesAsync
     *
     * update file properties
     *
     * @param  string $file_id ID of file to update (required)
     * @param  \HubSpot\Client\Files\Model\FileUpdateInput $file_update_input Options to update. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePropertiesAsync($file_id, $file_update_input)
    {
        return $this->updatePropertiesAsyncWithHttpInfo($file_id, $file_update_input)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePropertiesAsyncWithHttpInfo
     *
     * update file properties
     *
     * @param  string $file_id ID of file to update (required)
     * @param  \HubSpot\Client\Files\Model\FileUpdateInput $file_update_input Options to update. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePropertiesAsyncWithHttpInfo($file_id, $file_update_input)
    {
        $returnType = '\HubSpot\Client\Files\Model\File';
        $request = $this->updatePropertiesRequest($file_id, $file_update_input);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateProperties'
     *
     * @param  string $file_id ID of file to update (required)
     * @param  \HubSpot\Client\Files\Model\FileUpdateInput $file_update_input Options to update. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePropertiesRequest($file_id, $file_update_input)
    {
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling updateProperties'
            );
        }
        if (!preg_match("/\\d+/", $file_id)) {
            throw new \InvalidArgumentException("invalid value for \"file_id\" when calling FilesApi.updateProperties, must conform to the pattern /\\d+/.");
        }

        // verify the required parameter 'file_update_input' is set
        if ($file_update_input === null || (is_array($file_update_input) && count($file_update_input) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_update_input when calling updateProperties'
            );
        }

        $resourcePath = '/files/v3/files/{fileId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'fileId' . '}',
                ObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($file_update_input)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($file_update_input));
            } else {
                $httpBody = $file_update_input;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation upload
     *
     * Upload file
     *
     * @param  \SplFileObject $file File to be uploaded. (optional)
     * @param  string $folder_id Either &#39;folderId&#39; or &#39;folderPath&#39; is required. folderId is the ID of the folder the file will be uploaded to. (optional)
     * @param  string $folder_path Either &#39;folderPath&#39; or &#39;folderId&#39; is required. This field represents the destination folder path for the uploaded file. If a path doesn&#39;t exist, the system will try to create one. (optional)
     * @param  string $file_name Desired name for the uploaded file. (optional)
     * @param  string $charset_hunch Character set of the uploaded file. (optional)
     * @param  string $options JSON string representing FileUploadOptions. (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Files\Model\File|\HubSpot\Client\Files\Model\Error
     */
    public function upload($file = null, $folder_id = null, $folder_path = null, $file_name = null, $charset_hunch = null, $options = null)
    {
        list($response) = $this->uploadWithHttpInfo($file, $folder_id, $folder_path, $file_name, $charset_hunch, $options);
        return $response;
    }

    /**
     * Operation uploadWithHttpInfo
     *
     * Upload file
     *
     * @param  \SplFileObject $file File to be uploaded. (optional)
     * @param  string $folder_id Either &#39;folderId&#39; or &#39;folderPath&#39; is required. folderId is the ID of the folder the file will be uploaded to. (optional)
     * @param  string $folder_path Either &#39;folderPath&#39; or &#39;folderId&#39; is required. This field represents the destination folder path for the uploaded file. If a path doesn&#39;t exist, the system will try to create one. (optional)
     * @param  string $file_name Desired name for the uploaded file. (optional)
     * @param  string $charset_hunch Character set of the uploaded file. (optional)
     * @param  string $options JSON string representing FileUploadOptions. (optional)
     *
     * @throws \HubSpot\Client\Files\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Files\Model\File|\HubSpot\Client\Files\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadWithHttpInfo($file = null, $folder_id = null, $folder_path = null, $file_name = null, $charset_hunch = null, $options = null)
    {
        $request = $this->uploadRequest($file, $folder_id, $folder_path, $file_name, $charset_hunch, $options);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Files\Model\File' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\File' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\File', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Files\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Files\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Files\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Files\Model\File';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\File',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Files\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation uploadAsync
     *
     * Upload file
     *
     * @param  \SplFileObject $file File to be uploaded. (optional)
     * @param  string $folder_id Either &#39;folderId&#39; or &#39;folderPath&#39; is required. folderId is the ID of the folder the file will be uploaded to. (optional)
     * @param  string $folder_path Either &#39;folderPath&#39; or &#39;folderId&#39; is required. This field represents the destination folder path for the uploaded file. If a path doesn&#39;t exist, the system will try to create one. (optional)
     * @param  string $file_name Desired name for the uploaded file. (optional)
     * @param  string $charset_hunch Character set of the uploaded file. (optional)
     * @param  string $options JSON string representing FileUploadOptions. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadAsync($file = null, $folder_id = null, $folder_path = null, $file_name = null, $charset_hunch = null, $options = null)
    {
        return $this->uploadAsyncWithHttpInfo($file, $folder_id, $folder_path, $file_name, $charset_hunch, $options)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadAsyncWithHttpInfo
     *
     * Upload file
     *
     * @param  \SplFileObject $file File to be uploaded. (optional)
     * @param  string $folder_id Either &#39;folderId&#39; or &#39;folderPath&#39; is required. folderId is the ID of the folder the file will be uploaded to. (optional)
     * @param  string $folder_path Either &#39;folderPath&#39; or &#39;folderId&#39; is required. This field represents the destination folder path for the uploaded file. If a path doesn&#39;t exist, the system will try to create one. (optional)
     * @param  string $file_name Desired name for the uploaded file. (optional)
     * @param  string $charset_hunch Character set of the uploaded file. (optional)
     * @param  string $options JSON string representing FileUploadOptions. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadAsyncWithHttpInfo($file = null, $folder_id = null, $folder_path = null, $file_name = null, $charset_hunch = null, $options = null)
    {
        $returnType = '\HubSpot\Client\Files\Model\File';
        $request = $this->uploadRequest($file, $folder_id, $folder_path, $file_name, $charset_hunch, $options);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'upload'
     *
     * @param  \SplFileObject $file File to be uploaded. (optional)
     * @param  string $folder_id Either &#39;folderId&#39; or &#39;folderPath&#39; is required. folderId is the ID of the folder the file will be uploaded to. (optional)
     * @param  string $folder_path Either &#39;folderPath&#39; or &#39;folderId&#39; is required. This field represents the destination folder path for the uploaded file. If a path doesn&#39;t exist, the system will try to create one. (optional)
     * @param  string $file_name Desired name for the uploaded file. (optional)
     * @param  string $charset_hunch Character set of the uploaded file. (optional)
     * @param  string $options JSON string representing FileUploadOptions. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadRequest($file = null, $folder_id = null, $folder_path = null, $file_name = null, $charset_hunch = null, $options = null)
    {

        $resourcePath = '/files/v3/files';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        if ($file !== null) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($folder_id !== null) {
            $formParams['folderId'] = ObjectSerializer::toFormValue($folder_id);
        }
        // form params
        if ($folder_path !== null) {
            $formParams['folderPath'] = ObjectSerializer::toFormValue($folder_path);
        }
        // form params
        if ($file_name !== null) {
            $formParams['fileName'] = ObjectSerializer::toFormValue($file_name);
        }
        // form params
        if ($charset_hunch !== null) {
            $formParams['charsetHunch'] = ObjectSerializer::toFormValue($charset_hunch);
        }
        // form params
        if ($options !== null) {
            $formParams['options'] = ObjectSerializer::toFormValue($options);
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['multipart/form-data']
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
