<?php
/**
 * MarketingEventsExternalApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Events Extension
 *
 * These APIs allow you to interact with HubSpot's Marketing Events Extension. It allows you to: * Create, Read or update Marketing Event information in HubSpot * Specify whether a HubSpot contact has registered, attended or cancelled a registration to a Marketing Event. * Specify a URL that can be called to get the details of a Marketing Event.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Events\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Marketing\Events\ApiException;
use HubSpot\Client\Marketing\Events\Configuration;
use HubSpot\Client\Marketing\Events\HeaderSelector;
use HubSpot\Client\Marketing\Events\ObjectSerializer;

/**
 * MarketingEventsExternalApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class MarketingEventsExternalApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation archive
     *
     * @param  string $external_event_id external_event_id (required)
     * @param  string $external_account_id external_account_id (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archive($external_event_id, $external_account_id)
    {
        $this->archiveWithHttpInfo($external_event_id, $external_account_id);
    }

    /**
     * Operation archiveWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveWithHttpInfo($external_event_id, $external_account_id)
    {
        $request = $this->archiveRequest($external_event_id, $external_account_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveAsync
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsync($external_event_id, $external_account_id)
    {
        return $this->archiveAsyncWithHttpInfo($external_event_id, $external_account_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveAsyncWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsyncWithHttpInfo($external_event_id, $external_account_id)
    {
        $returnType = '';
        $request = $this->archiveRequest($external_event_id, $external_account_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archive'
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveRequest($external_event_id, $external_account_id)
    {
        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling archive'
            );
        }
        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling archive'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_account_id,
            'externalAccountId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation archiveBatch
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventExternalUniqueIdentifier $batch_input_marketing_event_external_unique_identifier batch_input_marketing_event_external_unique_identifier (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\Error
     */
    public function archiveBatch($batch_input_marketing_event_external_unique_identifier)
    {
        list($response) = $this->archiveBatchWithHttpInfo($batch_input_marketing_event_external_unique_identifier);
        return $response;
    }

    /**
     * Operation archiveBatchWithHttpInfo
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventExternalUniqueIdentifier $batch_input_marketing_event_external_unique_identifier (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveBatchWithHttpInfo($batch_input_marketing_event_external_unique_identifier)
    {
        $request = $this->archiveBatchRequest($batch_input_marketing_event_external_unique_identifier);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveBatchAsync
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventExternalUniqueIdentifier $batch_input_marketing_event_external_unique_identifier (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveBatchAsync($batch_input_marketing_event_external_unique_identifier)
    {
        return $this->archiveBatchAsyncWithHttpInfo($batch_input_marketing_event_external_unique_identifier)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveBatchAsyncWithHttpInfo
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventExternalUniqueIdentifier $batch_input_marketing_event_external_unique_identifier (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveBatchAsyncWithHttpInfo($batch_input_marketing_event_external_unique_identifier)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
        $request = $this->archiveBatchRequest($batch_input_marketing_event_external_unique_identifier);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archiveBatch'
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventExternalUniqueIdentifier $batch_input_marketing_event_external_unique_identifier (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveBatchRequest($batch_input_marketing_event_external_unique_identifier)
    {
        // verify the required parameter 'batch_input_marketing_event_external_unique_identifier' is set
        if ($batch_input_marketing_event_external_unique_identifier === null || (is_array($batch_input_marketing_event_external_unique_identifier) && count($batch_input_marketing_event_external_unique_identifier) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_marketing_event_external_unique_identifier when calling archiveBatch'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/delete';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_marketing_event_external_unique_identifier)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_marketing_event_external_unique_identifier));
            } else {
                $httpBody = $batch_input_marketing_event_external_unique_identifier;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation complete
     *
     * @param  string $external_event_id external_event_id (required)
     * @param  string $external_account_id external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCompleteRequestParams $marketing_event_complete_request_params marketing_event_complete_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function complete($external_event_id, $external_account_id, $marketing_event_complete_request_params)
    {
        list($response) = $this->completeWithHttpInfo($external_event_id, $external_account_id, $marketing_event_complete_request_params);
        return $response;
    }

    /**
     * Operation completeWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCompleteRequestParams $marketing_event_complete_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function completeWithHttpInfo($external_event_id, $external_account_id, $marketing_event_complete_request_params)
    {
        $request = $this->completeRequest($external_event_id, $external_account_id, $marketing_event_complete_request_params);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation completeAsync
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCompleteRequestParams $marketing_event_complete_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completeAsync($external_event_id, $external_account_id, $marketing_event_complete_request_params)
    {
        return $this->completeAsyncWithHttpInfo($external_event_id, $external_account_id, $marketing_event_complete_request_params)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation completeAsyncWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCompleteRequestParams $marketing_event_complete_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completeAsyncWithHttpInfo($external_event_id, $external_account_id, $marketing_event_complete_request_params)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse';
        $request = $this->completeRequest($external_event_id, $external_account_id, $marketing_event_complete_request_params);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'complete'
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCompleteRequestParams $marketing_event_complete_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function completeRequest($external_event_id, $external_account_id, $marketing_event_complete_request_params)
    {
        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling complete'
            );
        }
        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling complete'
            );
        }
        // verify the required parameter 'marketing_event_complete_request_params' is set
        if ($marketing_event_complete_request_params === null || (is_array($marketing_event_complete_request_params) && count($marketing_event_complete_request_params) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketing_event_complete_request_params when calling complete'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}/complete';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_account_id,
            'externalAccountId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($marketing_event_complete_request_params)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($marketing_event_complete_request_params));
            } else {
                $httpBody = $marketing_event_complete_request_params;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation create
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params marketing_event_create_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function create($marketing_event_create_request_params)
    {
        list($response) = $this->createWithHttpInfo($marketing_event_create_request_params);
        return $response;
    }

    /**
     * Operation createWithHttpInfo
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWithHttpInfo($marketing_event_create_request_params)
    {
        $request = $this->createRequest($marketing_event_create_request_params);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAsync
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsync($marketing_event_create_request_params)
    {
        return $this->createAsyncWithHttpInfo($marketing_event_create_request_params)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAsyncWithHttpInfo
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAsyncWithHttpInfo($marketing_event_create_request_params)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse';
        $request = $this->createRequest($marketing_event_create_request_params);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'create'
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRequest($marketing_event_create_request_params)
    {
        // verify the required parameter 'marketing_event_create_request_params' is set
        if ($marketing_event_create_request_params === null || (is_array($marketing_event_create_request_params) && count($marketing_event_create_request_params) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketing_event_create_request_params when calling create'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($marketing_event_create_request_params)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($marketing_event_create_request_params));
            } else {
                $httpBody = $marketing_event_create_request_params;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation doCancel
     *
     * @param  string $external_event_id external_event_id (required)
     * @param  string $external_account_id external_account_id (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function doCancel($external_event_id, $external_account_id)
    {
        list($response) = $this->doCancelWithHttpInfo($external_event_id, $external_account_id);
        return $response;
    }

    /**
     * Operation doCancelWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function doCancelWithHttpInfo($external_event_id, $external_account_id)
    {
        $request = $this->doCancelRequest($external_event_id, $external_account_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation doCancelAsync
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doCancelAsync($external_event_id, $external_account_id)
    {
        return $this->doCancelAsyncWithHttpInfo($external_event_id, $external_account_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation doCancelAsyncWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doCancelAsyncWithHttpInfo($external_event_id, $external_account_id)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventDefaultResponse';
        $request = $this->doCancelRequest($external_event_id, $external_account_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'doCancel'
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function doCancelRequest($external_event_id, $external_account_id)
    {
        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling doCancel'
            );
        }
        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling doCancel'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}/cancel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_account_id,
            'externalAccountId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation doEmailUpsertById
     *
     * @param  string $external_event_id external_event_id (required)
     * @param  string $subscriber_state subscriber_state (required)
     * @param  string $external_account_id external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber batch_input_marketing_event_email_subscriber (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\Error
     */
    public function doEmailUpsertById($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber)
    {
        list($response) = $this->doEmailUpsertByIdWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber);
        return $response;
    }

    /**
     * Operation doEmailUpsertByIdWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $subscriber_state (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function doEmailUpsertByIdWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber)
    {
        $request = $this->doEmailUpsertByIdRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation doEmailUpsertByIdAsync
     *
     * @param  string $external_event_id (required)
     * @param  string $subscriber_state (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doEmailUpsertByIdAsync($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber)
    {
        return $this->doEmailUpsertByIdAsyncWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation doEmailUpsertByIdAsyncWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $subscriber_state (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doEmailUpsertByIdAsyncWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
        $request = $this->doEmailUpsertByIdRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'doEmailUpsertById'
     *
     * @param  string $external_event_id (required)
     * @param  string $subscriber_state (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function doEmailUpsertByIdRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber)
    {
        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling doEmailUpsertById'
            );
        }
        // verify the required parameter 'subscriber_state' is set
        if ($subscriber_state === null || (is_array($subscriber_state) && count($subscriber_state) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscriber_state when calling doEmailUpsertById'
            );
        }
        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling doEmailUpsertById'
            );
        }
        // verify the required parameter 'batch_input_marketing_event_email_subscriber' is set
        if ($batch_input_marketing_event_email_subscriber === null || (is_array($batch_input_marketing_event_email_subscriber) && count($batch_input_marketing_event_email_subscriber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_marketing_event_email_subscriber when calling doEmailUpsertById'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}/{subscriberState}/email-upsert';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_account_id,
            'externalAccountId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }
        // path params
        if ($subscriber_state !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriberState' . '}',
                ObjectSerializer::toPathValue($subscriber_state),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_marketing_event_email_subscriber)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_marketing_event_email_subscriber));
            } else {
                $httpBody = $batch_input_marketing_event_email_subscriber;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation doUpsert
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventCreateRequestParams $batch_input_marketing_event_create_request_params batch_input_marketing_event_create_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\BatchResponseMarketingEventPublicDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function doUpsert($batch_input_marketing_event_create_request_params)
    {
        list($response) = $this->doUpsertWithHttpInfo($batch_input_marketing_event_create_request_params);
        return $response;
    }

    /**
     * Operation doUpsertWithHttpInfo
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventCreateRequestParams $batch_input_marketing_event_create_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\BatchResponseMarketingEventPublicDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function doUpsertWithHttpInfo($batch_input_marketing_event_create_request_params)
    {
        $request = $this->doUpsertRequest($batch_input_marketing_event_create_request_params);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\BatchResponseMarketingEventPublicDefaultResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\BatchResponseMarketingEventPublicDefaultResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\BatchResponseMarketingEventPublicDefaultResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\BatchResponseMarketingEventPublicDefaultResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\BatchResponseMarketingEventPublicDefaultResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation doUpsertAsync
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventCreateRequestParams $batch_input_marketing_event_create_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doUpsertAsync($batch_input_marketing_event_create_request_params)
    {
        return $this->doUpsertAsyncWithHttpInfo($batch_input_marketing_event_create_request_params)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation doUpsertAsyncWithHttpInfo
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventCreateRequestParams $batch_input_marketing_event_create_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doUpsertAsyncWithHttpInfo($batch_input_marketing_event_create_request_params)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\BatchResponseMarketingEventPublicDefaultResponse';
        $request = $this->doUpsertRequest($batch_input_marketing_event_create_request_params);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'doUpsert'
     *
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventCreateRequestParams $batch_input_marketing_event_create_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function doUpsertRequest($batch_input_marketing_event_create_request_params)
    {
        // verify the required parameter 'batch_input_marketing_event_create_request_params' is set
        if ($batch_input_marketing_event_create_request_params === null || (is_array($batch_input_marketing_event_create_request_params) && count($batch_input_marketing_event_create_request_params) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_marketing_event_create_request_params when calling doUpsert'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/upsert';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_marketing_event_create_request_params)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_marketing_event_create_request_params));
            } else {
                $httpBody = $batch_input_marketing_event_create_request_params;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation doUpsertById
     *
     * @param  string $external_event_id external_event_id (required)
     * @param  string $subscriber_state subscriber_state (required)
     * @param  string $external_account_id external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber batch_input_marketing_event_subscriber (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\Error
     */
    public function doUpsertById($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber)
    {
        list($response) = $this->doUpsertByIdWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber);
        return $response;
    }

    /**
     * Operation doUpsertByIdWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $subscriber_state (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function doUpsertByIdWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber)
    {
        $request = $this->doUpsertByIdRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation doUpsertByIdAsync
     *
     * @param  string $external_event_id (required)
     * @param  string $subscriber_state (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doUpsertByIdAsync($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber)
    {
        return $this->doUpsertByIdAsyncWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation doUpsertByIdAsyncWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $subscriber_state (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function doUpsertByIdAsyncWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
        $request = $this->doUpsertByIdRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'doUpsertById'
     *
     * @param  string $external_event_id (required)
     * @param  string $subscriber_state (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function doUpsertByIdRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber)
    {
        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling doUpsertById'
            );
        }
        // verify the required parameter 'subscriber_state' is set
        if ($subscriber_state === null || (is_array($subscriber_state) && count($subscriber_state) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscriber_state when calling doUpsertById'
            );
        }
        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling doUpsertById'
            );
        }
        // verify the required parameter 'batch_input_marketing_event_subscriber' is set
        if ($batch_input_marketing_event_subscriber === null || (is_array($batch_input_marketing_event_subscriber) && count($batch_input_marketing_event_subscriber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_marketing_event_subscriber when calling doUpsertById'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}/{subscriberState}/upsert';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_account_id,
            'externalAccountId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }
        // path params
        if ($subscriber_state !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriberState' . '}',
                ObjectSerializer::toPathValue($subscriber_state),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_input_marketing_event_subscriber)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_input_marketing_event_subscriber));
            } else {
                $httpBody = $batch_input_marketing_event_subscriber;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getById
     *
     * @param  string $external_event_id external_event_id (required)
     * @param  string $external_account_id external_account_id (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\MarketingEventPublicReadResponse|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function getById($external_event_id, $external_account_id)
    {
        list($response) = $this->getByIdWithHttpInfo($external_event_id, $external_account_id);
        return $response;
    }

    /**
     * Operation getByIdWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\MarketingEventPublicReadResponse|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getByIdWithHttpInfo($external_event_id, $external_account_id)
    {
        $request = $this->getByIdRequest($external_event_id, $external_account_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicReadResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicReadResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicReadResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicReadResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicReadResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getByIdAsync
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsync($external_event_id, $external_account_id)
    {
        return $this->getByIdAsyncWithHttpInfo($external_event_id, $external_account_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getByIdAsyncWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsyncWithHttpInfo($external_event_id, $external_account_id)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicReadResponse';
        $request = $this->getByIdRequest($external_event_id, $external_account_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getById'
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getByIdRequest($external_event_id, $external_account_id)
    {
        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling getById'
            );
        }
        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling getById'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_account_id,
            'externalAccountId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation replace
     *
     * @param  string $external_event_id external_event_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params marketing_event_create_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function replace($external_event_id, $marketing_event_create_request_params)
    {
        list($response) = $this->replaceWithHttpInfo($external_event_id, $marketing_event_create_request_params);
        return $response;
    }

    /**
     * Operation replaceWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function replaceWithHttpInfo($external_event_id, $marketing_event_create_request_params)
    {
        $request = $this->replaceRequest($external_event_id, $marketing_event_create_request_params);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation replaceAsync
     *
     * @param  string $external_event_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function replaceAsync($external_event_id, $marketing_event_create_request_params)
    {
        return $this->replaceAsyncWithHttpInfo($external_event_id, $marketing_event_create_request_params)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation replaceAsyncWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function replaceAsyncWithHttpInfo($external_event_id, $marketing_event_create_request_params)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse';
        $request = $this->replaceRequest($external_event_id, $marketing_event_create_request_params);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'replace'
     *
     * @param  string $external_event_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventCreateRequestParams $marketing_event_create_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function replaceRequest($external_event_id, $marketing_event_create_request_params)
    {
        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling replace'
            );
        }
        // verify the required parameter 'marketing_event_create_request_params' is set
        if ($marketing_event_create_request_params === null || (is_array($marketing_event_create_request_params) && count($marketing_event_create_request_params) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketing_event_create_request_params when calling replace'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($marketing_event_create_request_params)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($marketing_event_create_request_params));
            } else {
                $httpBody = $marketing_event_create_request_params;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation update
     *
     * @param  string $external_event_id external_event_id (required)
     * @param  string $external_account_id external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventUpdateRequestParams $marketing_event_update_request_params marketing_event_update_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function update($external_event_id, $external_account_id, $marketing_event_update_request_params)
    {
        list($response) = $this->updateWithHttpInfo($external_event_id, $external_account_id, $marketing_event_update_request_params);
        return $response;
    }

    /**
     * Operation updateWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventUpdateRequestParams $marketing_event_update_request_params (required)
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWithHttpInfo($external_event_id, $external_account_id, $marketing_event_update_request_params)
    {
        $request = $this->updateRequest($external_event_id, $external_account_id, $marketing_event_update_request_params);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateAsync
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventUpdateRequestParams $marketing_event_update_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAsync($external_event_id, $external_account_id, $marketing_event_update_request_params)
    {
        return $this->updateAsyncWithHttpInfo($external_event_id, $external_account_id, $marketing_event_update_request_params)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateAsyncWithHttpInfo
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventUpdateRequestParams $marketing_event_update_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAsyncWithHttpInfo($external_event_id, $external_account_id, $marketing_event_update_request_params)
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\MarketingEventPublicDefaultResponse';
        $request = $this->updateRequest($external_event_id, $external_account_id, $marketing_event_update_request_params);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'update'
     *
     * @param  string $external_event_id (required)
     * @param  string $external_account_id (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\MarketingEventUpdateRequestParams $marketing_event_update_request_params (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateRequest($external_event_id, $external_account_id, $marketing_event_update_request_params)
    {
        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling update'
            );
        }
        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling update'
            );
        }
        // verify the required parameter 'marketing_event_update_request_params' is set
        if ($marketing_event_update_request_params === null || (is_array($marketing_event_update_request_params) && count($marketing_event_update_request_params) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketing_event_update_request_params when calling update'
            );
        }

        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_account_id,
            'externalAccountId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', '*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', '*/*'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($marketing_event_update_request_params)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($marketing_event_update_request_params));
            } else {
                $httpBody = $marketing_event_update_request_params;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
