<?php
/**
 * PropertyValue
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Events Extension
 *
 * These APIs allow you to interact with HubSpot's Marketing Events Extension. It allows you to: * Create, Read or update Marketing Event information in HubSpot * Specify whether a HubSpot contact has registered, attended or cancelled a registration to a Marketing Event. * Specify a URL that can be called to get the details of a Marketing Event.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Events\Model;

use \ArrayAccess;
use \HubSpot\Client\Marketing\Events\ObjectSerializer;

/**
 * PropertyValue Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PropertyValue implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PropertyValue';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'value' => 'string',
        'timestamp' => 'int',
        'source_id' => 'string',
        'source_label' => 'string',
        'source' => 'string',
        'selected_by_user' => 'bool',
        'selected_by_user_timestamp' => 'int',
        'source_vid' => 'int[]',
        'source_metadata' => 'string',
        'request_id' => 'string',
        'updated_by_user_id' => 'int',
        'persistence_timestamp' => 'int',
        'use_timestamp_as_persistence_timestamp' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'value' => null,
        'timestamp' => 'int64',
        'source_id' => null,
        'source_label' => null,
        'source' => null,
        'selected_by_user' => null,
        'selected_by_user_timestamp' => 'int64',
        'source_vid' => 'int64',
        'source_metadata' => null,
        'request_id' => null,
        'updated_by_user_id' => 'int32',
        'persistence_timestamp' => 'int64',
        'use_timestamp_as_persistence_timestamp' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'value' => 'value',
        'timestamp' => 'timestamp',
        'source_id' => 'sourceId',
        'source_label' => 'sourceLabel',
        'source' => 'source',
        'selected_by_user' => 'selectedByUser',
        'selected_by_user_timestamp' => 'selectedByUserTimestamp',
        'source_vid' => 'sourceVid',
        'source_metadata' => 'sourceMetadata',
        'request_id' => 'requestId',
        'updated_by_user_id' => 'updatedByUserId',
        'persistence_timestamp' => 'persistenceTimestamp',
        'use_timestamp_as_persistence_timestamp' => 'useTimestampAsPersistenceTimestamp'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'value' => 'setValue',
        'timestamp' => 'setTimestamp',
        'source_id' => 'setSourceId',
        'source_label' => 'setSourceLabel',
        'source' => 'setSource',
        'selected_by_user' => 'setSelectedByUser',
        'selected_by_user_timestamp' => 'setSelectedByUserTimestamp',
        'source_vid' => 'setSourceVid',
        'source_metadata' => 'setSourceMetadata',
        'request_id' => 'setRequestId',
        'updated_by_user_id' => 'setUpdatedByUserId',
        'persistence_timestamp' => 'setPersistenceTimestamp',
        'use_timestamp_as_persistence_timestamp' => 'setUseTimestampAsPersistenceTimestamp'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'value' => 'getValue',
        'timestamp' => 'getTimestamp',
        'source_id' => 'getSourceId',
        'source_label' => 'getSourceLabel',
        'source' => 'getSource',
        'selected_by_user' => 'getSelectedByUser',
        'selected_by_user_timestamp' => 'getSelectedByUserTimestamp',
        'source_vid' => 'getSourceVid',
        'source_metadata' => 'getSourceMetadata',
        'request_id' => 'getRequestId',
        'updated_by_user_id' => 'getUpdatedByUserId',
        'persistence_timestamp' => 'getPersistenceTimestamp',
        'use_timestamp_as_persistence_timestamp' => 'getUseTimestampAsPersistenceTimestamp'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const SOURCE_IMPORT = 'IMPORT';
    public const SOURCE_API = 'API';
    public const SOURCE_FORM = 'FORM';
    public const SOURCE_ANALYTICS = 'ANALYTICS';
    public const SOURCE_MIGRATION = 'MIGRATION';
    public const SOURCE_SALESFORCE = 'SALESFORCE';
    public const SOURCE_INTEGRATION = 'INTEGRATION';
    public const SOURCE_CONTACTS_WEB = 'CONTACTS_WEB';
    public const SOURCE_WAL_INCREMENTAL = 'WAL_INCREMENTAL';
    public const SOURCE_TASK = 'TASK';
    public const SOURCE_EMAIL = 'EMAIL';
    public const SOURCE_WORKFLOWS = 'WORKFLOWS';
    public const SOURCE_CALCULATED = 'CALCULATED';
    public const SOURCE_SOCIAL = 'SOCIAL';
    public const SOURCE_BATCH_UPDATE = 'BATCH_UPDATE';
    public const SOURCE_SIGNALS = 'SIGNALS';
    public const SOURCE_BIDEN = 'BIDEN';
    public const SOURCE__DEFAULT = 'DEFAULT';
    public const SOURCE_COMPANIES = 'COMPANIES';
    public const SOURCE_DEALS = 'DEALS';
    public const SOURCE_ASSISTS = 'ASSISTS';
    public const SOURCE_PRESENTATIONS = 'PRESENTATIONS';
    public const SOURCE_TALLY = 'TALLY';
    public const SOURCE_SIDEKICK = 'SIDEKICK';
    public const SOURCE_CRM_UI = 'CRM_UI';
    public const SOURCE_MERGE_CONTACTS = 'MERGE_CONTACTS';
    public const SOURCE_PORTAL_USER_ASSOCIATOR = 'PORTAL_USER_ASSOCIATOR';
    public const SOURCE_INTEGRATIONS_PLATFORM = 'INTEGRATIONS_PLATFORM';
    public const SOURCE_BCC_TO_CRM = 'BCC_TO_CRM';
    public const SOURCE_FORWARD_TO_CRM = 'FORWARD_TO_CRM';
    public const SOURCE_ENGAGEMENTS = 'ENGAGEMENTS';
    public const SOURCE_SALES = 'SALES';
    public const SOURCE_HEISENBERG = 'HEISENBERG';
    public const SOURCE_LEADIN = 'LEADIN';
    public const SOURCE_GMAIL_INTEGRATION = 'GMAIL_INTEGRATION';
    public const SOURCE_ACADEMY = 'ACADEMY';
    public const SOURCE_SALES_MESSAGES = 'SALES_MESSAGES';
    public const SOURCE_AVATARS_SERVICE = 'AVATARS_SERVICE';
    public const SOURCE_MERGE_COMPANIES = 'MERGE_COMPANIES';
    public const SOURCE_SEQUENCES = 'SEQUENCES';
    public const SOURCE_COMPANY_FAMILIES = 'COMPANY_FAMILIES';
    public const SOURCE_MOBILE_IOS = 'MOBILE_IOS';
    public const SOURCE_MOBILE_ANDROID = 'MOBILE_ANDROID';
    public const SOURCE_CONTACTS = 'CONTACTS';
    public const SOURCE_ASSOCIATIONS = 'ASSOCIATIONS';
    public const SOURCE_EXTENSION = 'EXTENSION';
    public const SOURCE_SUCCESS = 'SUCCESS';
    public const SOURCE_BOT = 'BOT';
    public const SOURCE_INTEGRATIONS_SYNC = 'INTEGRATIONS_SYNC';
    public const SOURCE_AUTOMATION_PLATFORM = 'AUTOMATION_PLATFORM';
    public const SOURCE_CONVERSATIONS = 'CONVERSATIONS';
    public const SOURCE_EMAIL_INTEGRATION = 'EMAIL_INTEGRATION';
    public const SOURCE_CONTENT_MEMBERSHIP = 'CONTENT_MEMBERSHIP';
    public const SOURCE_QUOTES = 'QUOTES';
    public const SOURCE_BET_ASSIGNMENT = 'BET_ASSIGNMENT';
    public const SOURCE_QUOTAS = 'QUOTAS';
    public const SOURCE_BET_CRM_CONNECTOR = 'BET_CRM_CONNECTOR';
    public const SOURCE_MEETINGS = 'MEETINGS';
    public const SOURCE_MERGE_OBJECTS = 'MERGE_OBJECTS';
    public const SOURCE_RECYCLING_BIN = 'RECYCLING_BIN';
    public const SOURCE_ADS = 'ADS';
    public const SOURCE_AI_GROUP = 'AI_GROUP';
    public const SOURCE_COMMUNICATOR = 'COMMUNICATOR';
    public const SOURCE_SETTINGS = 'SETTINGS';
    public const SOURCE_PROPERTY_SETTINGS = 'PROPERTY_SETTINGS';
    public const SOURCE_PIPELINE_SETTINGS = 'PIPELINE_SETTINGS';
    public const SOURCE_COMPANY_INSIGHTS = 'COMPANY_INSIGHTS';
    public const SOURCE_BEHAVIORAL_EVENTS = 'BEHAVIORAL_EVENTS';
    public const SOURCE_PAYMENTS = 'PAYMENTS';
    public const SOURCE_GOALS = 'GOALS';
    public const SOURCE_PORTAL_OBJECT_SYNC = 'PORTAL_OBJECT_SYNC';
    public const SOURCE_APPROVALS = 'APPROVALS';
    public const SOURCE_FILE_MANAGER = 'FILE_MANAGER';
    public const SOURCE_MARKETPLACE = 'MARKETPLACE';
    public const SOURCE_INTERNAL_PROCESSING = 'INTERNAL_PROCESSING';
    public const SOURCE_FORECASTING = 'FORECASTING';
    public const SOURCE_SLACK_INTEGRATION = 'SLACK_INTEGRATION';
    public const SOURCE_CRM_UI_BULK_ACTION = 'CRM_UI_BULK_ACTION';
    public const SOURCE_WORKFLOW_CONTACT_DELETE_ACTION = 'WORKFLOW_CONTACT_DELETE_ACTION';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSourceAllowableValues()
    {
        return [
            self::SOURCE_IMPORT,
            self::SOURCE_API,
            self::SOURCE_FORM,
            self::SOURCE_ANALYTICS,
            self::SOURCE_MIGRATION,
            self::SOURCE_SALESFORCE,
            self::SOURCE_INTEGRATION,
            self::SOURCE_CONTACTS_WEB,
            self::SOURCE_WAL_INCREMENTAL,
            self::SOURCE_TASK,
            self::SOURCE_EMAIL,
            self::SOURCE_WORKFLOWS,
            self::SOURCE_CALCULATED,
            self::SOURCE_SOCIAL,
            self::SOURCE_BATCH_UPDATE,
            self::SOURCE_SIGNALS,
            self::SOURCE_BIDEN,
            self::SOURCE__DEFAULT,
            self::SOURCE_COMPANIES,
            self::SOURCE_DEALS,
            self::SOURCE_ASSISTS,
            self::SOURCE_PRESENTATIONS,
            self::SOURCE_TALLY,
            self::SOURCE_SIDEKICK,
            self::SOURCE_CRM_UI,
            self::SOURCE_MERGE_CONTACTS,
            self::SOURCE_PORTAL_USER_ASSOCIATOR,
            self::SOURCE_INTEGRATIONS_PLATFORM,
            self::SOURCE_BCC_TO_CRM,
            self::SOURCE_FORWARD_TO_CRM,
            self::SOURCE_ENGAGEMENTS,
            self::SOURCE_SALES,
            self::SOURCE_HEISENBERG,
            self::SOURCE_LEADIN,
            self::SOURCE_GMAIL_INTEGRATION,
            self::SOURCE_ACADEMY,
            self::SOURCE_SALES_MESSAGES,
            self::SOURCE_AVATARS_SERVICE,
            self::SOURCE_MERGE_COMPANIES,
            self::SOURCE_SEQUENCES,
            self::SOURCE_COMPANY_FAMILIES,
            self::SOURCE_MOBILE_IOS,
            self::SOURCE_MOBILE_ANDROID,
            self::SOURCE_CONTACTS,
            self::SOURCE_ASSOCIATIONS,
            self::SOURCE_EXTENSION,
            self::SOURCE_SUCCESS,
            self::SOURCE_BOT,
            self::SOURCE_INTEGRATIONS_SYNC,
            self::SOURCE_AUTOMATION_PLATFORM,
            self::SOURCE_CONVERSATIONS,
            self::SOURCE_EMAIL_INTEGRATION,
            self::SOURCE_CONTENT_MEMBERSHIP,
            self::SOURCE_QUOTES,
            self::SOURCE_BET_ASSIGNMENT,
            self::SOURCE_QUOTAS,
            self::SOURCE_BET_CRM_CONNECTOR,
            self::SOURCE_MEETINGS,
            self::SOURCE_MERGE_OBJECTS,
            self::SOURCE_RECYCLING_BIN,
            self::SOURCE_ADS,
            self::SOURCE_AI_GROUP,
            self::SOURCE_COMMUNICATOR,
            self::SOURCE_SETTINGS,
            self::SOURCE_PROPERTY_SETTINGS,
            self::SOURCE_PIPELINE_SETTINGS,
            self::SOURCE_COMPANY_INSIGHTS,
            self::SOURCE_BEHAVIORAL_EVENTS,
            self::SOURCE_PAYMENTS,
            self::SOURCE_GOALS,
            self::SOURCE_PORTAL_OBJECT_SYNC,
            self::SOURCE_APPROVALS,
            self::SOURCE_FILE_MANAGER,
            self::SOURCE_MARKETPLACE,
            self::SOURCE_INTERNAL_PROCESSING,
            self::SOURCE_FORECASTING,
            self::SOURCE_SLACK_INTEGRATION,
            self::SOURCE_CRM_UI_BULK_ACTION,
            self::SOURCE_WORKFLOW_CONTACT_DELETE_ACTION,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = $data['name'] ?? null;
        $this->container['value'] = $data['value'] ?? null;
        $this->container['timestamp'] = $data['timestamp'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['source_label'] = $data['source_label'] ?? null;
        $this->container['source'] = $data['source'] ?? null;
        $this->container['selected_by_user'] = $data['selected_by_user'] ?? null;
        $this->container['selected_by_user_timestamp'] = $data['selected_by_user_timestamp'] ?? null;
        $this->container['source_vid'] = $data['source_vid'] ?? null;
        $this->container['source_metadata'] = $data['source_metadata'] ?? null;
        $this->container['request_id'] = $data['request_id'] ?? null;
        $this->container['updated_by_user_id'] = $data['updated_by_user_id'] ?? null;
        $this->container['persistence_timestamp'] = $data['persistence_timestamp'] ?? null;
        $this->container['use_timestamp_as_persistence_timestamp'] = $data['use_timestamp_as_persistence_timestamp'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['value'] === null) {
            $invalidProperties[] = "'value' can't be null";
        }
        if ($this->container['timestamp'] === null) {
            $invalidProperties[] = "'timestamp' can't be null";
        }
        if ($this->container['source_id'] === null) {
            $invalidProperties[] = "'source_id' can't be null";
        }
        if ($this->container['source_label'] === null) {
            $invalidProperties[] = "'source_label' can't be null";
        }
        if ($this->container['source'] === null) {
            $invalidProperties[] = "'source' can't be null";
        }
        $allowedValues = $this->getSourceAllowableValues();
        if (!is_null($this->container['source']) && !in_array($this->container['source'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'source', must be one of '%s'",
                $this->container['source'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['selected_by_user'] === null) {
            $invalidProperties[] = "'selected_by_user' can't be null";
        }
        if ($this->container['selected_by_user_timestamp'] === null) {
            $invalidProperties[] = "'selected_by_user_timestamp' can't be null";
        }
        if ($this->container['source_vid'] === null) {
            $invalidProperties[] = "'source_vid' can't be null";
        }
        if ($this->container['source_metadata'] === null) {
            $invalidProperties[] = "'source_metadata' can't be null";
        }
        if ($this->container['request_id'] === null) {
            $invalidProperties[] = "'request_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets value
     *
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param string $value value
     *
     * @return self
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets timestamp
     *
     * @return int
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     *
     * @param int $timestamp timestamp
     *
     * @return self
     */
    public function setTimestamp($timestamp)
    {
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string $source_id source_id
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets source_label
     *
     * @return string
     */
    public function getSourceLabel()
    {
        return $this->container['source_label'];
    }

    /**
     * Sets source_label
     *
     * @param string $source_label source_label
     *
     * @return self
     */
    public function setSourceLabel($source_label)
    {
        $this->container['source_label'] = $source_label;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string $source source
     *
     * @return self
     */
    public function setSource($source)
    {
        $allowedValues = $this->getSourceAllowableValues();
        if (!in_array($source, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'source', must be one of '%s'",
                    $source,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets selected_by_user
     *
     * @return bool
     */
    public function getSelectedByUser()
    {
        return $this->container['selected_by_user'];
    }

    /**
     * Sets selected_by_user
     *
     * @param bool $selected_by_user selected_by_user
     *
     * @return self
     */
    public function setSelectedByUser($selected_by_user)
    {
        $this->container['selected_by_user'] = $selected_by_user;

        return $this;
    }

    /**
     * Gets selected_by_user_timestamp
     *
     * @return int
     */
    public function getSelectedByUserTimestamp()
    {
        return $this->container['selected_by_user_timestamp'];
    }

    /**
     * Sets selected_by_user_timestamp
     *
     * @param int $selected_by_user_timestamp selected_by_user_timestamp
     *
     * @return self
     */
    public function setSelectedByUserTimestamp($selected_by_user_timestamp)
    {
        $this->container['selected_by_user_timestamp'] = $selected_by_user_timestamp;

        return $this;
    }

    /**
     * Gets source_vid
     *
     * @return int[]
     */
    public function getSourceVid()
    {
        return $this->container['source_vid'];
    }

    /**
     * Sets source_vid
     *
     * @param int[] $source_vid source_vid
     *
     * @return self
     */
    public function setSourceVid($source_vid)
    {
        $this->container['source_vid'] = $source_vid;

        return $this;
    }

    /**
     * Gets source_metadata
     *
     * @return string
     */
    public function getSourceMetadata()
    {
        return $this->container['source_metadata'];
    }

    /**
     * Sets source_metadata
     *
     * @param string $source_metadata Source metadata encoded as a base64 string. For example: `ZXhhbXBsZSBzdHJpbmc=`
     *
     * @return self
     */
    public function setSourceMetadata($source_metadata)
    {
        $this->container['source_metadata'] = $source_metadata;

        return $this;
    }

    /**
     * Gets request_id
     *
     * @return string
     */
    public function getRequestId()
    {
        return $this->container['request_id'];
    }

    /**
     * Sets request_id
     *
     * @param string $request_id request_id
     *
     * @return self
     */
    public function setRequestId($request_id)
    {
        $this->container['request_id'] = $request_id;

        return $this;
    }

    /**
     * Gets updated_by_user_id
     *
     * @return int|null
     */
    public function getUpdatedByUserId()
    {
        return $this->container['updated_by_user_id'];
    }

    /**
     * Sets updated_by_user_id
     *
     * @param int|null $updated_by_user_id updated_by_user_id
     *
     * @return self
     */
    public function setUpdatedByUserId($updated_by_user_id)
    {
        $this->container['updated_by_user_id'] = $updated_by_user_id;

        return $this;
    }

    /**
     * Gets persistence_timestamp
     *
     * @return int|null
     */
    public function getPersistenceTimestamp()
    {
        return $this->container['persistence_timestamp'];
    }

    /**
     * Sets persistence_timestamp
     *
     * @param int|null $persistence_timestamp persistence_timestamp
     *
     * @return self
     */
    public function setPersistenceTimestamp($persistence_timestamp)
    {
        $this->container['persistence_timestamp'] = $persistence_timestamp;

        return $this;
    }

    /**
     * Gets use_timestamp_as_persistence_timestamp
     *
     * @return bool|null
     */
    public function getUseTimestampAsPersistenceTimestamp()
    {
        return $this->container['use_timestamp_as_persistence_timestamp'];
    }

    /**
     * Sets use_timestamp_as_persistence_timestamp
     *
     * @param bool|null $use_timestamp_as_persistence_timestamp use_timestamp_as_persistence_timestamp
     *
     * @return self
     */
    public function setUseTimestampAsPersistenceTimestamp($use_timestamp_as_persistence_timestamp)
    {
        $this->container['use_timestamp_as_persistence_timestamp'] = $use_timestamp_as_persistence_timestamp;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


