<?php
/**
 * UserProvisionRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Settings\Users
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Users
 *
 * Add, manage, and remove users from your account
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Settings\Users\Model;

use \ArrayAccess;
use \HubSpot\Client\Settings\Users\ObjectSerializer;

/**
 * UserProvisionRequest Class Doc Comment
 *
 * @category Class
 * @description A user creation request
 * @package  HubSpot\Client\Settings\Users
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UserProvisionRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UserProvisionRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'email' => 'string',
        'role_id' => 'string',
        'primary_team_id' => 'string',
        'secondary_team_ids' => 'string[]',
        'send_welcome_email' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'email' => null,
        'role_id' => null,
        'primary_team_id' => null,
        'secondary_team_ids' => null,
        'send_welcome_email' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'email' => 'email',
        'role_id' => 'roleId',
        'primary_team_id' => 'primaryTeamId',
        'secondary_team_ids' => 'secondaryTeamIds',
        'send_welcome_email' => 'sendWelcomeEmail'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'email' => 'setEmail',
        'role_id' => 'setRoleId',
        'primary_team_id' => 'setPrimaryTeamId',
        'secondary_team_ids' => 'setSecondaryTeamIds',
        'send_welcome_email' => 'setSendWelcomeEmail'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'email' => 'getEmail',
        'role_id' => 'getRoleId',
        'primary_team_id' => 'getPrimaryTeamId',
        'secondary_team_ids' => 'getSecondaryTeamIds',
        'send_welcome_email' => 'getSendWelcomeEmail'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['email'] = $data['email'] ?? null;
        $this->container['role_id'] = $data['role_id'] ?? null;
        $this->container['primary_team_id'] = $data['primary_team_id'] ?? null;
        $this->container['secondary_team_ids'] = $data['secondary_team_ids'] ?? null;
        $this->container['send_welcome_email'] = $data['send_welcome_email'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['email'] === null) {
            $invalidProperties[] = "'email' can't be null";
        }
        if ($this->container['send_welcome_email'] === null) {
            $invalidProperties[] = "'send_welcome_email' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string $email The created user's email
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets role_id
     *
     * @return string|null
     */
    public function getRoleId()
    {
        return $this->container['role_id'];
    }

    /**
     * Sets role_id
     *
     * @param string|null $role_id The user's role
     *
     * @return self
     */
    public function setRoleId($role_id)
    {
        $this->container['role_id'] = $role_id;

        return $this;
    }

    /**
     * Gets primary_team_id
     *
     * @return string|null
     */
    public function getPrimaryTeamId()
    {
        return $this->container['primary_team_id'];
    }

    /**
     * Sets primary_team_id
     *
     * @param string|null $primary_team_id The user's primary team
     *
     * @return self
     */
    public function setPrimaryTeamId($primary_team_id)
    {
        $this->container['primary_team_id'] = $primary_team_id;

        return $this;
    }

    /**
     * Gets secondary_team_ids
     *
     * @return string[]|null
     */
    public function getSecondaryTeamIds()
    {
        return $this->container['secondary_team_ids'];
    }

    /**
     * Sets secondary_team_ids
     *
     * @param string[]|null $secondary_team_ids The user's additional teams
     *
     * @return self
     */
    public function setSecondaryTeamIds($secondary_team_ids)
    {
        $this->container['secondary_team_ids'] = $secondary_team_ids;

        return $this;
    }

    /**
     * Gets send_welcome_email
     *
     * @return bool
     */
    public function getSendWelcomeEmail()
    {
        return $this->container['send_welcome_email'];
    }

    /**
     * Sets send_welcome_email
     *
     * @param bool $send_welcome_email Whether to send a welcome email
     *
     * @return self
     */
    public function setSendWelcomeEmail($send_welcome_email)
    {
        $this->container['send_welcome_email'] = $send_welcome_email;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


